/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASEvent;
import com.ibm.ras.RASITraceEvent;
import com.ibm.ras.RASITraceLogger;
import com.ibm.ras.RASTraceFormatter;
import com.ibm.ras.RASUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class RASTraceEvent
extends RASEvent
implements RASITraceEvent {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final long serialVersionUID = -2004164315649535547L;

    public RASTraceEvent() {
        this.setAttribute("threadID", Thread.currentThread().getName());
        this.setMessageEvent(false);
    }

    protected RASTraceEvent(long l, String string, Object[] objectArray) {
        super(l, string, objectArray);
        this.setAttribute("threadID", Thread.currentThread().getName());
        this.setMessageEvent(false);
    }

    protected RASTraceEvent(long l, String string, String[] stringArray) {
        this(l, string, (Object[])stringArray);
    }

    public RASTraceEvent(long l, String string, Object[] objectArray, String string2, String string3, RASITraceLogger rASITraceLogger, String string4, String string5, Throwable throwable) {
        this(l, string, objectArray);
        if (string2 != null) {
            this.setAttribute("loggingClass", string2);
        }
        if (string3 != null) {
            this.setAttribute("loggingMethod", string3);
        }
        if (rASITraceLogger != null) {
            this.setAttribute("logger", rASITraceLogger.getName());
        }
        if (string4 != null) {
            this.setAttribute("server", string4);
        }
        if (string5 != null) {
            this.setAttribute("client", string5);
        }
        if (throwable != null) {
            this.setAttribute("exception", throwable);
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.setAttribute("exceptionTrace", stringWriter.toString());
        }
    }

    public RASTraceEvent(long l, String string, String[] stringArray, String string2, String string3, RASITraceLogger rASITraceLogger, String string4, String string5, Throwable throwable) {
        this(l, string, (Object[])stringArray, string2, string3, rASITraceLogger, string4, string5, throwable);
    }

    public RASTraceEvent(long l, String string, String string2, RASITraceLogger rASITraceLogger, String string3, String string4, byte[] byArray) {
        this();
        this.setType(l);
        if (string != null) {
            this.setAttribute("loggingClass", string);
        }
        if (string2 != null) {
            this.setAttribute("loggingMethod", string2);
        }
        if (rASITraceLogger != null) {
            this.setAttribute("logger", rASITraceLogger.getName());
        }
        if (string3 != null) {
            this.setAttribute("server", string3);
        }
        if (string4 != null) {
            this.setAttribute("client", string4);
        }
        if (byArray != null) {
            this.setAttribute("hexData", byArray);
        }
    }

    public Hashtable getSupportedTypes() {
        Hashtable hashtable = super.getSupportedTypes();
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_API"), new Long(1L));
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_CALLBACK"), new Long(2L));
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_ENTRY_EXIT"), new Long(4L));
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_ERROR_EXC"), new Long(8L));
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_MISC_DATA"), new Long(16L));
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_OBJ_CREATE"), new Long(32L));
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_OBJ_DELETE"), new Long(64L));
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_PRIVATE"), new Long(128L));
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_PUBLIC"), new Long(256L));
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_STATIC"), new Long(512L));
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_SVC"), new Long(1024L));
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_LEVEL1"), new Long(2048L));
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_LEVEL2"), new Long(4096L));
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_LEVEL3"), new Long(8192L));
        hashtable.put(RASUtil.rasMsgs.getMessage("TYPE_PERF"), new Long(16384L));
        return hashtable;
    }

    public long maskLongValue(String string) {
        long l = super.maskLongValue(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("TYPE_API")) {
                l |= 1L;
                continue;
            }
            if (string2.equals("TYPE_CALLBACK")) {
                l |= 2L;
                continue;
            }
            if (string2.equals("TYPE_ENTRY_EXIT")) {
                l |= 4L;
                continue;
            }
            if (string2.equals("TYPE_ERROR_EXC")) {
                l |= 8L;
                continue;
            }
            if (string2.equals("TYPE_MISC_DATA")) {
                l |= 0x10L;
                continue;
            }
            if (string2.equals("TYPE_OBJ_CREATE")) {
                l |= 0x20L;
                continue;
            }
            if (string2.equals("TYPE_OBJ_DELETE")) {
                l |= 0x40L;
                continue;
            }
            if (string2.equals("TYPE_PRIVATE")) {
                l |= 0x80L;
                continue;
            }
            if (string2.equals("TYPE_PUBLIC")) {
                l |= 0x100L;
                continue;
            }
            if (string2.equals("TYPE_STATIC")) {
                l |= 0x200L;
                continue;
            }
            if (string2.equals("TYPE_SVC")) {
                l |= 0x400L;
                continue;
            }
            if (string2.equals("TYPE_LEVEL1")) {
                l |= 0x800L;
                continue;
            }
            if (string2.equals("TYPE_LEVEL2")) {
                l |= 0x1000L;
                continue;
            }
            if (string2.equals("TYPE_LEVEL3")) {
                l |= 0x2000L;
                continue;
            }
            if (string2.equals("TYPE_PERF")) {
                l |= 0x4000L;
                continue;
            }
            if (string2.equals("DEFAULT_TRACE_MASK")) {
                l |= 0x7FFL;
                continue;
            }
            if (!string2.equals("ALL_TRACE_MASK")) continue;
            l |= 0xFFFFFFFFFFFFFFFFL;
        }
        return l;
    }

    public String maskToString(long l) {
        StringBuffer stringBuffer = new StringBuffer(super.maskToString(l));
        if ((l & 1L) != 0L) {
            stringBuffer.append("TYPE_API ");
        }
        if ((l & 2L) != 0L) {
            stringBuffer.append("TYPE_CALLBACK ");
        }
        if ((l & 4L) != 0L) {
            stringBuffer.append("TYPE_ENTRY_EXIT ");
        }
        if ((l & 8L) != 0L) {
            stringBuffer.append("TYPE_ERROR_EXC ");
        }
        if ((l & 0x10L) != 0L) {
            stringBuffer.append("TYPE_MISC_DATA ");
        }
        if ((l & 0x20L) != 0L) {
            stringBuffer.append("TYPE_OBJ_CREATE ");
        }
        if ((l & 0x40L) != 0L) {
            stringBuffer.append("TYPE_OBJ_DELETE ");
        }
        if ((l & 0x80L) != 0L) {
            stringBuffer.append("TYPE_PRIVATE ");
        }
        if ((l & 0x100L) != 0L) {
            stringBuffer.append("TYPE_PUBLIC ");
        }
        if ((l & 0x200L) != 0L) {
            stringBuffer.append("TYPE_STATIC ");
        }
        if ((l & 0x400L) != 0L) {
            stringBuffer.append("TYPE_SVC ");
        }
        if ((l & 0x800L) != 0L) {
            stringBuffer.append("TYPE_LEVEL1 ");
        }
        if ((l & 0x1000L) != 0L) {
            stringBuffer.append("TYPE_LEVEL2 ");
        }
        if ((l & 0x2000L) != 0L) {
            stringBuffer.append("TYPE_LEVEL3 ");
        }
        if ((l & 0x4000L) != 0L) {
            stringBuffer.append("TYPE_PERF ");
        }
        return stringBuffer.toString().trim();
    }

    public String toString() {
        RASTraceFormatter rASTraceFormatter = new RASTraceFormatter();
        return rASTraceFormatter.format(this);
    }
}

