/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceEnableEvent;
import com.ibm.ws.logging.LevelConstants;

public class TraceElement {
    int ivLevel;
    String ivName;
    boolean ivDebugEnabled;
    boolean ivEventEnabled;
    boolean ivEntryEnabled;
    boolean ivDetailEnabled;
    boolean ivConfigEnabled;
    boolean ivInfoEnabled;
    boolean ivServiceEnabled;
    boolean ivWarningEnabled;
    boolean ivErrorEnabled;
    boolean ivFatalEnabled;

    TraceElement(String string) {
        this.ivName = string;
        this.ivLevel = 8;
        this.setInstanceVariables();
    }

    public final String getName() {
        return this.ivName;
    }

    public final boolean isDebugEnabled() {
        return this.ivDebugEnabled;
    }

    public final boolean isEntryEnabled() {
        return this.ivEntryEnabled;
    }

    public final boolean isEventEnabled() {
        return this.ivEventEnabled;
    }

    public final boolean isDetailEnabled() {
        return this.ivDetailEnabled;
    }

    public final boolean isConfigEnabled() {
        return this.ivConfigEnabled;
    }

    public final boolean isInfoEnabled() {
        return this.ivInfoEnabled;
    }

    public final boolean isAuditEnabled() {
        return this.ivServiceEnabled;
    }

    public final boolean isWarningEnabled() {
        return this.ivWarningEnabled;
    }

    public final boolean isErrorEnabled() {
        return this.ivErrorEnabled;
    }

    public final boolean isFatalEnabled() {
        return this.ivFatalEnabled;
    }

    public final boolean isServiceEnabled() {
        return this.ivServiceEnabled;
    }

    String getTraceSpecification() {
        StringBuffer stringBuffer = new StringBuffer(this.ivName);
        stringBuffer.append("=").append(LevelConstants.NAMES[this.ivLevel]);
        return new String(stringBuffer);
    }

    String getStartsWith(String string, int n) {
        int n2 = string.length();
        String string2 = "";
        if (this.ivName.startsWith(string)) {
            String string3 = this.ivName.substring(n2);
            if (string3.startsWith(".")) {
                string3 = string3.substring(1);
            }
            String[] stringArray = RasHelper.split(string3, 46);
            StringBuffer stringBuffer = new StringBuffer(string3.length());
            int n3 = stringArray.length;
            for (int i = n; i < n3 - 1; ++i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append('.');
            }
            if (n < n3) {
                stringBuffer.append(stringArray[n3 - 1]);
            }
            string2 = new String(stringBuffer);
        }
        return string2;
    }

    void applyTraceEnableEvent(TraceEnableEvent traceEnableEvent) {
        this.ivLevel = traceEnableEvent.getType();
        this.setInstanceVariables();
    }

    public final int getLevel() {
        return this.ivLevel;
    }

    protected void setInstanceVariables() {
        this.ivDebugEnabled = this.isLevelEnabled(3);
        this.ivEntryEnabled = this.isLevelEnabled(5);
        this.ivEventEnabled = this.isLevelEnabled(7);
        this.ivDetailEnabled = this.isLevelEnabled(8);
        this.ivConfigEnabled = this.isLevelEnabled(9);
        this.ivInfoEnabled = this.isLevelEnabled(10);
        this.ivServiceEnabled = this.isLevelEnabled(11);
        this.ivWarningEnabled = this.isLevelEnabled(12);
        this.ivErrorEnabled = this.isLevelEnabled(14);
        this.ivFatalEnabled = this.isLevelEnabled(15);
    }

    protected boolean isLevelEnabled(int n) {
        return LevelConstants.DISTINCT_LEVELS[this.ivLevel] <= LevelConstants.DISTINCT_LEVELS[n];
    }
}

