/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ExtendedORBInitInfo;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.RasContextManager;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class RasContextSupport
extends LocalObject
implements ORBInitializer,
ClientRequestInterceptor,
ServerRequestInterceptor {
    private static final long serialVersionUID = -8316581876169651371L;
    private static final TraceComponent tc = Tr.register(RasContextSupport.class);
    private static final int RasServiceId = 1229081858;
    private static String serverNameSuffix = null;
    private static String hostNameSuffix = null;
    private static long serverCounter = 1L;
    private static Object serverCounterMutex = new Object();
    private static final int millisecondsInAYear = 31536000;
    private static int uowBufferSize = 16;

    public void pre_init(ORBInitInfo oRBInitInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pre_init", oRBInitInfo);
        }
        if (RasProperties.isUnitOfWorkEnabled()) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Installing RAS request interceptor");
            }
            if (!RasContextManager.initialized) {
                try {
                    ((ExtendedORBInitInfo)oRBInitInfo).add_client_request_interceptor((ClientRequestInterceptor)this, false);
                    ((ExtendedORBInitInfo)oRBInitInfo).add_server_request_interceptor((ServerRequestInterceptor)this, false);
                }
                catch (DuplicateName duplicateName) {
                    return;
                }
            }
            if (RasHelper.isServer()) {
                if (serverNameSuffix == null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append('-');
                    stringBuffer.append(RasHelper.getProcessId());
                    stringBuffer.append(':');
                    stringBuffer.append(RasHelper.getServerName());
                    serverNameSuffix = new String(stringBuffer);
                    uowBufferSize = serverNameSuffix.length() + 8;
                }
            } else if (hostNameSuffix == null) {
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    long l = System.currentTimeMillis();
                    stringBuffer.append('-');
                    stringBuffer.append(l % 31536000L);
                    stringBuffer.append(':');
                    String string = RasHelper.getHostName();
                    stringBuffer.append(string);
                }
                catch (RasException rasException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Hostname cannot be determined");
                    }
                    stringBuffer.append("Unknown");
                }
                hostNameSuffix = new String(stringBuffer);
                uowBufferSize = hostNameSuffix.length() + 16;
            }
            RasContextManager.initialized = true;
        } else if (tc.isEventEnabled()) {
            Tr.event(tc, "Not installing RAS request interceptor");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pre_init");
        }
    }

    public void send_request(ClientRequestInfo clientRequestInfo) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "send_request", clientRequestInfo);
            }
            String string = null;
            byte[] byArray = null;
            try {
                StringBuffer stringBuffer;
                if (RasHelper.isServer()) {
                    string = RasContextManager.getUnitOfWork();
                } else {
                    stringBuffer = new StringBuffer(uowBufferSize);
                    stringBuffer.append(clientRequestInfo.request_id());
                    stringBuffer.append('-');
                    stringBuffer.append(Integer.toHexString(Thread.currentThread().hashCode()));
                    stringBuffer.append(hostNameSuffix);
                    string = new String(stringBuffer);
                    RasContextManager.setUnitOfWork(string);
                }
                if (string != null) {
                    stringBuffer = (ORB)((LocalObject)clientRequestInfo)._orb();
                    CDROutputStream cDROutputStream = ORB.createCDROutputStream((ORB)stringBuffer);
                    cDROutputStream.putEndian();
                    cDROutputStream.write_string(string);
                    cDROutputStream.write_ulong(0);
                    byArray = cDROutputStream.toByteArray();
                    ServiceContext serviceContext = new ServiceContext(1229081858, byArray);
                    clientRequestInfo.add_request_service_context(serviceContext, true);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Exception during client request ", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send_request");
        }
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive_request(ServerRequestInfo serverRequestInfo) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "receive_request", serverRequestInfo);
            }
            ServiceContext serviceContext = null;
            serviceContext = ((ExtendedServerRequestInfo)serverRequestInfo).getRequestServiceContext(1229081858);
            try {
                if (serviceContext != null) {
                    byte[] byArray = serviceContext.context_data;
                    ORB oRB = (ORB)((LocalObject)serverRequestInfo)._orb();
                    CDRInputStream cDRInputStream = ORB.createCDRInputStream((ORB)oRB, (byte[])byArray, (int)byArray.length);
                    cDRInputStream.consumeEndian();
                    RasContextManager.setUnitOfWork(cDRInputStream.read_string());
                    break block8;
                }
                if (!RasHelper.isServer()) break block8;
                StringBuffer stringBuffer = new StringBuffer(uowBufferSize);
                Object object = serverCounterMutex;
                synchronized (object) {
                    stringBuffer.append(serverCounter++);
                }
                stringBuffer.append(serverNameSuffix);
                RasContextManager.setUnitOfWork(new String(stringBuffer));
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception during server request ", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_request");
        }
    }

    public void send_reply(ServerRequestInfo serverRequestInfo) {
        RasContextManager.setUnitOfWork(null);
    }

    public void send_exception(ServerRequestInfo serverRequestInfo) {
        RasContextManager.setUnitOfWork(null);
    }

    public void post_init(ORBInitInfo oRBInitInfo) {
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) {
    }

    public void send_other(ServerRequestInfo serverRequestInfo) {
    }

    public String name() {
        return "com.ibm.ejs.ras.RasContextSupport";
    }

    public void destroy() {
    }

    public void send_poll(ClientRequestInfo clientRequestInfo) {
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo) {
    }

    public void receive_other(ClientRequestInfo clientRequestInfo) {
    }
}

