/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.oa.pool;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.WorkUnit;
import com.ibm.ejs.oa.pool.PooledThread;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;

public class ThreadPool
implements com.ibm.CORBA.iiop.ThreadPool {
    private static final TraceComponent tc = Tr.register(ThreadPool.class, "ObjectAdapter", "com.ibm.ws.runtime.runtime");
    public static final int DEFAULT_MIN_SIZE = 2;
    public static final int DEFAULT_MAX_SIZE = 20;
    protected ObjectPool workerPool;
    protected com.ibm.ws.util.ThreadPool threadPool;
    private long timeoutInMillis;

    public ThreadPool(com.ibm.ws.util.ThreadPool threadPool) {
        this(threadPool, 0L);
    }

    public ThreadPool(com.ibm.ws.util.ThreadPool threadPool, long l) {
        this.threadPool = threadPool;
        this.timeoutInMillis = l;
        this.workerPool = new ObjectPool("ORB thread pool", threadPool.getMaximumPoolSize()){

            protected Object createObject() {
                return new PooledThread(this);
            }
        };
    }

    public void cleanup() {
    }

    public void init(ORB oRB) {
    }

    public void startWorkerThread(WorkUnit workUnit) {
        PooledThread pooledThread = (PooledThread)this.workerPool.remove();
        pooledThread.handleRequest(workUnit);
        Runnable runnable = null;
        try {
            runnable = this.threadPool.execute(pooledThread, this.timeoutInMillis);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ejs.oa.pool.ThreadPool.startWorkerThread", "83", this);
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ejs.oa.pool.ThreadPool.startWorkerThread", "85", this);
            throw runtimeException;
        }
        catch (Error error) {
            FFDCFilter.processException((Throwable)error, "com.ibm.ejs.oa.pool.ThreadPool.startWorkerThread", "88", this);
            throw error;
        }
        if (runnable == null) {
            Tr.warning(tc, "WSVR0627W", new Long(this.timeoutInMillis));
            throw new RuntimeException("ThreadPool queue is full");
        }
    }
}

