/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.oa;

import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.csi.J2EENameImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;

public class EJBOAKeyImpl {
    public static final byte HOME_BEAN = 0;
    public static final byte STATELESS_BEAN = 1;
    public static final byte STATEFUL_BEAN = 2;
    public static final byte ENTITY_BEAN = 3;
    public static final byte MESSAGEDRIVEN_BEAN = 4;
    public static final byte USES_BEAN_MANAGED_TX = 16;
    private static final byte[] header = new byte[]{-84, -84, 0, 2, 0, 1};
    private static final int BEAN_TYPE_LEN = 1;
    private static final int J2EE_NAME_LEN = 4;
    private static final int PKEY_TYPE_LEN = 1;
    private static final int HEADER_LEN = header.length;
    private byte[] ivServantKey;
    private boolean ivIsHome = false;
    private byte[] ivJ2eeNameBytes;
    private boolean ivIsJ2eeNameSet = false;
    private boolean ivIsBeanManaged = false;
    private byte ivBeanType;
    private boolean ivIsBeanTypeSet = false;
    private byte[] ivPrimaryKeyBytes;
    private boolean ivIsPrimaryKeySet = false;
    private static final TraceComponent tc = Tr.register(EJBOAKeyImpl.class, "ObjectAdapter", "com.ibm.ws.runtime.runtime");

    public EJBOAKeyImpl(byte[] byArray) {
        this.ivServantKey = byArray;
        for (int i = 0; i < HEADER_LEN; ++i) {
            if (this.ivServantKey[i] == header[i]) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Header mismatch, servant key is invalid.");
            }
            throw new IllegalArgumentException("Invalid Servant Key");
        }
        switch (this.ivServantKey[HEADER_LEN]) {
            case 0: {
                this.ivIsHome = true;
                this.ivIsPrimaryKeySet = true;
                break;
            }
            case 17: 
            case 20: {
                this.ivIsPrimaryKeySet = true;
            }
            case 18: {
                this.ivIsBeanManaged = true;
                break;
            }
            case 1: 
            case 4: {
                this.ivIsPrimaryKeySet = true;
            }
            case 2: 
            case 3: {
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to parse bean id: unsupported EJB type: " + this.ivServantKey[HEADER_LEN]);
                }
                throw new IllegalArgumentException("Unsupported EJB Type: " + this.ivServantKey[HEADER_LEN]);
            }
        }
    }

    public byte[] getJ2EENameBytes() {
        if (!this.ivIsJ2eeNameSet) {
            this.ivJ2eeNameBytes = EJBOAKeyImpl.readJ2EENameBytes(this.ivServantKey);
            if (this.ivIsHome) {
                this.ivJ2eeNameBytes = this.readPrimaryKeyBytes();
            }
            this.ivIsJ2eeNameSet = true;
        }
        return this.ivJ2eeNameBytes;
    }

    public boolean isBeanManagedTransaction() {
        if (this.ivIsHome) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Indication of transaction demarcation is not available for home beans. ");
            }
            throw new IllegalStateException("Indication of transaction demarcation is not available for home beans.");
        }
        return this.ivIsBeanManaged;
    }

    public byte getBeanType() {
        if (!this.ivIsBeanTypeSet) {
            if (this.ivIsHome) {
                this.ivBeanType = 0;
            } else {
                switch (this.ivServantKey[HEADER_LEN]) {
                    case 1: 
                    case 17: {
                        this.ivBeanType = 1;
                        break;
                    }
                    case 2: 
                    case 18: {
                        this.ivBeanType = (byte)2;
                        break;
                    }
                    case 4: 
                    case 20: {
                        this.ivBeanType = (byte)4;
                        break;
                    }
                    case 3: {
                        this.ivBeanType = (byte)3;
                        break;
                    }
                    default: {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Unsupported EJB type: " + this.ivServantKey[HEADER_LEN]);
                        }
                        throw new IllegalArgumentException("Unsupported EJB Type: " + this.ivServantKey[HEADER_LEN]);
                    }
                }
            }
            this.ivIsBeanTypeSet = true;
        }
        return this.ivBeanType;
    }

    public boolean isHome() {
        return this.ivIsHome;
    }

    public byte[] getPrimaryKeyBytes() {
        if (!this.ivIsPrimaryKeySet) {
            if (!this.ivIsJ2eeNameSet) {
                this.getJ2EENameBytes();
            }
            this.ivPrimaryKeyBytes = this.readPrimaryKeyBytes();
            this.ivIsPrimaryKeySet = true;
        }
        return this.ivPrimaryKeyBytes;
    }

    private static byte[] readJ2EENameBytes(byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = HEADER_LEN + 1;
        if (EJSPlatformHelper.isZOS()) {
            n = n3;
            n2 = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        } else {
            for (n = 3; n >= 0; --n) {
                n2 ^= byArray[n3 + n] & 0xFF;
                if (n <= 0) continue;
                n2 <<= 8;
            }
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n3 += 4, byArray2, 0, n2);
        return byArray2;
    }

    private byte[] readPrimaryKeyBytes() {
        byte[] byArray = null;
        try {
            int n = HEADER_LEN + 1 + 4 + this.ivJ2eeNameBytes.length + 1;
            int n2 = this.ivServantKey.length - n;
            byArray = new byte[n2];
            System.arraycopy(this.ivServantKey, n, byArray, 0, n2);
        }
        catch (Throwable throwable) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Unable to parse bean id: primary key: " + throwable);
            }
            throw new IllegalArgumentException("Unable to read primary key bytes.", throwable);
        }
        return byArray;
    }

    public String toString() {
        String string = (String)AccessController.doPrivileged((PrivilegedAction)new SystemGetPropertyPrivileged("line.separator", "\n"));
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "                                 ";
        String string3 = "                                     ";
        stringBuffer.append(string + string2 + "**************    EJBOAKeyImpl Dump    **************");
        stringBuffer.append(string + string3 + "J2EEName = ");
        J2EENameImpl j2EENameImpl = new J2EENameImpl(this.getJ2EENameBytes());
        stringBuffer.append(j2EENameImpl);
        stringBuffer.append(string + string3 + "Bean Type = ");
        stringBuffer.append(this.ivServantKey[HEADER_LEN]);
        stringBuffer.append(":  ");
        stringBuffer.append(this.getBeanTypeString());
        return stringBuffer.toString();
    }

    private String getBeanTypeString() {
        String string = null;
        switch (this.ivServantKey[HEADER_LEN]) {
            case 0: {
                string = "Home Bean";
                break;
            }
            case 17: {
                string = "Bean Managed Transaction: Stateless Session Bean";
                break;
            }
            case 1: {
                string = "Container Managed Transaction: Stateless Session Bean";
                break;
            }
            case 18: {
                string = "Bean Managed Transaction: Stateful Session Bean";
                break;
            }
            case 2: {
                string = "Container Managed Transaction: Stateful Session Bean";
                break;
            }
            case 20: {
                string = "Bean Managed Transaction: Message Driven Bean";
                break;
            }
            case 4: {
                string = "Container Managed Transaction: Message Driven Bean";
                break;
            }
            case 3: {
                string = "Entity Bean";
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Unsupported EJB type: " + this.ivServantKey[HEADER_LEN]);
                }
                throw new IllegalArgumentException("Unsupported EJB Type: " + this.ivServantKey[HEADER_LEN]);
            }
        }
        return string;
    }
}

