/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*      VisualAge Generator Server for OS/2, AIX, HP-UX, and Windows NT      */
/*                          Version 3.0  5697-C28                            */
/*                    (C) COPYRIGHT IBM CORP. 1994,1998                      */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************/
/*      Date      Userid          Description of problem                     */
/*                                                                           */
/*    00/00/00   Biega       PQ01683 - Support LUWCONTROL=CLIENT             */
/*    08/14/98   Proffer     PQ18456 - Fix EZECNVCM in called apps           */
/*    12/17/98   Proffer     D10254  - Back out APAR PQ18456                 */
/*                                                                           */
/*****************************************************************************/

#ifndef FCWAPP_H
#define FCWAPP_H

/*-------------------------------------------------------------------------*/
/*  Class definition for EZEAID                                            */
/*-------------------------------------------------------------------------*/
class AID
{
   private:
      Bool          isBypass;
      Key::enum_Key key;
      Bool          isHelpKey;

   public:
      AID() { isBypass = isHelpKey = False; key = Key::ENTER; }

      void  operator = (int& v) { int x = v; key = Key::enum_Key(x); isBypass = False; }
      void  operator = (Key::enum_Key v) { key = v; isBypass = False; }
      void  SetBypass  (Bool v) { isBypass = v; }
      void  SetHelpKey (Bool v) { isHelpKey = v; }

      Bool  IsEnter()  const { return (key == Key::ENTER); }
      Bool  IsBypass() const { return isBypass; }
      Bool  IsHelpKey()const { return isHelpKey; }
      Bool  IsPF()     const;
      Bool  IsPF1()    const { return (key == Key::PF1); }
      Bool  IsPF2()    const { return (key == Key::PF2); }
      Bool  IsPF3()    const { return (key == Key::PF3); }
      Bool  IsPF4()    const { return (key == Key::PF4); }
      Bool  IsPF5()    const { return (key == Key::PF5); }
      Bool  IsPF6()    const { return (key == Key::PF6); }
      Bool  IsPF7()    const { return (key == Key::PF7); }
      Bool  IsPF8()    const { return (key == Key::PF8); }
      Bool  IsPF9()    const { return (key == Key::PF9); }
      Bool  IsPF10()   const { return (key == Key::PF10); }
      Bool  IsPF11()   const { return (key == Key::PF11); }
      Bool  IsPF12()   const { return (key == Key::PF12); }
      Bool  IsPF13()   const { return (key == Key::PF13); }
      Bool  IsPF14()   const { return (key == Key::PF14); }
      Bool  IsPF15()   const { return (key == Key::PF15); }
      Bool  IsPF16()   const { return (key == Key::PF16); }
      Bool  IsPF17()   const { return (key == Key::PF17); }
      Bool  IsPF18()   const { return (key == Key::PF18); }
      Bool  IsPF19()   const { return (key == Key::PF19); }
      Bool  IsPF20()   const { return (key == Key::PF20); }
      Bool  IsPF21()   const { return (key == Key::PF21); }
      Bool  IsPF22()   const { return (key == Key::PF22); }
      Bool  IsPF23()   const { return (key == Key::PF23); }
      Bool  IsPF24()   const { return (key == Key::PF24); }
      Bool  IsPA1()    const { return (key == Key::PA1); }
      Bool  IsPA2()    const { return (key == Key::PA2); }
      Bool  IsPA3()    const { return (key == Key::PA3); }
      Bool  IsPA()     const { return (IsPA1() || IsPA2() || IsPA3()); }
      Bool  IsCLEAR()  const { return (key == Key::CLEAR); }
};

class InEdit
{
   public:
      enum values
      {
         All    = 1,
         InOnly = 2
      };
};

/*-------------------------------------------------------------------------*/
/*  forward references                                                     */
/*-------------------------------------------------------------------------*/
class MapGroup;
class DataStream;
class eMap;
class Table;
class MessageTable;
class Map;
struct ErrInfo;

/*-------------------------------------------------------------------------*/
/*  global function prototypes                                             */
/*-------------------------------------------------------------------------*/
Bool  CheckNum (char*, int);
int   Modulo10 (char*, int);
int   Modulo11 (char*, int);

/*-------------------------------------------------------------------------*/
/*  EZEword defines                                                        */
/*-------------------------------------------------------------------------*/
#define LENGTH_EZEAPP            8
#define LENGTH_EZECONVT          8
#define LENGTH_EZEDAY            5
#define LENGTH_EZEDAYL           7
#define LENGTH_EZEDAYLC          8
#define LENGTH_EZEDTE            6
#define LENGTH_EZEDTEL           8
#define LENGTH_EZEDTELC          10
#define LENGTH_EZEFEC            1
#define LENGTH_EZELOC            8
#define LENGTH_EZELTERM          8
#define LENGTH_EZEMNO            2
#define LENGTH_EZEOVER           1
#define LENGTH_EZEOVERS          1
#define LENGTH_EZERCODE          4
#define LENGTH_EZERT2            2
#define LENGTH_EZERT8            8
#define LENGTH_EZESEGM           1
#define LENGTH_EZESEGTR          8
#define LENGTH_EZESYS            8
#define LENGTH_EZETIM            8
#define LENGTH_EZETST            2
#define LENGTH_EZEUSR            8
#define LENGTH_EZEUSRID          8
#define LENGTH_EZECNVCM          1
#define LENGTH_EZEDESTP          65
#define LENGTH_EZESQISL          1

#define LENGTH_APP_EZEWORDS  LENGTH_EZEAPP   + LENGTH_EZECONVT +   \
                             LENGTH_EZEDAY   + LENGTH_EZEDAYL  +   \
                             LENGTH_EZEDAYLC + LENGTH_EZEDTE   +   \
                             LENGTH_EZEDTEL  + LENGTH_EZEDTELC +   \
                             LENGTH_EZEFEC   + LENGTH_EZELOC   +   \
                             LENGTH_EZELTERM + LENGTH_EZEMNO   +   \
                             LENGTH_EZEOVER  + LENGTH_EZEOVERS +   \
                             LENGTH_EZERCODE + LENGTH_EZERT2   +   \
                             LENGTH_EZERT8   + LENGTH_EZESEGM  +   \
                             LENGTH_EZESEGTR + LENGTH_EZESYS   +   \
                             LENGTH_EZETIM   + LENGTH_EZETST   +   \
                             LENGTH_EZEUSR   + LENGTH_EZEUSRID +   \
                             LENGTH_EZECNVCM + LENGTH_EZEDESTP +   \
                             LENGTH_EZESQISL

#define OFFSET_EZEAPP      0
#define OFFSET_EZECONVT    OFFSET_EZEAPP   + LENGTH_EZEAPP
#define OFFSET_EZEDAY      OFFSET_EZECONVT + LENGTH_EZECONVT
#define OFFSET_EZEDAYL     OFFSET_EZEDAY   + LENGTH_EZEDAY
#define OFFSET_EZEDAYLC    OFFSET_EZEDAYL  + LENGTH_EZEDAYL
#define OFFSET_EZEDTE      OFFSET_EZEDAYLC + LENGTH_EZEDAYLC
#define OFFSET_EZEDTEL     OFFSET_EZEDTE   + LENGTH_EZEDTE
#define OFFSET_EZEDTELC    OFFSET_EZEDTEL  + LENGTH_EZEDTEL
#define OFFSET_EZEFEC      OFFSET_EZEDTELC + LENGTH_EZEDTELC
#define OFFSET_EZELOC      OFFSET_EZEFEC   + LENGTH_EZEFEC
#define OFFSET_EZELTERM    OFFSET_EZELOC   + LENGTH_EZELOC
#define OFFSET_EZEMNO      OFFSET_EZELTERM + LENGTH_EZELTERM
#define OFFSET_EZEOVER     OFFSET_EZEMNO   + LENGTH_EZEMNO
#define OFFSET_EZEOVERS    OFFSET_EZEOVER  + LENGTH_EZEOVER
#define OFFSET_EZERCODE    OFFSET_EZEOVERS + LENGTH_EZEOVERS
#define OFFSET_TEMP        81        /* HP aC++ compiler can't handle depth*/
#define OFFSET_EZERT2      OFFSET_TEMP     + LENGTH_EZERCODE
#define OFFSET_EZERT8      OFFSET_EZERT2   + LENGTH_EZERT2
#define OFFSET_EZESEGM     OFFSET_EZERT8   + LENGTH_EZERT8
#define OFFSET_EZESEGTR    OFFSET_EZESEGM  + LENGTH_EZESEGM
#define OFFSET_EZESYS      OFFSET_EZESEGTR + LENGTH_EZESEGTR
#define OFFSET_EZETIM      OFFSET_EZESYS   + LENGTH_EZESYS
#define OFFSET_EZETST      OFFSET_EZETIM   + LENGTH_EZETIM
#define OFFSET_EZEUSR      OFFSET_EZETST   + LENGTH_EZETST
#define OFFSET_EZEUSRID    OFFSET_EZEUSR   + LENGTH_EZEUSR
#define OFFSET_EZECNVCM    OFFSET_EZEUSRID + LENGTH_EZEUSRID
#define OFFSET_EZEDESTP    OFFSET_EZECNVCM + LENGTH_EZECNVCM
#define OFFSET_EZESQISL    OFFSET_EZEDESTP + LENGTH_EZEDESTP

enum SegmentedState { Segmented, NonSegmented };
enum Mode { cm_normalFlow, cm_ezeFlow, cm_Goto, cm_End };
enum qType { MAIN, AUX };

/**************************************************************************/
/*        Temporary fix for empty record for Generator                    */
/**************************************************************************/
struct recFCWEmpty : WSRecord
{
    recFCWEmpty() : WSRecord(0) {}
};

/*-------------------------------------------------------------------------*/
/*  FCWApp class definition - base application class                       */
/*-------------------------------------------------------------------------*/
class FCWApp
{
  private:
    FCWString         app_name;

    FCWString         app_MapGroupName;
    FCWString         app_HelpGroupName;
    ByPassKeys        app_ByPassKeys;
    Key::enum_Key     app_HelpKey;
    InEdit::values    app_InEditOption;

    MapGroup*         app_pMapGroup;
    MapGroup*         app_pHelpGroup;

    FCWString         app_lastMapName;
    FCWString         app_lastGroupName;
    FCWString         app_message;

    SegmentedState    app_DefaultSegm;

    Bool              app_refresh;

    LIST(Table*)      list_pTables;
    LIST(DataStream*) list_pConstants;
    LIST(DataStream*) list_pDataStream;
    LIST(eMap*)       list_fixed_peMap;
    LIST(eMap*)       list_float_peMap;

    STACK (char*)     PrcStack;
    void*             pData;
    FCWString         app_DefaultSegtr;
    WSRecord*         app_primaryWS;
    void*             pEIB;
    void*             pCommarea;
    Bool              bHasFirstMap;

  protected:
    Mode CtlMode;

    recEZESQL EZESQL;                  /* App level SQLCA struct:          */
      HEX     EZESQLCA;                /* 136     bytes                    */
      BIN4    EZESQCOD;                /* 4     bytes                      */
      BIN4    EZESQRD3;                /* 4     bytes                      */
      CHA     EZESQRRM;                /* 70     bytes                     */
      CHA     EZESQWN1;                /* 1     byte                       */
      CHA     EZESQWN6;                /* 1     byte                       */
      CHA     EZESQSTA;                /* 5     byte    :SQLSTATE    *ODBC**/

    FCWApp ( char* ,
             char* MapGroupName,
             char* HelpGroupName,
             ByPassKeys BypassKeys,
             Key::enum_Key HelpKey,
             char* destp,
             InEdit::values ineditopt,
             SegmentedState segmented,
             char* segtr );
    virtual ~FCWApp ();

  public:
    recFCWEmpty FCWEmptyRecord;        /* Temporary fix                    */
    recEZEWORDS EZEWORDS;              /* App level EZEWORDS               */
      CHA     EZEAPP;                  /* 8 bytes                          */
      CHA     EZECONVT;                /* 8 bytes                          */
      NUM     EZEday;                  /* 5 bytes                          */
      NUM     EZEdayl;                 /* 7 bytes                          */
      CHA     EZEdaylc;                /* 8 bytes                          */
      NUM     EZEdte;                  /* 6 bytes                          */
      NUM     EZEdtel;                 /* 8 bytes                          */
      CHA     EZEdtelc;                /* 10 bytes                         */
      NUM     EZEFEC;                  /* 1 byte                           */
      CHA     EZELOC;                  /* 8 bytes                          */
      CHA     EZELTERM;                /* 8 bytes                          */
      BIN2    EZEMNO;                  /* 2 bytes                          */
      NUM     EZEOVER;                 /* 1 byte                           */
      NUM     EZEOVERS;                /* 1 byte                           */
      BIN4    EZERCODE;                /* 4 bytes                          */
      CHA     EZERT2;                  /* 2 bytes                          */
      CHA     EZERT8;                          //   8 bytes
      NUM     EZESEGM;                         //   1 byte
      CHA     EZESEGTR;                        //   8 bytes
      CHA     EZESYS;                          //   8 bytes
      CHA     EZEtim;                          //   8 bytes
      BIN2    EZETST;                          //   2 bytes
      CHA     EZEUSR;                          //   8 bytes
      CHA     EZEUSRID;                        //   8 bytes
      NUM     EZECNVCM;                        //   1 bytes
      CHA     EZEDESTP;                        //  65 bytes
      NUM     EZESQISL;                        //   1 byte

    recEZEDLPSB  EZEDLPSB;
      CHA     EZEDLPSBItem;
      HEX     EZEDLPSBAddr;

    FCWString&            Name();

    AID                   EZEAID;
    FCWString&            MapGroupName();
    MapGroup*             pMapGroup();
    FCWString&            HelpGroupName();
    MapGroup*             pHelpGroup();
    ByPassKeys const&     BypassKeys();
    Key::enum_Key         HelpKey();

    Bool                  refresh();
    void                  setRefresh(Bool v = True);
    LIST(DataStream*)&    bufferList();
    LIST(DataStream*)&    bufferChain();
    LIST(eMap*)&          fixedMapChain();
    LIST(eMap*)&          floatMapChain();
    InEdit::values        InEditOpt();

    FCWString const&      getMessage();
    void                  setMessage(FCWString const& msg);
    void                  setLastMapConversed( FCWString const&, FCWString const&);
    Bool                  isLastMapConversed( FCWString const&, FCWString const&);

    Table*                find(FCWString const &);
    void                  Register(Table*);
    void                  RetrieveMsg( int, char*, int );

    void                  CALL (char*, int, ...);
    void                  CALL (char*, char*, char*, int, ...);
    int                   CALLR (char*, CMCOD*, int, ...);
    int                   CALLR (char*, char*, char*, CMCOD*, int, ...);
    void                  checkCALLRReturnCode(const ErrInfo&);
    void                  CREATX (int options, Record& recd);
    void                  CREATX (FCWCICSLinkage* , int , Record& , Item*);
    void                  CREATX (FCWCICSLinkage* , int , Record& );
    void                  SetEZETST( int );
    void                  EZEWAIT( const quadnum& );
    CHA&                  EZETIM ();
    void                  EZEPURGE( char* );
    void                  EZEPURGE( const FCWString& s );
    int                   EZEC10( CHA, BIN2 );
    int                   EZEC11( CHA, BIN2 );
    int                   EZEG10( CHA&, BIN2 );
    int                   EZEG11( CHA&, BIN2 );
    NUM&                  EZEDAY();
    NUM&                  EZEDAYL();
    CHA&                  EZEDAYLC();
    NUM&                  EZEDTE();
    NUM&                  EZEDTEL();
    CHA&                  EZEDTELC();
    int                   EZECOMIT( int options = OPT_NOREPLY );    /* DUOW*/
    int                   EZEROLLB( int options = OPT_NOREPLY );    /* DUOW*/
    void                  EZECONV( Parameter&, char, char*, int opt = 0 );     /* V2.0 CICS*/
    void                  EZECONV( Parameter& p, char c, FCWString s, int opt = 0 );
    void*                 GetSQLCA();

    void                  EZECONCT( ChaItem&, ChaItem&, ChaItem&,
                                    ChaItem&, ChaItem&, FCWString="R" );/* DUOW*/

    void                  ResetEzeWords();
    void                  ReleaseTables();

    void                  PrcPush( char* );
    void                  PrcPop();
    char*                 PrcPeek();

    Bool                  isNative();
    Bool                  isCalledApp();

    int                   GetRCode();  /* return EZERCODE to caller        */
    Mode                  GetCtlMode();

    void                  Init( InitKey k, InitValue v );         // ODBC

    virtual void          Start() = 0;
    virtual MessageTable* MsgTable();
    virtual Bool          isCICS();
    virtual Bool          isMainApp();
            void*         GetCommarea();
            void*         GetEIB();
            void          SetCommarea( void* );
            void          SetEIB( void* );

    // Psuedo-Conversational interface.
    virtual void          SegmentOut( segType t=segmented_Converse ) {};
    virtual void          SegmentIn()              {};
    virtual long          traceBackGet()           { return 0; };
    virtual void          traceBackPush( long )    {};
    virtual void          traceBackPop( )          {};
    virtual void          clearTraceback( )        {};
    virtual void          doFirstMap( Map* )       {};
    virtual qType         WorkDB();
            void          ResetEZESEGM();
            Bool          IsInInitialization();
            void          primaryWS( WSRecord* );
            WSRecord*     primaryWS();
            Bool          hasFirstMap();
            void          hasFirstMap( Bool );

            void          SetCurrency(FCWString curSym);
};

inline
void  FCWApp :: EZEPURGE( const FCWString& s )
{
   EZEPURGE( (char*)s );
}

inline
void  FCWApp :: EZECONV( Parameter& p, char c, FCWString s, int opt )
{
   EZECONV( p, c, (char*)s, opt );
}

/*-------------------------------------------------------------------------*/
/*  FCWMainApp class definition                                            */
/*-------------------------------------------------------------------------*/
class FCWMainApp : public FCWApp
{
  protected:
#if defined FCW_HP
    FCWMainApp ( char* name ,
                 char* MapGroupName,
                 char* HelpGroupName,
                 ByPassKeys BypassKeys,
                 Key::enum_Key HelpKey,
                 char* destp,
                 InEdit::values ineditopt,
                 SegmentedState segmented);
#else
    FCWMainApp ( char* name ,
                 char* MapGroupName       = NULL,
                 char* HelpGroupName      = NULL,
                 ByPassKeys BypassKeys    = ByPassKeys(),
                 Key::enum_Key HelpKey    = Key::None,
                 char* destp              = NULL,
                 InEdit::values ineditopt = InEdit::All,
                 SegmentedState segmented = NonSegmented);
#endif
    FCWMainApp ( char* name ,
                 char* MapGroupName       ,
                 char* HelpGroupName      ,
                 ByPassKeys BypassKeys    ,
                 Key::enum_Key HelpKey    ,
                 char* destp              ,
                 InEdit::values ineditopt ,
                 SegmentedState segmented ,
                 char* segtr              );
    virtual ~FCWMainApp ();

  public:
    void           DXFR (FCWString appname, int options);
    void           DXFR (FCWString appname, int options, Record& recd);
    void           XFER (FCWString appname, int options);
    void           XFER (FCWString appname, int options, Record& recd);
    void           XFER (FCWString appname, int options, Map& pMap);
    void           XFER (FCWString appname, int options, Record& recd, Map& pMap);
    virtual  Bool  isMainApp();

    virtual void          SegmentOut( segType t=segmented_Converse );
    virtual void          SegmentIn();

  private:
    void*             pData;
};

/*-------------------------------------------------------------------------*/
/*  FCWCICSMainApp class definition                                        */
/*-------------------------------------------------------------------------*/
class FCWCICSMainApp : public FCWMainApp
{
  protected:
#if defined FCW_HP
    FCWCICSMainApp ( char* name ,
                     char* MapGroupName,
                     char* HelpGroupName,
                     ByPassKeys BypassKeys,
                     Key::enum_Key HelpKey,
                     char* destp,
                     InEdit::values ineditopt,
                     SegmentedState segmented);
#else
    FCWCICSMainApp ( char* name ,
                     char* MapGroupName       = NULL,
                     char* HelpGroupName      = NULL,
                     ByPassKeys BypassKeys    = ByPassKeys(),
                     Key::enum_Key HelpKey    = Key::None,
                     char* destp              = NULL,
                     InEdit::values ineditopt = InEdit::All,
                     SegmentedState segmented = NonSegmented);
#endif
    FCWCICSMainApp ( char* name ,
                     char* MapGroupName       ,
                     char* HelpGroupName      ,
                     ByPassKeys BypassKeys    ,
                     Key::enum_Key HelpKey    ,
                     char* destp              ,
                     InEdit::values ineditopt ,
                     SegmentedState segmented ,
                     char* segtr              );
    virtual ~FCWCICSMainApp ();

  private:
    void*             pData;

    // Psuedo-Conversational interface.
    STACK (long)      trbStack1;                                 /* Current*/
    STACK (long)      trbStack2;                                 /* Restore*/

  public:

    void          DXFR (FCWString appname, int options);
    void          DXFR (FCWString appname, int options, Record& recd);
    void          XFER (FCWString appname, int options);
    void          XFER (FCWString appname, int options, Record& recd);
    void          XFER (FCWString appname, int options, Map& pMap);
    void          XFER (FCWString appname, int options, Record& recd, Map& pMap);

    void*         GetParm( int, void*);
    void          CALLCICS (char*, FCWCICSLinkage*, int, ...);

    virtual Bool  isCICS();
    virtual Bool  isMainApp();

    // Psuedo-Conversational interface.
    virtual void      SegmentOut( segType t=segmented_Converse );
    virtual void      SegmentIn();
    virtual long      traceBackGet();
    virtual void      traceBackPush( long );
    virtual void      traceBackPop( );
    virtual void      clearTraceback( );
    virtual void      doFirstMap( Map* );
    virtual void      SaveWS()    {};
    virtual void      RestoreWS() {};
            void      GetCtlRecd();
            void      Save( Parameter*, ... );
            void      Restore( Parameter*, ... );
};

/*-------------------------------------------------------------------------*/
/*  FCWCalledApp class definition                                          */
/*-------------------------------------------------------------------------*/
class FCWCalledApp : public FCWApp
{
  protected:
#if defined FCW_HP
    FCWCalledApp( char* name ,
                  char* MapGroupName,
                  char* HelpGroupName,
                  ByPassKeys BypassKeys,
                  Key::enum_Key HelpKey,
                  char* destp,
                  InEdit::values ineditopt,
                  SegmentedState segmented);
#else
    FCWCalledApp( char* name ,
                  char* MapGroupName       = NULL,
                  char* HelpGroupName      = NULL,
                  ByPassKeys BypassKeys    = ByPassKeys(),
                  Key::enum_Key HelpKey    = Key::None,
                  char* destp              = NULL,
                  InEdit::values ineditopt = InEdit::All,
                  SegmentedState segmented = NonSegmented);
#endif
    virtual ~FCWCalledApp ();

    void VerifyParms(FCWCallBlock* cb, FCWCallBlock* cbVer);

  private:
    void*             pData;
};

/*-------------------------------------------------------------------------*/
/*  FCWCICSCalledApp class definition                                        */
/*-------------------------------------------------------------------------*/
class FCWCICSCalledApp : public FCWCalledApp
{
  protected:
#if defined FCW_HP
    FCWCICSCalledApp ( char* name ,
                       char* MapGroupName,
                       char* HelpGroupName,
                       ByPassKeys BypassKeys,
                       Key::enum_Key HelpKey,
                       char* destp,
                       InEdit::values ineditopt,
                       SegmentedState segmented);
#else
    FCWCICSCalledApp ( char* name ,
                       char* MapGroupName       = NULL,
                       char* HelpGroupName      = NULL,
                       ByPassKeys BypassKeys    = ByPassKeys(),
                       Key::enum_Key HelpKey    = Key::None,
                       char* destp              = NULL,
                       InEdit::values ineditopt = InEdit::All,
                       SegmentedState segmented = NonSegmented);
#endif
    virtual ~FCWCICSCalledApp ();

  private:
    void*         pData;

  public:
    void          Verify( int, void* );
    void*         GetParm( int, void*);
    void          CALLCICS (char*, FCWCICSLinkage*, int, ...);
    void          SetErrorInCalledApp();                           /* PQ01683 */

    virtual Bool  isCICS();
};


#endif
