/* *********************************************************************** */
/* Sample program that is called from a VG application. Most of the VA/G   */
/*  data types are passed as parameters. A binary parameter is returned.   */
/*  AIX version.                                                           */
/* *********************************************************************** */

#include <stdio.h>
#include <string.h>

void Unpack(char*, char*);
extern "C" void AVG2C1C(short* bin2Item, long* bin4Item, double* bin8Item,
                    char* chaItem, char* hexItem, char* numItem,
                    char* numcItem, char* packItem, char* pacfItem,
                    long* rc);

extern "C" void AVG2C1C(short* bin2Item, long* bin4Item, double* bin8Item,
                    char* chaItem, char* hexItem, char* numItem,
                    char* numcItem, char* packItem, char* pacfItem,
                    long* rc)
{
   char packString[20];

   printf("bin2Item = %d\n", *bin2Item);
   printf("bin4Item = %d\n", *bin4Item);
   printf("bin8Item = %d\n", *bin8Item);
   printf("chaItem  = %8.8s\n", chaItem);
   printf("hexItem  = %4.4s\n", hexItem);
   printf("numItem  = %8.8s\n", numItem);
   printf("numcItem = %8.8s\n", numcItem);

   memset(packString, 0, sizeof(packString));
   Unpack(packItem, packString);
   printf("packItem = %s\n", packString);

   memset(packString, 0, sizeof(packString));
   Unpack(pacfItem, packString);
   printf("pacfItem = %s\n", packString);

   *rc = 99;
}

/* *********************************************************************** */
/* Subroutine to convert VA/G PACK & PACF data items to a character string */
/* *********************************************************************** */
void Unpack(char* packItem, char* packString)
{
   char temp;
   int i,j = 0;

   packString[j] = ' ';                 /* Assume positive number   */
   j++;                                 /* Increment target string ptr */

   for (i = 0; i < 10; i++)             /* Max length in bytes of a  */
   {                                    /*  VG pack/f data item = 10 */
      temp = packItem[i];
      temp >>= 4;                       /* Isolate the left nibble  */
      temp += 48;                       /* Convert it to ascii      */
      packString[j] = temp;
      j++;                              /* Increment target string ptr */

      temp = packItem[i];
      temp &= 0x0F;                     /* Isolate the right nibble */

      if ((temp == 0x0F) || (temp == 0x0C))  /* Look for the sign   */
      {
         break;                         /* Positive, leave asis     */
      }

      if ((temp == 0x0B) || (temp == 0x0D))  /* Look for the sign   */
      {
         packString[0] = '-';           /* Indicate negative        */
         break;
      }

      temp += 48;                       /* Convert it to ascii      */
      packString[j] = temp;
      j++;                              /* Increment target string ptr */
   }

}
