package com.ibm.vap.Isolation;

/**
 * TransactionLockingPolicy
 */

import java.rmi.RemoteException;
import java.util.Vector; 
import com.ibm.vap.Transactions.Version;
import com.ibm.vap.Transactions.Key;
import com.ibm.vap.Transactions.VapEJBObject;
import com.ibm.vap.Transactions.VapEJBHome;
import com.ibm.vap.common.VapReadFailureException;
import com.ibm.vap.common.VapObjectLockedException;

public interface TransactionLockingPolicy
{
/**
 * Read all instances from a home
 */
public Vector allInstancesFrom(VapEJBHome aHome) throws RemoteException, VapReadFailureException;
/**
 * Execute aQueryName from a home
 */
public Vector customQueryFrom(VapEJBHome aHome, String aQueryName, Object[] args) throws RemoteException, VapReadFailureException;
/**
 * Read an instance from a home
 */
public VapEJBObject findByPrimaryKey(Key aKey, VapEJBHome aHome) throws RemoteException, VapReadFailureException;
/**
 * If the transaction supports read stability, initialize the child version with a copy
 * of parent's data. Otherwise share the parent's data.
 */
public void initializeVersion(Version aChildVersion, Version aParentVersion) throws RemoteException;
/**
 * The version is accessed first time
 */
public void notifyFirstAccessFor(Version aVersion) throws RemoteException, VapObjectLockedException;
/**
 * The version is registered into a view
 */
public void notifyRegistrationFor(Version aVersion) throws RemoteException, VapObjectLockedException;
/**
 * Answer true if the policy supports repeatable reads
 */
public boolean supportsRepeatableReads();
}