package com.ibm.ulc.vaedit;

import javax.swing.border.*;
import java.awt.*;
/**
 * This is the edit time box widget
 * Creation date: (03-23-99 5:18:36 PM)
 * @author: 
 */
public class UlcBoxWidget extends javax.swing.JPanel {
	protected int fMargin = 4;
	protected int fHGap = 4;
	protected int fVGap = 4;
/**
 * UlcBoxWidget constructor comment.
 */
public UlcBoxWidget() {
	super();
	setLayout(new GridBagLayout());
	setBorder(new EmptyBorder(fMargin, fMargin, fMargin, fMargin));
}
/**
 * Insert the method's description here.
 * Creation date: (03-23-99 5:30:18 PM)
 * @return int
 */
public int getHGap() {
	return fHGap;
}
/**
 * This is the margin around all of the cells
 * Creation date: (03-23-99 5:20:04 PM)
 * @return int
 */
public int getMargin() {
	return fMargin;
}
/**
 * Insert the method's description here.
 * Creation date: (03-23-99 5:31:14 PM)
 * @return int
 */
public int getVGap() {
	return fVGap;
}
/** 
 * Removes the component, specified by <code>index</code>, 
 * from this container. 
 * @param     index   the index of the component to be removed.
 * @see #add
 * @since JDK1.1
 */
public void remove(int index) {
	super.remove(index);
	resetGap();	// Reset gaps to take removed guy into consideration
}
/*
 * Reset all of the gaps between the cells
 * to the current h/v gap.
 *
*/
private void resetGap() {
	boolean madeAnyChange = false;
	Component comps[] = getComponents();
	GridBagLayout gbl = (GridBagLayout)getLayout();
	for (int i = 0; i < comps.length; i++) {
		boolean madeChange = false;
		GridBagConstraints con = gbl.getConstraints(comps[i]);
		if (con.gridx > 0 && con.insets.left != fHGap)
		{
			madeChange = true;
			con.insets.left = fHGap;
		}	
		if (con.gridy > 0 && con.insets.top != fVGap)
		{
			madeChange = true;
			con.insets.top = fVGap;
		}
		if (madeChange)
		{
			madeAnyChange = true;	
			gbl.setConstraints(comps[i], con);
		}	
	}
	if (madeAnyChange)
		invalidate();
}
/**
 * Insert the method's description here.
 * Creation date: (03-23-99 5:30:18 PM)
 * @param newHGap int
 */
public void setHGap(int newHGap) {
  fHGap = newHGap;
}
/**
 * Insert the method's description here.
 * Creation date: (03-23-99 5:20:04 PM)
 * @param newFMargin int
 */
public void setMargin(int newMargin) {
	if (fMargin != newMargin)
	{
	  fMargin = newMargin;
	  setBorder(new EmptyBorder(fMargin, fMargin, fMargin, fMargin));
	  resetGap();
	  invalidate();
	}   
}
/**
 * Insert the method's description here.
 * Creation date: (03-23-99 5:31:14 PM)
 * @param newVGap int
 */
public void setVGap(int newVGap) {
  fVGap = newVGap;  
}
}
