package com.ibm.ulc.util;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.io.*;


public
class AnythingReader implements IAnythingReader {
	private boolean fHasPutBack= false;
	private int fPutBack;
	private InputStream fIn= null;

	private static final int EOF= -1;
	public AnythingReader() {
	}
	public AnythingReader(int c) {
		fPutBack= c;
		fHasPutBack= true;
	}
	/**
	 * Creates the corresponding writer for this format
	 */
	public IAnythingWriter createWriter() {
		return new AnythingWriter();
	}
	private int get() throws IOException {
		int c;

		if (fHasPutBack) {
			fHasPutBack= false;
			c= fPutBack;
		} else {
		    c= fIn.read();
		}
		return c;
	}
public boolean hasPutBack() {
	return fHasPutBack;
}
	Anything intRead() throws IOException {
		StringBuffer buf= new StringBuffer();

		int c= skipSpace();

		switch (c) {

			// Number
		case '+': case '-': case '.':
		case '0': case '1': case '2': case '3': case '4':
		case '5': case '6': case '7': case '8': case '9':
			{
				boolean isDouble= false;

				for (;;) {
					buf.append((char)c);
					c= get();
					switch (c) {
					case '.':
					case 'E':
					case '+':
					case '-':
						isDouble= true;
						continue;
					default:
						if (Character.isDigit((char)c))
							continue;
						break;
					}
					break;
				}
				putBack(c);

				String s= buf.toString();
				if (isDouble) {
					Double d= null;
					try {
						d= new Double(s);
					}
					catch (NumberFormatException e) {
					}
					if (d != null)
						return new Anything(d);
					return new Anything();
				}
				return new Anything(Long.parseLong(s));
			}

		case '\"':		// string
			readString(buf);
			return new Anything(buf.toString());

		case '<':		// bytes
			return new Anything(readBytes(buf));

		case '{':		// AnyArrayImpl
			return intReadArray();

		case '*':		// NULL
			return new Anything();
		
		case '[': //Serializable Object
			try {
				ObjectInputStream ois= new ObjectInputStream(fIn);
				Serializable ob= (Serializable)ois.readObject();
				skipSpace(); //read the ']'
				return new Anything(ob);
			} catch (ClassNotFoundException e) {
			}
			return new Anything();

		default:
			if (isWord((char)c)) {
				readSymbol(buf, c);
				String s= buf.toString();
				if (s.equals("t"))
				    return new Anything(true);
				if (s.equals("f"))
				    return new Anything(false);
				return new Anything(s);
			}
			//context.Error("Anything::IntReadFrom: wrong char '%c' (0x%02x)", c, c);
			return new Anything();
		}
	}
private Anything intReadArray() throws IOException {
	Anything a = new Anything();
	for (int i = 0;; i++) {
		int c = skipSpace();
		if ((c == '}') || (c == EOF))
			// the end of this array/dictionary
			break;
		if (c == '/') { // a key
			boolean lookfordigit = false;
			StringBuffer buf = new StringBuffer();
			c = get();
			if (c == '"') {
				readString(buf);
			} else {
				readSymbol(buf, c);
				lookfordigit = true;
			}
			String key = buf.toString();
			if (lookfordigit && Character.isDigit(buf.charAt(0))) {
				i = (int) Long.parseLong(key);
				a.put(i, intRead());
			} else {
				a.put(key, intRead());
			}
		} else {
			// was the beginning of a value; so we have to put it back...
			putBack(c);
			a.append(intRead());
		}
	}
	return a;
}
	static boolean isWord(char c) {
		if (Character.isLetterOrDigit(c))
			return true;
		if (c == '_')
			return true;
		return false;
	}
public void putBack(int c) {
	fPutBack= c;
	fHasPutBack= true;
}
	public Anything read(InputStream in) {
		Anything a;
		fIn= in;
		try {
			a= intRead();
		} catch (IOException e) {
			//System.out.print("AnythingReader.read: ");
			//e.printStackTrace(System.out);
			a= null;
		}
		return a;
	}
	private byte[] readBytes(StringBuffer buf) throws IOException {
			readBytes2(buf);
			byte[] bytes = new byte[buf.length()];
			for (int i = 0; i < bytes.length; i++) {
				bytes[i] = (byte) buf.charAt(i);
			}
			return bytes;
	}
private void readBytes2(StringBuffer buf) throws IOException {
	int c, v = 0;
	boolean first = true;
	for (;;) {
		c = get();
		switch (c) {
			case EOF :
				return;
			case '\n' :
			case ' ' :
			case '\r' :
				continue;
			case '>' :
				return;
			default :
				int n = Character.digit((char) c, 16);
				if (n >= 0) { // silently ignore non-hex characters
					if (first) {
						v = n * 16;
						first = false;
					} else {
						buf.append((char) (v + n));
						first = true;
					}
				}
				continue;
		}
	}
}
public Anything readEx(InputStream in) throws IOException {
	fIn= in;
	return intRead();
}
	private void readString(StringBuffer buf) throws IOException {
		int c;
		int tmp;

		for (;;) {
			c= get();
			switch (c) {
			case EOF:
				break;
			case '\n':
				//context.Error("Anything::IntReadFrom: nl or cr in string");
				buf.append((char)c);
				continue;
			case '\"':
				break;
			case '\\':
				c= get();
				switch (c) {
				case EOF:
					break;
				case '0': case '1': case '2': case '3': case '4': 
				case '5': case '6': case '7':
					// octal
					tmp= Character.digit((char)c, 8);
					for (int i= 0; i < 2; i++) {
						c= get();
						int n= Character.digit((char)c, 8);
						if (n >= 0) {
							tmp= (tmp * 8) + n;
						} else {
							throw new IOException();
						}
					}
					buf.append((char) tmp);
					break;
				case 'u':	// hex
					tmp= 0;
					for (int i= 0; i < 4; i++) {
						c= get();
						int n= Character.digit((char)c, 16);
						if (n >= 0) {
							tmp= (tmp * 16) + n;
						} else {
							throw new IOException();
						}
					}
					// hex
					buf.append((char) tmp);
					break;
				case 't':
					buf.append('\t');
					break;
				case 'n':
					buf.append('\n');
					break;
				case 'b':
					buf.append('\b');
					break;
				case '"':
					buf.append('"');
				    break;      
				case '\\':
					buf.append('\\');
					break;
				default:
					break;
				}
				continue;
			default:
				buf.append((char)c);
				continue;
			}
			break;
		}
	}
	private void readSymbol(StringBuffer buf, int c) throws IOException {
		while (isWord((char)c)) {
			buf.append((char)c);
			c= get();
			if (c == EOF)
				return;
		}
		putBack(c);
	}
	private int skipSpace() throws IOException {
		for (;;) {
			int c= get();
			switch (c) {
			case EOF:
				break;
			case '#':
				do {
					c= get();
				} while(c != '\n' && c != '\r' && c != EOF);
				continue;
			case ' ':
			case '\t':
			case '\f':
			case '\n':
			case '\r':
				continue;
			}
			return c;
		}
	}
}
