package com.ibm.ulc.ui.lists;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.base.*;
class UiComboModelWrapper extends UiListModelWrapper implements ComboBoxModel {
	protected UIComboBox fComboBox = null;
	protected JComboBox fJComboBox = null;
	protected String fDummy = "---------";
	protected Object fCurrent = null; // selected object (if available; otherwise use fIndex)
	protected int fPendingSelection = -1;
	protected boolean fInContentsChanged = false;
UiComboModelWrapper(UIComboBox cb, UIItemList itemList, String colId) {
	super(itemList, colId);
	fComboBox = cb;
}
UiComboModelWrapper(JComboBox cb, UIItemList itemList, String colId) {
	super(itemList, colId);
	fJComboBox = cb;
}
	public void free() {
		fComboBox= null;
		fCurrent= null;
		super.free();
	}
// ListModel interface
public Object getElementAt(int row) {
	getItemList().startRequest();
	Object o = super.getElementAt(row);
	getItemList().stopRequest();
	if ((o instanceof InvalidCell) && (getItemList().indexToOid(row) < 0))
		return fDummy;
	if (o instanceof PendingCell)
		return fDummy;
	return o;
}
  	public Object getSelectedItem() {
  		if (fCurrent == null)
   		return fDummy;
   	return fCurrent;
 	}   
public boolean isPlaceholder(Object object) {
	return object.toString().equals(fDummy);
}
public void notify(int type, String[] attributeNames, int start, int end) {
	if (type == TABLE_MODEL_CONTENTS_CHANGED) { //1FQF62S
		if (fCurrent != null)
			setSelectedItem(null);
		fCurrent = null;
		fInContentsChanged = true;
	}
	super.notify(type, attributeNames, start, end);
	fInContentsChanged = false;
	if ((fPendingSelection != -1) && (type == TABLE_MODEL_ROWS_CHANGED)) {
		Object o = getElementAt(fPendingSelection);
		if (o != fDummy) {
			fPendingSelection = -1;
			setSelectedItem(o);
		}
	}
}
/**
 * Implement this method to satisfy the abstract implementation of the receiver's superclass.
 * this message should never be sent to the receiver
 */
protected void setItemList(UIItemList itemList) {
	super.setItemList(itemList);
	setSelectedItem(null);
}
public void setPendingSelection(int index) {
	fPendingSelection = index;
}
public void setSelectedItem(Object anObject) {
	//System.out.println("ComboBoxModelWrapper.setSelectedItem(" + anObject.getClass().getName() + "): " + anObject);
	if (fInContentsChanged)
		return;
	fCurrent = anObject;
	if (fComboBox != null)
		fComboBox.stateChanged(fCurrent);
}
public void setSelectedItem(Object anObject, boolean notify) {
	//System.out.println("ComboBoxModelWrapper.setSelectedItem(" + anObject.getClass().getName() + "): " + anObject);
	if (fInContentsChanged)
		return;
	fCurrent = anObject;
	if (fComboBox != null) {
		if (notify)
			fComboBox.stateChanged(fCurrent);
		else
			fComboBox.stateChanged(fCurrent, true);
	}
}
}
