package com.ibm.ulc.ui.dataTypes;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 *
 * This class is used for performing the specified formatting operations
 * on the input to a text field.
 */
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
public class UIStringFormatter extends UIDataType {
	/**
	 * Mode can be one of the following:
	 * <pre>
	 * 		IDENTITY = 0;
	 *		ALL_UPPER_CASE = 1;
	 *		ALL_LOWER_CASE = 2;
	 * </pre>
	 * @serial	 
	 */
	protected int fMode = 0;
	/**
	 * The maximum length of the string allowed. (default is -1 which indicates no limit specified)
	 * @serial	 
	 */
	protected int fMaxLength = -1;
public UIStringFormatter() {
}
/**
 * Convert the input string based on the configured length and converion specified.
 * Throw an exception on error.
 *
 * @param phase int	The current validation phase.
 * The phase can be one of the following:
 * <pre>
 *	FORM_NOTIFICATION_IMMEDIATE : Typically no validation is performed in this case the input string is returned as is.
 *	FORM_NOTIFICATION_ON_FOCUS_CHANGE 	 
 * 	FORM_NOTIFICATION_ON_REQUEST
 *	</pre>
 * @param newString The String to convert.
 * @return An object representing the converted String or null.
 *
 * @see IDataType#convertToObject(int, String, Object)
 */
public Object convertToObject(int phase, String newString, Object previousValue) {
	String s = newString;
	int l = s.length();
	if (fMaxLength > 0 && l > fMaxLength) {
		s = s.substring(0, fMaxLength);
		l = fMaxLength;
	}
	switch (fMode) {
		case 0 :
			return s;
		case 1 :
			return s.toUpperCase();
		case 2 :
			return s.toLowerCase();
		default :
			return "*Error*";
	}
}
/**
 * Return the String represenation of the object or the empty string if object is null.
 * The default implementation calls the toString() to return a string representation of the object.
 * Subclasses should override this method to return the formatted data type as a String.
 *
 * @see IDataType#convertToString(Object, boolean)
 */
public String convertToString(Object object, boolean forEditing) {
	if (object == null)
		return "";
	String s = object.toString();
	int l = s.length();
	if (fMaxLength > 0 && l > fMaxLength) {
		s = s.substring(0, fMaxLength);
		l = fMaxLength;
	}
	if (!forEditing) {
		switch (fMode) {
			case 0 :
				return s;
			case 1 :
				return s.toUpperCase();
			case 2 :
				return s.toLowerCase();
			default :
				return "*Error*";
		}
	}
	return s;
}
/**
 * Hook to filter any text input into the field.
 *
 * @param newString The string to filter.
 * @param oldText The current Contents.
 * @return the filtered result, If null input is not accepted.
 * @see IDataType#filterInput(String, String)
 */
public String filterInput(String newString, String oldText) {
	int len = oldText.length();
	if (fMaxLength == -1)
		return newString;
	if (len >= fMaxLength)
		return null;
	return newString;
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	fMode = args.get("mode", 0);
	fMaxLength = args.get("maxLength", -1);
}
}
