package com.ibm.ulc.ui.dataTypes;

/**
 * Insert the type's description here.
 * Creation date: (23-Nov-99 10:54:02 AM)
 * @author: Markus Marzetta (CS-ZRH)
 */
public abstract class UIFloatingDecimalConverter implements IStringConverter {
/**
 * convertToString using FloatingDecimal, if the argument is a Double
 * or an Integer
 */
public String convertToEditString(Object object) {
	return object.toString();
}
/**
 * convertToObject usinf FloatingDecimal.
 */
public abstract Object convertToObject(String string) throws DataTypeConversionException;
/**
 * convertToString using FloatingDecimal, if the argument is a Double
 * or an Integer
 */
public String convertToString(Object object) {
	return object.toString();
}
/**
 * Answer an instance suitable for int, if isInteger == true,
 * for double, otherwise
 *
 * Creation date: (23-Nov-99 5:43:33 PM)
 * @return com.ibm.ulc.ui.dataTypes.UINumberFormatConverter
 * @param isInteger boolean
 */

public static UIFloatingDecimalConverter getInstance(boolean isInteger) {
	if (isInteger) {
		return new UIIntegerFloatingDecimalConverter();
	} else {
		return new UIDoubleFloatingDecimalConverter();
	}
}
}
