package com.ibm.ulc.ui.base;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.peer.*;
import java.io.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.text.*;
import com.ibm.ulc.util.UlcConsole;
import com.ibm.ulc.ui.UI;
public class SwingConsole extends UlcConsole implements Runnable, ActionListener {
	static private final String LINESEP = System.getProperty("line.separator");
	private PrintStream fWriter = null;
	private BufferedReader fReader = null;
	private JFrame fFrame = null;
	private JTextArea fText = null;
	private String fTitle = null;
	private Point fTopLeft = new Point(0, 0);
	private EventQueue fQueue = null;
	protected UI fUI = null;
	public SwingConsole() {
		super();
		initialize();
	}
	public SwingConsole(UI ui) {
		super();
		fUI= ui;
		initialize();
	}
	public SwingConsole(String title) {
		super();
		fTitle= title;
		initialize();
	}
	public SwingConsole(String title, Point topLeft) {
		super();
		fTitle= title;
		fTopLeft= topLeft;
		initialize();
	}
	public void actionPerformed(ActionEvent event) {
		String cmd= event.getActionCommand();
		if (cmd.equals("clear"))
			fText.setText("");
		if (cmd.equals("quit"))
			System.exit(0);
	}
static public UlcConsole createConsole(String title, Point topLeft, UI ui) {
	if (fgConsole == null) {
		fgConsole = new SwingConsole(ui);
		fgConsole.setTitle(title);
		fgConsole.setTopLeft(topLeft);
		if (fgConsole == null)
			return null;
		PrintStream writer = fgConsole.getWriter();
		if (writer == null)
			return null;
		fgOut = writer;
		System.setOut(fgOut);
		fgConsole.start();
	}
	return fgConsole;
}
	private void createWindow() {
	
		// create frame
		fFrame= new JFrame();
		fFrame.setBackground(Color.lightGray);
		if (fTitle != null)
			fFrame.setTitle(fTitle);
		fFrame.setLocation(fTopLeft);
		
		// remember contents
		JComponent contentPane= (JComponent) fFrame.getContentPane();
		contentPane.setBorder(new EmptyBorder(4, 4, 4, 4));

		GridBagLayout gbl= new GridBagLayout();
		contentPane.setLayout(gbl);
		
		GridBagConstraints gbc= new GridBagConstraints();
		
		// create text area
		fText= new JTextArea(new PlainDocument());
		fText.setFont(new Font("Courier", Font.PLAIN, 12));
		JScrollPane sp= new JScrollPane(fText);
		sp.setBorder(new BevelBorder(BevelBorder.LOWERED));
		contentPane.add(sp);
		gbc.fill= GridBagConstraints.BOTH;
		gbc.gridx= 0;   // column 0
		gbc.gridy= 0;   // row 0
		gbc.gridwidth= 2;   // span both columns
		gbc.gridheight= 1;
		gbc.weightx= 1.0;
		gbc.weighty= 1.0;
		gbl.setConstraints(sp, gbc);
		
		// create clear button
		JButton clearButton= new JButton(fUI.getResourceString("ButClearConsole"));
		clearButton.setActionCommand("clear");
		clearButton.addActionListener(this);
		contentPane.add(clearButton);
		gbc.fill= GridBagConstraints.NONE;
		gbc.gridx= 0;   // column 0
		gbc.gridy= 1;   // row 1
		gbc.gridwidth= 1;
		gbc.gridheight= 1;
		gbc.weightx= 1.0;
		gbc.weighty= 0.0;
		gbc.anchor= GridBagConstraints.SOUTHEAST;
		gbc.insets= new Insets(5, 0, 0, 5); /* top left bottom right */
		gbl.setConstraints(clearButton, gbc);
		
		// create quit button
		JButton quitButton= new JButton(fUI.getResourceString("ButQuit"));
		quitButton.setActionCommand("quit");
		quitButton.addActionListener(this);
		contentPane.add(quitButton);
		gbc.fill= GridBagConstraints.NONE;
		gbc.gridx= 1;   // column 1
		gbc.gridy= 1;   // row 1
		gbc.gridwidth= 1;
		gbc.gridheight= 1;
		gbc.weightx= 1.0;
		gbc.weighty= 0.0;
		gbc.anchor= GridBagConstraints.SOUTHWEST;
		gbc.insets= new Insets(5, 5, 0, 0); /* top left bottom right */
		gbl.setConstraints(quitButton, gbc);
		
		
		fFrame.addWindowListener(new AppCloser());
		fFrame.pack();
		fFrame.setSize(400, 300);
		fFrame.setVisible(true);
	}
	public PrintStream getWriter() {
		return fWriter;
	}
	private void initialize() {
		String lookName= UIManager.getSystemLookAndFeelClassName();
		try {
			UIManager.setLookAndFeel(lookName);
		} catch(ClassNotFoundException e) {
			System.out.println("SwingConsole.initialize: ClassNotFoundException");
		} catch(InstantiationException e) {
			System.out.println("SwingConsole.initialize: InstantiationException");
		} catch(IllegalAccessException e) {
			System.out.println("SwingConsole.initialize: IllegalAccessException");
		} catch(UnsupportedLookAndFeelException e) {
			System.out.println("SwingConsole.initialize: UnsupportedLookAndFeelException");
		}		
		Toolkit tk= Toolkit.getDefaultToolkit();
		if (tk != null)
			fQueue= tk.getSystemEventQueue();
		if (fQueue == null) {
			System.err.println("@@@ could not get at event queue");
			return;
		}
		try {
			PipedInputStream inPipe= new PipedInputStream();
			PipedOutputStream outPipe= new PipedOutputStream(inPipe);
			fReader= new BufferedReader(new InputStreamReader(inPipe));
			fWriter= new PrintStream(outPipe, true);
		} catch (IOException e) {
			System.err.println("@@@ could not create piped stream");
		}
	}
	void println(String line) {
	
		if (fFrame == null)   // first time
			createWindow();
			
		Document doc= fText.getDocument();
		int length= doc.getLength();
		
		// is caret at last position in text?
		boolean setAndRevealCaret= false;
		int pos= fText.getCaretPosition();
		if (pos == length)
			setAndRevealCaret= true;
		
		if (length > 10000) {   // getting too big -> shorten
			try {
				doc.remove(0, 1000);
			} catch (BadLocationException e) {
			}
		}
		fText.append(line);
		fText.append(LINESEP);
		
		if (setAndRevealCaret) {
			length= doc.getLength();
			try {
				fText.setCaretPosition(length);
			} catch (IllegalArgumentException e) {
				System.out.println("SwingConsole.println: setCaretPosition out of range");
			}
	        
			// Scroll to make current end of text visible
			//Rectangle rect= fText.getCharacterBounds(length);
			//if (rect != null) // 070
			//	fText.scrollRectToVisible(rect);
		}
	}
	public void run() {
		if (fQueue == null)
			return;
		for (;;) {
			try {
				// read from pipe and append to text area
				// by posting request for println() to main request loop
				String line= fReader.readLine();
				fQueue.postEvent(new ConsolePrintRequest(this, line));
			} catch (IOException e) {
				try {
					// ?get around bug?
					// it looks like I get 'pipe broken' whenever there is no
					// activity on the pipe (timeout or what???)
					Thread.sleep(500);
				} catch (InterruptedException e2) {}
			}
		}
	}
	public void setTitle(String title) {
		fTitle= title;
		// should set window title if window was already created
		// ...
	}
	public void setTopLeft(Point topLeft) {
		fTopLeft= topLeft;
		// should set window position if window was already created
		// ...
	}
	public int start() {
		Thread thread= new Thread(this, "SwingConsole");
		thread.start();
		return 0;
	}
}
