package com.ibm.ulc.ui.base;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.net.URL;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.comm.Registry;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.ui.UI;

public final class ConnectionInProgress extends Thread {
	private ORBConnection fConnection= null;
	private String fConnectionId= null;
	private String fClientData= null;
	private UI fUI= null;
	private String fUrlString= null;
	private IRequestProcessor fReqProc= null;
	private boolean fDispose= false;
	private Registry fRegistry= null;
	private long fWaitMillis= 0;
	private boolean fStopped= false;
	private boolean fRetry= false;
	
	public ConnectionInProgress(UI ui, String connId, String clientData, String urlString,
				IRequestProcessor reqProc, boolean dispose,
				Registry registry, long waitMillis) {
		fUI= ui;
		fConnectionId= connId;
		fClientData= clientData;
		fUrlString= urlString;
		fReqProc= reqProc;
		fDispose= dispose;
		fRegistry= registry;
		fWaitMillis= waitMillis;
	}
	synchronized ORBConnection getConnection() {
		return fConnection;
	}
public UI getUI() {
	return fUI;
}
	public String getUrlString() {
		return fUrlString;
	}
public boolean isStopped() {
	return fStopped;
}
public void retryConnection(boolean retry) {
	fRetry = retry;
}
public void run() {
	boolean connFailed = false;
	do {
		fRetry = false;
		if (fWaitMillis > 0) {
			try {
				Thread.sleep(fWaitMillis);
			} catch (InterruptedException e) {
			}
		}
		ORBConnection conn = new ORBConnection(fUrlString, fReqProc, fConnectionId, fClientData, fDispose, fRegistry);
		Server.propagateConnectionCreated(conn); // notify connection controllers
		setConnection(conn);
		try {
			conn.start();
			Server.propagateConnectionStarted(conn, null); // notify connection controllers
		} catch (UlcTransportException ex) {
			Server.propagateConnectionStarted(conn, ex); // notify connection controllers
			connFailed = true;
		}
		if (!connFailed) {
			fReqProc.addRequest(new ConnectionSucceededRequest(fUI, conn));
			fStopped = true;
		}
	} while (fRetry && !isStopped());
}
	synchronized void setConnection(ORBConnection conn) {
		fConnection= conn;
	}
public void stopMe() {
	fStopped= true;
}
}
