package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1999 Object Technology International Inc.
 */
import java.awt.*;
import java.io.*;
import java.io.FileOutputStream;
import java.util.Vector;
import java.util.Enumeration;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.util.UlcHashtable;
import com.ibm.ulc.comm.ORBConnection;
public class UIResourceFileCache extends UIResourceCacheAbstract {
	protected String fCacheDirectoryName = "cachedResources";
protected void basicRetrieveCacheFor(ICachedResource cachedResource, String cacheName) {
	try {
		FileInputStream stream = new FileInputStream(cacheName);
		cachedResource.readResource(stream);
		stream.close();
	}
	catch (IOException e) {
		System.out.println("Ulc CachedResource: Error reading resource file: " + cacheName);
		return;
	};
}
protected void createCacheFor(ICachedResource cachedResource) {
	String key = getCacheKey(cachedResource);
	String fullPathName = createCacheNameFrom(key);
	try {
		if (testCacheContainer()) {
			FileOutputStream stream = new FileOutputStream(fullPathName, false);
			cachedResource.writeResource((OutputStream) stream);
			stream.flush();
			stream.close();
		}
	}
	catch (IOException e) {
		System.out.println("Ulc CachedResource: Error creating resource file: " + fullPathName);
		return;
	};
}
protected String createCacheNameFrom(String cacheKey) {
	return fCacheDirectoryName + pathSeparator() + super.createCacheNameFrom(cacheKey);
}
protected static String pathSeparator() {
	return File.separator;
}
public void setCacheDirectoryName(String dir) {
	fCacheDirectoryName = dir;
}
protected boolean testCacheContainer() {
	File cacheDir = new File(".", fCacheDirectoryName);
	if (cacheDir.isDirectory()) {
		return true;
	}
	else {
		return cacheDir.mkdirs();
	}
}
protected boolean testCacheContainer(String cacheName) {
	if (testCacheContainer()) {
		File file = new File(".", cacheName); 
		return file.isFile();
	}
	else {
		return false;
	}
}
}
