package com.ibm.ulc.test.cases;

import com.ibm.ulc.base.*;
import com.ibm.ulc.application.*;
import java.util.*;
import java.io.*;
/**
 * Test case for methods which get UI properties
 * @author: Daniel Megert (OTI)
 * @since:	R3.1
 */
public class UlxTestUIProperties extends com.ibm.ulc.test.UlxAbstractTestComposite {
	private ULCBox ivjBox1 = null;
	private ULCBox ivjBox2 = null;
	private ULCBorder ivjControlsBorder = null;
	private ULCSplitPane ivjInnerSplitPane = null;
	private ULCField ivjInputField = null;
	private ULCBorder ivjInstructionsBorder = null;
	private ULCField ivjinstructionText = null;
	private ULCSplitPane ivjMainSplitPane = null;
	private ULCBorder ivjTestBorder = null;
	IvjEventHandler ivjEventHandler = new IvjEventHandler();
	private ULCButton ivjGetCurrentLAF = null;
	private ULCButton ivjGetLAFs = null;
	private ULCButton ivjGetSystemProperty = null;
	private ULCField ivjTextArea = null;
	private ULCButton ivjGetLocal = null;
	private ULCButton ivjGetScreenProperties = null;
	private ULCButton ivjGetAvailableFonts = null;
	private ULCButton ivjGetAllSystemProperties = null;

class IvjEventHandler implements com.ibm.ulc.application.IActionListener {
		public void actionPerformed(com.ibm.ulc.application.ULCActionEvent actionEvent) {
			if (actionEvent.getSource() == UlxTestUIProperties.this.getGetLAFs()) 
				connEtoM1(actionEvent);
			if (actionEvent.getSource() == UlxTestUIProperties.this.getGetCurrentLAF()) 
				connEtoM2(actionEvent);
			if (actionEvent.getSource() == UlxTestUIProperties.this.getGetLocal()) 
				connEtoM3(actionEvent);
			if (actionEvent.getSource() == UlxTestUIProperties.this.getGetSystemProperty()) 
				connEtoM4(actionEvent);
			if (actionEvent.getSource() == UlxTestUIProperties.this.getGetScreenProperties()) 
				connEtoM5(actionEvent);
			if (actionEvent.getSource() == UlxTestUIProperties.this.getGetAvailableFonts()) 
				connEtoM6(actionEvent);
			if (actionEvent.getSource() == UlxTestUIProperties.this.getGetAllSystemProperties()) 
				connEtoM7(actionEvent);
		};
	};
/**
 * UlxTestUIProperties constructor comment.
 */
public UlxTestUIProperties() {
	super();
	initialize();
}
/**
 * UlxTestUIProperties constructor comment.
 * @param usesVajContext com.ibm.ulc.application.IUsesVajContext
 */
public UlxTestUIProperties(com.ibm.ulc.application.IUsesVajContext usesVajContext) {
	super(usesVajContext);
	initialize();
}
/**
 * connEtoM1:  (GetLAFs.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> TextArea.text)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM1(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getTextArea().setText(this.getLAFs());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM2:  (GetCurrentLAF.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> TextArea.text)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM2(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getTextArea().setText(this.getCurrentLAF());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM3:  (GetLocal.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> TextArea.text)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM3(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getTextArea().setText(this.getLocale());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM4:  (GetSystemProperty.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> TextArea.text)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM4(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getTextArea().setText(this.getUISystemProperty());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM5:  (GetScreenProperties.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> TextArea.text)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM5(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getTextArea().setText(this.getScreenProperties());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM6:  (GetDefaultFonts.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> TextArea.text)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM6(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getTextArea().setText(this.getAvailableFontNames());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM7:  (GetAllSystemProperties.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> TextArea.text)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM7(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getTextArea().setText(this.getUISystemProperties());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
protected String getAvailableFontNames() {
	StringWriter answer= new StringWriter();
	String fonts[]= getContext().getUIAvailableFontFamilyNames();
	for (int i= 0; i < fonts.length; i++) {
		answer.write(fonts[i]);
		answer.write('\n');	
	}
	return answer.toString();}
/**
 * Return the Box1 property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getBox1() {
	if (ivjBox1 == null) {
		try {
			ivjBox1 = new com.ibm.ulc.application.ULCBox(1, 1);
			ivjBox1.add(0, 0, com.ibm.ulc.base.IDefaults.BOX_EXPAND_EXPAND, getTextArea());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjBox1;
}
/**
 * Return the Box2 property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getBox2() {
	if (ivjBox2 == null) {
		try {
			ivjBox2 = new com.ibm.ulc.application.ULCBox(7, 2);
			ivjBox2.add(0, 0, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, getGetSystemProperty());
			ivjBox2.add(0, 1, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, 2, getGetAllSystemProperties());
			ivjBox2.add(1, 0, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, getInputField());
			ivjBox2.add(0, 2, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, 2, getGetLAFs());
			ivjBox2.add(0, 3, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, 2, getGetCurrentLAF());
			ivjBox2.add(0, 4, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, 2, getGetScreenProperties());
			ivjBox2.add(0, 5, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, 2, getGetLocal());
			ivjBox2.add(0, 6, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, 2, getGetAvailableFonts());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjBox2;
}
/**
 * Return the ControlsBorder property value.
 * @return com.ibm.ulc.application.ULCBorder
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBorder getControlsBorder() {
	if (ivjControlsBorder == null) {
		try {
			ivjControlsBorder = new com.ibm.ulc.application.ULCBorder("Controls");
			ivjControlsBorder.add(getBox2());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjControlsBorder;
}
private String getCurrentLAF() {
	return getContext().getLook();
}
/**
 * Return the GetAllSystemProperties property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getGetAllSystemProperties() {
	if (ivjGetAllSystemProperties == null) {
		try {
			ivjGetAllSystemProperties = new com.ibm.ulc.application.ULCButton("Get all System Properties");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjGetAllSystemProperties;
}
/**
 * Return the GetDefaultFonts property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getGetAvailableFonts() {
	if (ivjGetAvailableFonts == null) {
		try {
			ivjGetAvailableFonts = new com.ibm.ulc.application.ULCButton("Get AvailableFonts");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjGetAvailableFonts;
}
/**
 * Return the SetGreenIconButton property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getGetCurrentLAF() {
	if (ivjGetCurrentLAF == null) {
		try {
			ivjGetCurrentLAF = new com.ibm.ulc.application.ULCButton("Get current Look and Feel");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjGetCurrentLAF;
}
/**
 * Return the SetRedIconButton property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getGetLAFs() {
	if (ivjGetLAFs == null) {
		try {
			ivjGetLAFs = new com.ibm.ulc.application.ULCButton("Get Look and Feels");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjGetLAFs;
}
/**
 * Return the GetLocal property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getGetLocal() {
	if (ivjGetLocal == null) {
		try {
			ivjGetLocal = new com.ibm.ulc.application.ULCButton("Get Locale");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjGetLocal;
}
/**
 * Return the SetNoIconButton property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getGetScreenProperties() {
	if (ivjGetScreenProperties == null) {
		try {
			ivjGetScreenProperties = new com.ibm.ulc.application.ULCButton("Get Screen Properties");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjGetScreenProperties;
}
/**
 * Return the SetTextButton property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getGetSystemProperty() {
	if (ivjGetSystemProperty == null) {
		try {
			ivjGetSystemProperty = new com.ibm.ulc.application.ULCButton("Get System Property");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjGetSystemProperty;
}
/**
 * Return the InnerSplitPane property value.
 * @return com.ibm.ulc.application.ULCSplitPane
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCSplitPane getInnerSplitPane() {
	if (ivjInnerSplitPane == null) {
		try {
			ivjInnerSplitPane = new com.ibm.ulc.application.ULCSplitPane(true, getControlsBorder(), getInstructionsBorder());
			ivjInnerSplitPane.setDividerLocation((double) 0.7);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjInnerSplitPane;
}
/**
 * Return the InputField property value.
 * @return com.ibm.ulc.application.ULCField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCField getInputField() {
	if (ivjInputField == null) {
		try {
			ivjInputField = new com.ibm.ulc.application.ULCField();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjInputField;
}
protected String getInstruction() {
	return "Get the properties you want and\nverify the value in the test window";
}
/**
 * Return the InstructionsBorder property value.
 * @return com.ibm.ulc.application.ULCBorder
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBorder getInstructionsBorder() {
	if (ivjInstructionsBorder == null) {
		try {
			ivjInstructionsBorder = new com.ibm.ulc.application.ULCBorder("Instructions");
			ivjInstructionsBorder.add(getinstructionText());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjInstructionsBorder;
}
/**
 * Return the instructionText property value.
 * @return com.ibm.ulc.application.ULCField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCField getinstructionText() {
	if (ivjinstructionText == null) {
		try {
			ivjinstructionText = new com.ibm.ulc.application.ULCField(5, 30);
			ivjinstructionText.setLineWrap(true);
			ivjinstructionText.setEditable(false);
			ivjinstructionText.setWordWrap(true);
			// user code begin {1}
			ivjinstructionText.setValue(getInstruction());			
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjinstructionText;
}
private String getLAFs() {
	Enumeration looks= getContext().getInstalledLookAndFeels().elements();
	StringWriter answer= new StringWriter();
	for (; looks.hasMoreElements();) {
		Look look= (Look) looks.nextElement();
		answer.write(look.getName());
		answer.write(": ");
		answer.write(look.getClassName());
		answer.write('\n');
	}
	return answer.toString();
}
private String getLocale() {
	return getContext().getUILocale().toString();
}
/**
 * Return the MainSplitPane property value.
 * @return com.ibm.ulc.application.ULCSplitPane
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCSplitPane getMainSplitPane() {
	if (ivjMainSplitPane == null) {
		try {
			ivjMainSplitPane = new com.ibm.ulc.application.ULCSplitPane(false, getTestBorder(), getInnerSplitPane());
			ivjMainSplitPane.setDividerLocation((double) 0.7);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjMainSplitPane;
}
private String getScreenProperties() {
	StringWriter answer= new StringWriter();
	answer.write("resolution: " + getContext().getUIScreenResolution());
	answer.write('\n');	
	answer.write("height: " + getContext().getUIScreenHeight());
	answer.write('\n');	
	answer.write("width: " + getContext().getUIScreenWidth());
	return answer.toString();
}
/**
 * Return the TestBorder property value.
 * @return com.ibm.ulc.application.ULCBorder
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBorder getTestBorder() {
	if (ivjTestBorder == null) {
		try {
			ivjTestBorder = new com.ibm.ulc.application.ULCBorder("Test Area");
			ivjTestBorder.add(getBox1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjTestBorder;
}
/**
 * Return the TextArea property value.
 * @return com.ibm.ulc.application.ULCField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCField getTextArea() {
	if (ivjTextArea == null) {
		try {
			ivjTextArea = new com.ibm.ulc.application.ULCField(5, 10);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjTextArea;
}
private java.lang.String getUISystemProperties() {
	Vector v= new Vector(System.getProperties().keySet());
	Properties props= getContext().getUISystemProperties(v);
	if (props == null)
		return "SecurityException occured";
	return props.toString();
}
private java.lang.String getUISystemProperty() {
	String value= getContext().getUISystemProperty(getInputField().getText());
	if (value == null)
		value= "There's no such key or a SecurityException occured";
	return value;
}
/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(java.lang.Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	exception.printStackTrace(System.out);
}
/**
 * Initializes connections
 * @exception java.lang.Exception The exception description.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() throws java.lang.Exception {
	// user code begin {1}
	// user code end
	getGetLAFs().addActionListener(ivjEventHandler);
	getGetCurrentLAF().addActionListener(ivjEventHandler);
	getGetLocal().addActionListener(ivjEventHandler);
	getGetSystemProperty().addActionListener(ivjEventHandler);
	getGetScreenProperties().addActionListener(ivjEventHandler);
	getGetAvailableFonts().addActionListener(ivjEventHandler);
	getGetAllSystemProperties().addActionListener(ivjEventHandler);
}
/**
 * Initialize the class.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	try {
		// user code begin {1}
		// user code end
		// user code begin {2}
		// user code end
		setComponent(getMainSplitPane());
		initConnections();
		// user code begin {3}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
	// user code begin {4}
	// user code end
}
/**
 * main entrypoint - starts the part when it is run as an application
 * @param args java.lang.String[]
 */
public static void main(java.lang.String[] args) {
	try {
		com.ibm.ulc.application.ULCVajContext.testULCClass(args, UlxTestUIProperties.class);
	} catch (Throwable exception) {
		System.err.println("Exception occurred in main() of com.ibm.ulc.test.UlxAbstractTestComposite");
		exception.printStackTrace(System.out);
	}
}
/**
 * Please do not use or rely on this method. It is used by the VAJava test process.
 * It is public only so that the ULCVajContext class can access the method.
 * It can change at any time, or it could be entirely removed in any update 
 * to the VAJava builder. Thank you.
 * @return com.ibm.ulc.application.ULCComponent
 * @param context com.ibm.ulc.application.ULCVajContext
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public static com.ibm.ulc.application.ULCComponent mainTestConstruction(com.ibm.ulc.application.ULCVajContext context) {
	return new UlxTestUIProperties(context);
}
/**
 * Adds, selects and removes some items
 */
public boolean runIt(boolean visibly) {
	boolean result= true;
	testStarted("com.ibm.ulc.test.cases.UlxTestUIProperties");	
	try {
		testMessage("Getting LAFs");
		getLAFs();
		pause();
		testMessage("Getting current LAF");
		getCurrentLAF();
		pause();
		testMessage("Getting current Locale");
		getLocale();
		testMessage("Getting some system property");
		getContext().getUISystemProperty("java.version");
		if (getContext().getUISystemProperty("xxx") != null)
			result= false;
		pause();
		testMessage("Getting fonts");
		getAvailableFontNames();
		pause();
		testMessage("Getting screen properties");
		getScreenProperties();
		pause();		
		testCompleted(result);
		return result;
	}
	catch (Throwable e) {
		testCompleted(false);
		return false;
	}
}
public static java.lang.String testAuthor() {
	return "OTI";
}
public static java.lang.String[] testCategories() {
	return new String[] {};
}
public static String testDescription() {
	return "Get UI Engine properties";
}
public static java.lang.String[] testedAPI() {
	return new String[] {"getLook", "getInstalledLookAndFeels", "getUIAvailableFontFamilyNames",
		"getUILocale", "getUIScreenHeight", "getUIScreenResolution", "getUIScreenWidth",
		"getUISystemProperty"};
}
/**
 * Answer the names of the ULC classes tested in this component.
 *
 * Unless the classse tested are defined in <code>com.ibm.ulc.application</code>, the
 * class names must be fully specified. This information is optional if @testedPRs 
 * is specified.
 */
static public String[] testedClasses() {
	return new String[] {"Context"};
}
/**
 * Answer the names of the PR verified by this component.
 *
 * The answer contains the name(s) of the PR which the receiver verfies. This
 * information is optional if @testedClasses and/or testedAPI is specified.
 */
static public String[] testedPRs() {
	return new String[] {"1FSMF2W", "1FSMEML"};
}
public static java.lang.String testPageTabString() {
	return "UI Properties tests";
}
}
