package com.ibm.ulc.test;

//import com.ibm.ulc.base.*;
import com.ibm.ulc.application.*;
import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.*;
/**
 * This class implements the infrastructure for a set of ULC tests.
 */
import java.util.Vector;
import java.util.Enumeration;
public class UlxSystem implements IUlxTestListener, IWindowCloseVoter {
	private UlxAbstractDevelopmentImplementation fDevelopment = null;
	private Vector fTestSuites = new Vector();
	public UlxTest[] fAvailableTests = new UlxTest[0];
	private Vector fOpenWindows = new Vector();
	private ULCVajContext fContext;
	private String fLastPackageName = "com.ibm.ulc.test.cases";
	private String fLastAuthorName = "OTI";
	private GenericTableModel fTableModel = new GenericTableModel();
	private GenericTableModel fClassesTableModel = new GenericTableModel();
	private GenericTableModel fApiTableModel = new GenericTableModel();
	private GenericTableModel fPrTableModel = new GenericTableModel();
	private ULCSortedItemList fSortedTestsItemList = new ULCSortedItemList();
	private ULCSortedItemList fSortedClassesItemList = new ULCSortedItemList();
	private ULCSortedItemList fSortedApisItemList = new ULCSortedItemList();
	private ULCSortedItemList fSortedPRItemList = new ULCSortedItemList();
	private ULCBlockInputTrigger fBusyTrigger = null;
	private ULCIcon fAscendingIcon = null;
	private ULCIcon fDescendingIcon = null;
	Anything fProperties = null;
/**
 * Create a new instance of the receiver.
 */
public UlxSystem() {
	fDevelopment = UlxAbstractDevelopmentImplementation.create(this);
	setAvailableTests(fDevelopment.computeAvailableTests());
	getTableModel().setNotificationPolicy(GenericTableModel.TABLE_EDIT_UPDATE_ON_REQUEST);
}
/**
 * Create a new instance of the receiver.
 */
UlxSystem(ULCVajContext context) {
	this();
	fContext = context;
}
/**
 * Read the file holding the names of all tests and answer a String array of class names.
 *
 */
void addTest(UlxTest test) {
	if (!UlxCollection.contains(fAvailableTests, test)) {
		fAvailableTests = (UlxTest[]) UlxCollection.add((new UlxTest[fAvailableTests.length + 1]), fAvailableTests, (Object) test);
		fTableModel.addRow(test);
	}
	update(getClassesTableModel(), test.getTestedClasses());
	update(getApiTableModel(), test.getTestedAPI());
	update(getPRTableModel(), test.getTestedPRs());
}
/**
 * Create a new instance of the receiver.
 */
public void addTestSuite(UlxTestSuite testSuite) {
	if (!fTestSuites.contains(testSuite))
		fTestSuites.addElement(testSuite);
}
/**
 * Perform the addWindow method.
 * @param window com.ibm.ulc.test.UlxWindowAbstract
 */
public void addWindow(UlxWindowAbstract window) {
	if (!knowsWindow(window)) {
		fOpenWindows.addElement(window);
		window.addWindowClosingListener(this);
	}
}
/**
 * Answer true, if the current environment can open VisualAge browsers.
 */
public boolean canBrowse() {
	return fDevelopment.canBrowse();
}
/**
 * Answer true, if the current environment can open VisualAge inspectors.
 */
public boolean canInspect() {
	return fDevelopment.canInspect();
}
/**
 * Answer true, if the current environment can open VisualAge inspectors.
 */
public boolean canRunTest() {
	return fDevelopment.canRunTest();
}
/**
 * Create a new instance of the receiver.
 */
ULCSortedItemList getApiItemList() {
	return fSortedApisItemList; 
}
/**
 * Create a new instance of the receiver.
 */
GenericTableModel getApiTableModel() {
	return fApiTableModel;
}
/**
 * Create a new instance of the receiver.
 */
ULCApplication getApplication() {
	return fContext.getApplication();
}
public ULCIcon getAscendingIcon() {
	if (fAscendingIcon == null)
		fAscendingIcon = new ULCIcon(getClass().getResource("/ascending.gif"));
	return fAscendingIcon;
}
public ULCBlockInputTrigger getBusyTrigger() {
	if (fBusyTrigger == null) {
		fBusyTrigger = new com.ibm.ulc.application.ULCBlockInputTrigger();
		fBusyTrigger.setMode(com.ibm.ulc.base.IDefaults.TRIGGER_ALL_SHELLS);
		fBusyTrigger.setTriggerOn(com.ibm.ulc.base.IDefaults.TRIGGER_ON_ACTION);
	}
	return fBusyTrigger;
}
/**
 * Create a new instance of the receiver.
 */
ULCSortedItemList getClassesItemList() {
	return fSortedClassesItemList;
}
/**
 * Create a new instance of the receiver.
 */
GenericTableModel getClassesTableModel() {
	return fClassesTableModel;
}
String[] getClassesUnderstandingApi(String[] selectors) {
	return fDevelopment.getClassesUnderstandingApi(selectors);
}
Vector getComposedTestsCoveringClassesAPI(Vector classes, Vector api) {
	Enumeration found = getTestsCoveringClassesAPI(classes, api).elements();
	Vector answer = new Vector();
	while (found.hasMoreElements()) {
		UlxTest test = (UlxTest) found.nextElement();
		if (test.isComposedTest())
			answer.addElement(test);
	}
	return answer;
}
/**
 * Create a new instance of the receiver.
 */
ULCVajContext getContext() {
	return fContext;
}
public ULCIcon getDescendingIcon() {
	if (fDescendingIcon == null)
		fDescendingIcon = new ULCIcon(getClass().getResource("/descending.gif"));
	return fDescendingIcon;
}
public ULCIcon getGreenBall() {
	Object answer = getContext().getProperty("green-ball", null);
	if (answer == null) {
		answer = new ULCIcon(getClass().getResource("/green-ball.gif"), true);
		getContext().setProperty("green-ball", answer);
	}
	return (ULCIcon) answer;
}
/**
 * Answer the author name last used.
 */
String getLastAuthorName() {
	return fLastAuthorName;
}
/**
 * Answer the package name last used.
 */
String getLastPackageName() {
	return fLastPackageName;
}
public Anything getProperties() {
	if (fProperties == null)
		fProperties = new Anything();
	return fProperties;
}
public int getPropertyValue(String key, int defaultValue) {
	if (fProperties == null)
		return defaultValue;
	Anything ret = fProperties.get(key);
	if (ret != null)
		return ret.asInt(defaultValue);
	else
		return defaultValue;
}
public Object getPropertyValue(String key, Object defaultValue) {
	if (fProperties == null)
		return defaultValue;
	Anything ret = fProperties.get(key);
	if (ret != null)
		return Common.convertFromAnything(ret);
	else
		return defaultValue;
}
/**
 * Create a new instance of the receiver.
 */
ULCSortedItemList getPRsItemList() {
	return fSortedPRItemList;
}
/**
 * Create a new instance of the receiver.
 */
GenericTableModel getPRTableModel() {
	return fPrTableModel;
}
public ULCIcon getRedBall() {
	Object answer = getContext().getProperty("red-ball", null);
	if (answer == null) {
		answer = new ULCIcon(getClass().getResource("/red-ball.gif"), true);
		getContext().setProperty("red-ball", answer);
	}
	return (ULCIcon) answer;
}
/**
 * Create a new instance of the receiver.
 */
GenericTableModel getTableModel() {
	return fTableModel;
}
String[] getTestedApiFor(String[] classNames) {
	return fDevelopment.getTestedApiFor(classNames);
}
Vector getTestsCoveringClassesAPI(Vector classes, Vector api) {
	String[] apis = new String[api.size()];
	api.copyInto(apis);
	Vector answer = new Vector();
	if (classes.size() > 0) {
		for (int i = 0; i < fAvailableTests.length; i++) {
			if (!fAvailableTests[i].isApiTest()) {
				String[] classNames = fAvailableTests[i].getTestedClasses();
				for (int j = 0; j < classes.size(); j++) {
					if (UlxCollection.contains(classNames, classes.elementAt(j))) {
						if (api.size() == 0) {
							if (!answer.contains(fAvailableTests[i])) {
								answer.addElement(fAvailableTests[i]);
								break;
							}
						} else {
							String[] apiNames = fAvailableTests[i].getTestedAPI();
							if (UlxCollection.containsAll(apiNames, apis)) {
								if (!answer.contains(fAvailableTests[i])) {
									answer.addElement(fAvailableTests[i]);
									//break;
								}
							}
						}
					}
				}
			} else {
			}
		}
	} else {
		if (api.size() == 0) {
			for (int i = 0; i < fAvailableTests.length; i++) {
				if (!fAvailableTests[i].isApiTest())
					answer.addElement(fAvailableTests[i]);
			}
		} else {
			for (int i = 0; i < fAvailableTests.length; i++) {
				if (!fAvailableTests[i].isClassTest()) {
					String[] apiNames = fAvailableTests[i].getTestedAPI();
					for (int k = 0; k < api.size(); k++) {
						if (UlxCollection.contains(apiNames, api.elementAt(k))) {
							if (!answer.contains(fAvailableTests[i]))
								answer.addElement(fAvailableTests[i]);
						}
					}
				}
			}
		}
	}
	return answer;
}
Vector getTestsCoveringPRs(Vector prs) {
	Vector answer = new Vector();
	if (prs.size() > 0) {
		for (int i = 0; i < fAvailableTests.length; i++) {
			String[] testPrs = fAvailableTests[i].getTestedPRs();
			for (int j = 0; j < prs.size(); j++) {
				if (UlxCollection.contains(testPrs, prs.elementAt(j))) {
					if (!answer.contains(fAvailableTests[i])) {
						answer.addElement(fAvailableTests[i]);
						break;
					}
				}
			}
		}
	}
	else {
		for (int i = 0; i < fAvailableTests.length; i++)
			answer.addElement(fAvailableTests[i]);
	}
	return answer;
}
public ULCIcon getYellowBall() {
	Object answer = getContext().getProperty("yellow-ball", null);
	if (answer == null) {
		answer = new ULCIcon(getClass().getResource("/yellow-ball.gif"), true);
		getContext().setProperty("yellow-ball", answer);
	}
	return (ULCIcon) answer;
}
/**
 * answer the index into the receiver's collection of tests for @test
 */
int indexOf(UlxTest test) {
	Object[] rows = UlxCollection.copyToArray(getTableModel().getRows());
	return UlxCollection.indexOf(rows, test);
}
/**
 * Open a VisualAge inspector on object. Do nothing, if the current environment does not include
 * the VA development classes needed.
 */
public void inspect(Object object) {
	fDevelopment.inspect((Object) object);
}
/**
 * Create a new instance of the receiver.
 */
boolean knowsWindow(UlxWindowAbstract window) {
	return fOpenWindows.contains(window);
}
/**
 * Create a new instance of the receiver.
 */
UlxTest newTest() {
	UlxTest answer = new UlxTest(this);
	answer.setTestPackageName(getLastPackageName());
	fAvailableTests = (UlxTest[]) UlxCollection.add(new UlxTest[fAvailableTests.length + 1], fAvailableTests, answer);
	answer.setIdentifier(UlxCollection.indexOf(fAvailableTests, answer));
	answer.addListener(this);
	getTableModel().addRow(answer);
	return answer;
}
/**
 * Create a new instance of the receiver.
 */
UlxTest newTest(Class cls) {
	UlxTest answer = newTest();
	answer.setTestClass(cls);
	return answer;
}
/**
 * Open a VisualAge browser on @cls. Do nothing, if the current environment does not include
 * the VA development classes needed.
 */
public void openBrowserOn(Class cls) {
	fDevelopment.openBrowserOn(cls);
}
/**
 * Create a new instance of the receiver.
 */
void processAllIncomingRequests() {
	if (getContext() != null) {
		boolean timedOut = false;
		while (!timedOut) {
			timedOut = getContext().processNextRequest(1000);
		}
	}
}
/**
 * Open the package prompter of VisualAge. Do nothing, if the prompter is not available..
 */
public String promptForPackageName() {
	String answer = fDevelopment.promptForPackageName(getLastPackageName());
	if (answer != null)
		setLastPackageName(answer);
	return answer;
}
/**
 * quit the receiver's ULCApplication after having polled all open windows for window closed event.
 */
public void quit() {
	(new UlxBallot()).handleQuitRequest(this, fOpenWindows);
}
public void readProperties() {
	fProperties=Anything.read("UlcTestBench.preferences");
}
/**
 * remove a testSuite from the receiver.
 */
public void removeTestSuite(UlxTestSuite testSuite) {
	if (fTestSuites.contains(testSuite))
		fTestSuites.removeElement(testSuite);
}
/**
 * Perform the removeWindow method.
 * @param window com.ibm.ulc.test.UlxWindowAbstract
 */
public void removeWindow(UlxWindowAbstract window) {
	if (knowsWindow(window)) {
		fOpenWindows.removeElement(window);
	}
}
/**
 * Open a VisualAge inspector on object. Do nothing, if the current environment does not include
 * the VA development classes needed.
 */
public void run(UlxTest[] tests) {
	inspect(tests);
}
/**
 * Open a VisualAge inspector on object. Do nothing, if the current environment does not include
 * the VA development classes needed.
 */
public void run(UlxTest test) {
	if (!test.isNewTest()) {
		if (fContext != null) {
			try {
				java.lang.reflect.Constructor constructor = test.getTestClass().getConstructor(new Class[0]);
				UlxAbstractTestComposite composite = (UlxAbstractTestComposite) constructor.newInstance(new Object[0]);
				ULCShell shell = new ULCShell("Testing " + test.getQualifiedClassName());
				shell.add(composite);
				ULCApplication app = new ULCApplication(fContext);
				app.add(shell);
				shell.setVisible(true);
			} catch (Throwable t) {
				t.toString();
			}
		}
	}
}
/**
 * Read the file holding the names of all tests and answer a String array of class names.
 *
 */
void setApiTableModel(Vector tests) {
	Vector methodNames = (Vector) fDevelopment.getTestedAPI().clone();
	for (int i = 0; i < tests.size(); i++) {
		UlxTest test = (UlxTest) tests.elementAt(i);
		UlxCollection.addUnique(methodNames, test.getTestedAPI());
	}
	setRows(getApiTableModel(), methodNames);
	fSortedApisItemList.setAttributeNames(new String[] {"string"});
	fSortedApisItemList.setModel(getApiTableModel());
}

/**
 * Read the file holding the names of all tests and answer a String array of class names.
 *
 */

void setAvailableTests(Vector classes) {
	Enumeration enum = classes.elements();
	Vector tests = new Vector(classes.size());
	while (enum.hasMoreElements()) {
		tests.addElement(new UlxTest(this, (Class) enum.nextElement()));
	}
	setClassesTableModel(tests);
	setApiTableModel(tests);
	setPrTableModel(tests);
	Enumeration ct = fDevelopment.getComposedTests();
	while (ct.hasMoreElements()) {
		tests.addElement(ct.nextElement());
	}
	fAvailableTests = new UlxTest[tests.size()];
	tests.copyInto(fAvailableTests);
	for (int i = 0; i < fAvailableTests.length; i++) {
		fAvailableTests[i].setIdentifier(i);
	}
	fTableModel.setRows(tests);
	fSortedTestsItemList.setAttributeNames(new String[] {"testClassName", "testPackageName"});
	fSortedTestsItemList.setModel(fTableModel);
}
/**
 * Read the file holding the names of all tests and answer a String array of class names.
 *
 */
void setClassesTableModel(Vector tests) {
	Vector classNames = (Vector) fDevelopment.getTestedClasses().clone();
	for (int i = 0; i < tests.size(); i++) {
		UlxTest test = (UlxTest) tests.elementAt(i);
		UlxCollection.addUnique(classNames, test.getTestedClasses());
	}
	setRows(getClassesTableModel(), classNames);
	fSortedClassesItemList.setAttributeNames(new String[] {"string"});
	fSortedClassesItemList.setModel(getClassesTableModel());
}
/**
 * set the author name used last to @string
 */
public void setLastAuthorName(String string) {
	if (string.length() > 0)
		fLastAuthorName = string;
}
/**
 * set the package name used last to @string
 */
public void setLastPackageName(String string) {
	if (string.length() > 0)
		fLastPackageName = string;
}
/**
 * Read the file holding the names of all tests and answer a String array of class names.
 *
 */
void setPrTableModel(Vector tests) {
	Vector prNames = new Vector();
	for (int i = 0; i < tests.size(); i++) {
		UlxTest test = (UlxTest) tests.elementAt(i);
		UlxCollection.addUnique(prNames, test.getTestedPRs());
	}
	setRows(getPRTableModel(), prNames);
	fSortedPRItemList.setAttributeNames(new String[] {"string"});
	fSortedPRItemList.setModel(getPRTableModel());
}
/**
 * Read the file holding the names of all tests and answer a String array of class names.
 *
 */
void setRows(GenericTableModel tableModel, Vector strings) {
	Vector rows = new Vector();
	for (int i = 0; i < strings.size(); i++) {
		UlcHashtable tableRow = new UlcHashtable();
		tableRow.put("string", strings.elementAt(i));
		rows.addElement(tableRow);
	}
	tableModel.setRows(rows);
}
/**
 * Create a new instance of the receiver.
 */
void start() {
	UlxWindowWorkbench workbench = new UlxWindowWorkbench(fContext);
	getApplication().add(workbench);
	workbench.setVisible(true);
}
/**
 * The @attributeNames of a UlxTest has changed. Have the current development
 * implementation update its source.
 *
 * @param attributeNames	String[] 	all attributes that changed
 * @param newValues			Object[]	all new values 
 */
public void testChanged(UlxTest test, String[] attributeNames) {
	boolean updateNeeded = fDevelopment.testChanged(test);
	if (updateNeeded)
		addTest(test);
}
private void update(GenericTableModel tableModel, String[] strings) {
	ITableRow[] rows = new ITableRow[tableModel.getRowCount()];
	tableModel.getRows().copyInto(rows);
	for (int i = 0; i < strings.length; i++) {
		String string = strings[i];
		boolean contained = false;
		for (int j = 0; j < rows.length; j++) {
			if (rows[j].getValueAt("string").equals(string)) {
				contained = true;
				break;
			};
		}
		if (!contained) {
			ITableRow row = new UlcHashtable();
			row.setValueAt(string, "string");
			tableModel.addRow(row);
		}
	}
}
/**
 * Create a new instance of the receiver.
 */
public boolean voteOnWindowClose(UlxWindowAbstract window) {
	boolean isLastWindow = knowsWindow(window) && (fOpenWindows.size() == 1);
	boolean answer = !isLastWindow;
	if (isLastWindow)
		answer = window.confirm("Exiting this window closes the Test Application. Continue?");
	return answer;
}
public void writeProperties() {
//	getProperties().put("lastPageViewed", fNotebook.getActiveTab());
//	getProperties().put("tabPlacement", fNotebook.getTabPlacement());
//	getProperties().put("width", fShell.getSize().width);
//	getProperties().put("height", fShell.getSize().height);
	getProperties().write("UlcTestBench.preferences");
}
}
