package com.ibm.ulc.examples.carRental.views;

import com.ibm.ulc.base.*;
import com.ibm.ulc.application.*;
import com.ibm.ulc.examples.carRental.model.Location;

/**
 * A composite showing countries, states and locations in a hierarchy,
 * and allowing to make a selection.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */

public class LocationSelectionForm extends AbstractComposite {
	private ULCBox ivjBox1 = null;
	private ULCCheckbox ivjCheckBox1 = null;
	private ULCColumn ivjColumn1 = null;
	private ULCBorder ivjLocationBorder = null;
	private ULCTreeTable ivjLocationTreeTable = null;
	private ULCLabel ivjUseMouseRightLabel = null;
	private ULCBrowserContext ivjBrowserContext1 = null;
	private ULCTreeTableModel ivjLocationTreeModel = null;
	private ULCTreeRowModel ivjTreeRowModel = null;
	protected transient java.beans.PropertyChangeSupport propertyChange;
	private ULCMenu ivjAreaMenu = null;
	private ULCMenuItem ivjLocationDetailsMenuItem = null;
	private ULCMenu ivjLocationMenu = null;
	private ULCMenuItem ivjShowMapMenuItemA = null;
	private ULCMenuItem ivjShowMapMenuItemL = null;
	private ULCMenu ivjTreeMenu = null;
	IvjEventHandler ivjEventHandler = new IvjEventHandler();

class IvjEventHandler implements com.ibm.ulc.application.IActionListener {
		public void actionPerformed(com.ibm.ulc.application.ULCActionEvent actionEvent) {
			if (actionEvent.getSource() == LocationSelectionForm.this.getShowMapMenuItemA()) 
				connEtoC1(actionEvent);
			if (actionEvent.getSource() == LocationSelectionForm.this.getShowMapMenuItemL()) 
				connEtoC2(actionEvent);
			if (actionEvent.getSource() == LocationSelectionForm.this.getLocationDetailsMenuItem()) 
				connEtoC3(actionEvent);
		};
	};
/**
 * LocationSelectionForm constructor comment.
 */
public LocationSelectionForm() {
	super();
	initialize();
}
/**
 * LocationSelectionForm constructor comment.
 * @param usesVajContext com.ibm.ulc.application.IUsesVajContext
 */
public LocationSelectionForm(com.ibm.ulc.application.IUsesVajContext usesVajContext) {
	super(usesVajContext);
	initialize();
}
/**
 * The addPropertyChangeListener method was generated to support the propertyChange field.
 * @param listener java.beans.PropertyChangeListener
 */
public synchronized void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().addPropertyChangeListener(listener);
}
/**
 * The addPropertyChangeListener method was generated to support the propertyChange field.
 * @param propertyName java.lang.String
 * @param listener java.beans.PropertyChangeListener
 */
public synchronized void addPropertyChangeListener(java.lang.String propertyName, java.beans.PropertyChangeListener listener) {
	getPropertyChange().addPropertyChangeListener(propertyName, listener);
}
/**
 * connEtoC1:  (ShowMapMenuItemA.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> LocationSelectionForm.showMapMenuItemA_ActionPerformed(Lcom.ibm.ulc.application.ULCActionEvent;Ljava.lang.Object;)V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC1(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.showMapMenuItemA_ActionPerformed(arg1, getLocationTreeTable().getSelectedItem());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC2:  (ShowMapMenuItemL.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> LocationSelectionForm.showMapMenuItemL_ActionPerformed(Lcom.ibm.ulc.application.ULCActionEvent;Ljava.lang.Object;)V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC2(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.showMapMenuItemL_ActionPerformed(arg1, getLocationTreeTable().getSelectedItem());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC3:  (LocationDetailsMenuItem.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> LocationSelectionForm.locationDetailsMenuItem_ActionPerformed(Lcom.ibm.ulc.application.ULCActionEvent;Ljava.lang.Object;)V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC3(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.locationDetailsMenuItem_ActionPerformed(arg1, getLocationTreeTable().getSelectedItem());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM1:  (LocationSelectionForm.initialize() --> LocationTreeTable.setTreeColumnLabel(Ljava.lang.String;)V)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM1() {
	try {
		// user code begin {1}
		// user code end
		getLocationTreeTable().setTreeColumnLabel("");
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM2:  (LocationSelectionForm.initialize() --> LocationTreeTable.setTreeColumnAttributeName(Ljava.lang.String;)V)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM2() {
	try {
		// user code begin {1}
		// user code end
		getLocationTreeTable().setTreeColumnAttributeName("label");
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP1SetTarget:  (CheckBox1.this <--> Column1.renderer)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP1SetTarget() {
	/* Set the target from the source */
	try {
		getColumn1().setRenderer(getCheckBox1());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP2SetTarget:  (LocationTreeModel.this <--> TreeRowModel.tableModel)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP2SetTarget() {
	/* Set the target from the source */
	try {
		if ((getLocationTreeModel() != null)) {
			getTreeRowModel().setTableModel(getLocationTreeModel());
		}
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP3SetTarget:  (LocationTreeModel.this <--> LocationTreeTable.model)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP3SetTarget() {
	/* Set the target from the source */
	try {
		if ((getLocationTreeModel() != null)) {
			getLocationTreeTable().setModel(getLocationTreeModel());
		}
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP4SetTarget:  (LocationTreeTable.this <--> TreeRowModel.tree)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP4SetTarget() {
	/* Set the target from the source */
	try {
		getTreeRowModel().setTree(getLocationTreeTable());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP5SetTarget:  (TreeMenu.this <--> LocationTreeTable.popupMenu)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP5SetTarget() {
	/* Set the target from the source */
	try {
		getLocationTreeTable().setPopupMenu(getTreeMenu());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP6SetTarget:  (TreeRowModel.this <--> AreaMenu.formModel)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP6SetTarget() {
	/* Set the target from the source */
	try {
		getAreaMenu().setFormModel(getTreeRowModel());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP7SetTarget:  (TreeRowModel.this <--> LocationMenu.formModel)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP7SetTarget() {
	/* Set the target from the source */
	try {
		getLocationMenu().setFormModel(getTreeRowModel());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * The firePropertyChange method was generated to support the propertyChange field.
 * @param evt java.beans.PropertyChangeEvent
 */
public void firePropertyChange(java.beans.PropertyChangeEvent evt) {
	getPropertyChange().firePropertyChange(evt);
}
/**
 * The firePropertyChange method was generated to support the propertyChange field.
 * @param propertyName java.lang.String
 * @param oldValue int
 * @param newValue int
 */
public void firePropertyChange(java.lang.String propertyName, int oldValue, int newValue) {
	getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
}
/**
 * The firePropertyChange method was generated to support the propertyChange field.
 * @param propertyName java.lang.String
 * @param oldValue java.lang.Object
 * @param newValue java.lang.Object
 */
public void firePropertyChange(java.lang.String propertyName, java.lang.Object oldValue, java.lang.Object newValue) {
	getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
}
/**
 * The firePropertyChange method was generated to support the propertyChange field.
 * @param propertyName java.lang.String
 * @param oldValue boolean
 * @param newValue boolean
 */
public void firePropertyChange(java.lang.String propertyName, boolean oldValue, boolean newValue) {
	getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
}
/**
 * This widget is being destroyed perform any cleanUp necessary.
 */
public void free() {
	super.free();
	propertyChange = null;
}
/**
 * Return the AreaMenu property value.
 * @return com.ibm.ulc.application.ULCMenu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCMenu getAreaMenu() {
	if (ivjAreaMenu == null) {
		try {
			ivjAreaMenu = new com.ibm.ulc.application.ULCMenu("AreaMenu");
			ivjAreaMenu.setFormAttributeValue("area");
			ivjAreaMenu.setFormAttributeName("nodeType");
			ivjAreaMenu.add(getShowMapMenuItemA());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAreaMenu;
}
/**
 * Return the Box1 property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getBox1() {
	if (ivjBox1 == null) {
		try {
			ivjBox1 = new com.ibm.ulc.application.ULCBox(2, 1);
			ivjBox1.add(0, 0, com.ibm.ulc.base.IDefaults.BOX_EXPAND_EXPAND, getLocationBorder());
			ivjBox1.add(0, 1, getUseMouseRightLabel());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjBox1;
}
/**
 * Return the BrowserContext1 property value.
 * @return com.ibm.ulc.application.ULCBrowserContext
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBrowserContext getBrowserContext1() {
	if (ivjBrowserContext1 == null) {
		try {
			ivjBrowserContext1 = new com.ibm.ulc.application.ULCBrowserContext();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjBrowserContext1;
}
/**
 * Return the CheckBox1 property value.
 * @return com.ibm.ulc.application.ULCCheckbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCCheckbox getCheckBox1() {
	if (ivjCheckBox1 == null) {
		try {
			ivjCheckBox1 = new com.ibm.ulc.application.ULCCheckbox();
			ivjCheckBox1.setLabel("");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjCheckBox1;
}
/**
 * Return the Column1 property value.
 * @return com.ibm.ulc.application.ULCColumn
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCColumn getColumn1() {
	if (ivjColumn1 == null) {
		try {
			ivjColumn1 = new com.ibm.ulc.application.ULCColumn("isOpen", "Open now");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjColumn1;
}
/**
 * Return the LocationBorder property value.
 * @return com.ibm.ulc.application.ULCBorder
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBorder getLocationBorder() {
	if (ivjLocationBorder == null) {
		try {
			ivjLocationBorder = new com.ibm.ulc.application.ULCBorder("Location");
			ivjLocationBorder.add(getLocationTreeTable());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjLocationBorder;
}
/**
 * Return the LocationDetailsMenuItem property value.
 * @return com.ibm.ulc.application.ULCMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCMenuItem getLocationDetailsMenuItem() {
	if (ivjLocationDetailsMenuItem == null) {
		try {
			ivjLocationDetailsMenuItem = new com.ibm.ulc.application.ULCMenuItem("Location ~details");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjLocationDetailsMenuItem;
}
/**
 * Return the LocationMenu property value.
 * @return com.ibm.ulc.application.ULCMenu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCMenu getLocationMenu() {
	if (ivjLocationMenu == null) {
		try {
			ivjLocationMenu = new com.ibm.ulc.application.ULCMenu("LocationMenu");
			ivjLocationMenu.setFormAttributeValue("location");
			ivjLocationMenu.setFormAttributeName("nodeType");
			ivjLocationMenu.add(getShowMapMenuItemL());
			ivjLocationMenu.add(getLocationDetailsMenuItem());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjLocationMenu;
}
/**
 * Return the LocationTreeModel property value.
 * @return com.ibm.ulc.examples.carRental.views.LocationTreeModel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCTreeTableModel getLocationTreeModel() {
	// user code begin {1}
	// user code end
	return ivjLocationTreeModel;
}
/**
 * Method generated to support the promotion of the locationTreeModelThis attribute.
 * @return com.ibm.ulc.application.ULCTreeTableModel
 */
public com.ibm.ulc.application.ULCTreeTableModel getLocationTreeModelThis() {
	return getLocationTreeModel();
}
/**
 * Return the LocationTreeTable property value.
 * @return com.ibm.ulc.application.ULCTreeTable
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCTreeTable getLocationTreeTable() {
	if (ivjLocationTreeTable == null) {
		try {
			ivjLocationTreeTable = new com.ibm.ulc.application.ULCTreeTable();
			ivjLocationTreeTable.setRootVisible(false);
			ivjLocationTreeTable.addColumn(getColumn1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjLocationTreeTable;
}
/**
 * Accessor for the propertyChange field.
 * @return java.beans.PropertyChangeSupport
 */
protected java.beans.PropertyChangeSupport getPropertyChange() {
	if (propertyChange == null) {
		propertyChange = new java.beans.PropertyChangeSupport(this);
	};
	return propertyChange;
}
/**
 * Answer the selected location or null, if no location is selected.
 *
 * Creation date: (07.01.00 14:37:32)
 * @return com.ibm.ulc.examples.carRental.model.Location
 */
public Location getSelectedLocation() {
	WrapperNode selNode= (WrapperNode) getLocationTreeTable().getSelectedItem();
	if (selNode!=null && selNode.isLocationNode()) {
		return (Location) selNode.getModel();
	} else {
		return null;
	}
}
/**
 * Return the ShowMapMenuItemA property value.
 * @return com.ibm.ulc.application.ULCMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCMenuItem getShowMapMenuItemA() {
	if (ivjShowMapMenuItemA == null) {
		try {
			ivjShowMapMenuItemA = new com.ibm.ulc.application.ULCMenuItem("Show ~map");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjShowMapMenuItemA;
}
/**
 * Return the ShowMapMenuItemL property value.
 * @return com.ibm.ulc.application.ULCMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCMenuItem getShowMapMenuItemL() {
	if (ivjShowMapMenuItemL == null) {
		try {
			ivjShowMapMenuItemL = new com.ibm.ulc.application.ULCMenuItem("Show ~map");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjShowMapMenuItemL;
}
/**
 * Return the TreeMenu property value.
 * @return com.ibm.ulc.application.ULCMenu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCMenu getTreeMenu() {
	if (ivjTreeMenu == null) {
		try {
			ivjTreeMenu = new com.ibm.ulc.application.ULCMenu(new java.lang.String());
			ivjTreeMenu.setFormAttributeName("");
			ivjTreeMenu.add(getAreaMenu());
			ivjTreeMenu.add(getLocationMenu());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjTreeMenu;
}
/**
 * Return the TreeRowModel property value.
 * @return com.ibm.ulc.application.ULCTreeRowModel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCTreeRowModel getTreeRowModel() {
	if (ivjTreeRowModel == null) {
		try {
			ivjTreeRowModel = new com.ibm.ulc.application.ULCTreeRowModel();
			ivjTreeRowModel.setUploadAllAttributes(true);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjTreeRowModel;
}
/**
 * Return the UseMouseRightLabel property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getUseMouseRightLabel() {
	if (ivjUseMouseRightLabel == null) {
		try {
			ivjUseMouseRightLabel = new com.ibm.ulc.application.ULCLabel("(Use the right mouse button to get more details on the selected location)");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjUseMouseRightLabel;
}
/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(java.lang.Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	exception.printStackTrace(System.out);
}
/**
 * The hasListeners method was generated to support the propertyChange field.
 * @return boolean
 * @param propertyName java.lang.String
 */
public synchronized boolean hasListeners(java.lang.String propertyName) {
	return getPropertyChange().hasListeners(propertyName);
}
/**
 * Initializes connections
 * @exception java.lang.Exception The exception description.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() throws java.lang.Exception {
	// user code begin {1}
	// user code end
	getShowMapMenuItemA().addActionListener(ivjEventHandler);
	getShowMapMenuItemL().addActionListener(ivjEventHandler);
	getLocationDetailsMenuItem().addActionListener(ivjEventHandler);
	connPtoP1SetTarget();
	connPtoP4SetTarget();
	connPtoP3SetTarget();
	connPtoP2SetTarget();
	connPtoP5SetTarget();
	connPtoP6SetTarget();
	connPtoP7SetTarget();
}
/**
 * Initialize the class.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	try {
		// user code begin {1}
		// user code end
		// user code begin {2}
		// user code end
		setComponent(getBox1());
		getCheckBox1();
		getBrowserContext1();
		getLocationTreeModel();
		getTreeRowModel();
		getTreeMenu();
		initConnections();
		// user code begin {3}
		// user code end
		connEtoM1();
		connEtoM2();
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
	// user code begin {4}
	// user code end
}
/**
 * Comment
 */
public void locationDetailsMenuItem_ActionPerformed(com.ibm.ulc.application.ULCActionEvent event, Object selectedNode) {
	openLocationDetails((AbstractLocationNode) selectedNode);
}
/**
 * Please do not use or rely on this method. It is used by the VAJava test process.
 * It is public only so that the ULCVajContext class can access the method.
 * It can change at any time, or it could be entirely removed in any update 
 * to the VAJava builder. Thank you.
 * @return com.ibm.ulc.application.ULCComponent
 * @param context com.ibm.ulc.application.ULCVajContext
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public static com.ibm.ulc.application.ULCComponent mainTestConstruction(com.ibm.ulc.application.ULCVajContext context) {
	return new LocationSelectionForm(context);
}
/**
 * Open a view on the selected location.
 * Creation date: (10.01.00 23:34:14)
 * @param selectedNode com.ibm.ulc.examples.carRental.views.AbstractLocationNode
 */
protected void openLocationDetails(AbstractLocationNode selectedNode) {
	if (selectedNode.isLocationNode()) {
		Location location= ((LocationNode)selectedNode).getLocation();
		LocationDetailsView detView= new LocationDetailsView(
				"Details about "+selectedNode.getLabel(),
				fShell,
				true, 	//modal
				false); //not yet visible
		detView.setLocation(location);
		detView.show();
	}
}
/**
 * Make the getter available to the package.
 * @return com.ibm.ulc.application.ULCTreeTable
 */
ULCTreeTable pGetLocationTreeTable() {
	return getLocationTreeTable();
}
/**
 * The removePropertyChangeListener method was generated to support the propertyChange field.
 * @param listener java.beans.PropertyChangeListener
 */
public synchronized void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().removePropertyChangeListener(listener);
}
/**
 * The removePropertyChangeListener method was generated to support the propertyChange field.
 * @param propertyName java.lang.String
 * @param listener java.beans.PropertyChangeListener
 */
public synchronized void removePropertyChangeListener(java.lang.String propertyName, java.beans.PropertyChangeListener listener) {
	getPropertyChange().removePropertyChangeListener(propertyName, listener);
}
/**
 * Set the LocationTreeModel to a new value.
 * @param newValue com.ibm.ulc.examples.carRental.views.LocationTreeModel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void setLocationTreeModel(com.ibm.ulc.application.ULCTreeTableModel newValue) {
	if (ivjLocationTreeModel != newValue) {
		try {
			com.ibm.ulc.application.ULCTreeTableModel oldValue = getLocationTreeModel();
			ivjLocationTreeModel = newValue;
			connPtoP3SetTarget();
			connPtoP2SetTarget();
			firePropertyChange("locationTreeModelThis", oldValue, newValue);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	// user code begin {3}
	// user code end
}
/**
 * Method generated to support the promotion of the locationTreeModelThis attribute.
 * @param arg1 com.ibm.ulc.application.ULCTreeTableModel
 */
public void setLocationTreeModelThis(com.ibm.ulc.application.ULCTreeTableModel arg1) {
	setLocationTreeModel(arg1);
}
/**
 * Set the selected location.
 *
 * Creation date: (11.01.00 09:35:46)
 * @param location com.ibm.ulc.examples.carRental.model.Location
 */
public void setSelectedLocation(Location location) {
	WrapperNode locationN= null;
	
	if (location!=null) {
		RootNode rootN= (RootNode) getLocationTreeModel().getRoot();
		WrapperNode countryN= rootN.getChildWithId(location.getCountry().getId());
		WrapperNode stateN= countryN.getChildWithId(location.getState());
		locationN= stateN.getChildWithId(location.getId());
	}
	getLocationTreeTable().setSelectedItem(locationN);
}
/**
 * Show a map for the @selectedNode in the browser.
 * Creation date: (10.01.00 23:20:10)
 * @param selectedNode com.ibm.ulc.examples.carRental.views.AbstractLocationNode
 */
protected void showMapFor(AbstractLocationNode selectedNode) {
	if (selectedNode != null) {
		getBrowserContext1().setContext(this.getContext());
		getBrowserContext1().showDocument(selectedNode.getMapUrl());
	}
}
/**
 * Comment
 */
public void showMapMenuItemA_ActionPerformed(com.ibm.ulc.application.ULCActionEvent event, Object selectedNode) {
	showMapFor((AbstractLocationNode) selectedNode);
}
/**
 * Comment
 */
public void showMapMenuItemL_ActionPerformed(com.ibm.ulc.application.ULCActionEvent event, Object selectedNode) {
	showMapFor((AbstractLocationNode)selectedNode);
}
}
