package com.ibm.ulc.examples.carRental.views;

import com.ibm.ulc.util.ITableRow;
import com.ibm.ulc.examples.carRental.model.DataAccessor;

/**
 * Abstract superclass for adapters used to show countries, 
 * states, locations etc. in a tree widget.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */

public abstract class AbstractLocationNode {
	protected AbstractLocationNode fParent= null;
	protected WrapperNode[] fChildren= null;

	/**
	 * The type of an abstract node.
	 * @serial
	 */
	 public static final String AREA_T= "area";

	 /**
	 * The type of a location node.
	 * @serial
	 */
	 public static final String LOCATION_T= "location";
/**
 * AbstractLocationNode constructor comment.
 */
public AbstractLocationNode() {
	super();
}
/**
 * Find out what the receiver's children are.
 * 
 * Creation date: (30.12.99 11:42:47)
 * @return com.ibm.ulc.examples.carRental.views.WrapperNode[]
 */
abstract protected WrapperNode[] computeChildren();
/**
 * Convenience: answer a reference to the data accessor.
 * 
 * Creation date: (30.12.99 11:59:36)
 * @return com.ibm.ulc.examples.carRental.model.DataAccessor
 */
protected DataAccessor dataAccessor() {
	return DataAccessor.instance();
}
/**
 * Gets the children property (com.ibm.ulc.examples.carRental.views.AbstractLocationNode[]) value.
 * @return The children property value.
 * @see #setChildren
 */
public WrapperNode[] getChildren() {
	if (fChildren==null) fChildren= computeChildren();
	return fChildren;
}
/**
 * Answer the child with the code given in the parameter.
 *
 * @return WrapperNode
 */
public WrapperNode getChildWithId(String theCode) {
	
	WrapperNode[] children= getChildren();
	for (int i=0; i<children.length; i++) {
		String cd= children[i].getId();
		if (cd.equals(theCode)) 
			return children[i];
	}
	return null;
}
/**
 * Perform the getLabel method.
 * @return java.lang.String
 */
public String getLabel() {
	/* Perform the getLabel method. */
	return "";
}
/**
 * Perform the getMapUrl method.
 * @return java.lang.String
 */
public String getMapUrl() {
	/* Perform the getMapUrl method. */
	return "";
}
/**
 * Answer the type of the node.
 *
 * @return java.lang.String
 */
public String getNodeType() {
	/* Perform the getNodeType method. */
	return AREA_T;
}
/**
 * Gets the parent property (com.ibm.ulc.examples.carRental.views.AbstractLocationNode) value.
 * @return The parent property value.
 * @see #setParent
 */
public AbstractLocationNode getParent() {
	return fParent;
}
/**
 * Answer whether the receiver is a location node or not.
 *
 * @return boolean
 */
public boolean isLocationNode() {
	/* Perform the isLocationNode method. */
	return false;
}
/**
 * Answer true, if the receiver is a location
 * that is open right now.
 *
 * @return boolean
 */
public boolean isOpen() {
	/* Perform the isOpen method. */
	return false;
}
/**
 * Sets the children property (com.ibm.ulc.examples.carRental.views.AbstractLocationNode[]) value.
 * @param children The new value for the property.
 * @see #getChildren
 */
public void setChildren(WrapperNode[] children) {
	fChildren = children;
}
/**
 * Sets the parent property (com.ibm.ulc.examples.carRental.views.AbstractLocationNode) value.
 * @param parent The new value for the property.
 * @see #getParent
 */
public void setParent(AbstractLocationNode parent) {
	fParent = parent;
}
}
