package com.ibm.ulc.examples.ManagementStructure;

import com.ibm.ulc.application.*;

/**
 * This class handles the various window events coming from the
 * UI side. The IWindowListener interface allows us to implement
 * the various responses without needing to have case-statements
 * for checking the event type.
 *
 * Note: It is also possible to implement just the events necessary
 * for the receiver without implementing all the stubs - this can be
 * done by inheriting from the DefaultWindowListener class.
 *
 * @see DefaultWindowListener
 */
public class WindowAction extends ManagementStructureAction implements IWindowListener{
public WindowAction(ManagementStructureEditor editor) {
	super(editor);
}
/**
 * Notification of a Window brought to top in the UI.
 * This event  will be received only if a listener has 
 * been registered for this event.
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowActivatedListener
 */
public void windowActivated(ULCWindowEvent windowEvent) {
}
public void windowClosed(ULCWindowEvent windowEvent) {
}
public void windowClosing(ULCWindowEvent a) {
	fEditor.quit();	 
}
/**
 * Notification of a Window loosing focus in the UI.
 * This event  will be received only if a listener has 
 * been registered for this event.
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowDeactivatedListener
 */
public void windowDeactivated(ULCWindowEvent windowEvent) {
}
public void windowHidden(ULCWindowEvent windowEvent) {
}
public void windowMoved(ULCWindowEvent windowEvent) {
}
public void windowResized(ULCWindowEvent windowEvent) {
}
public void windowShown(ULCWindowEvent windowEvent) {
}
}
