package com.ibm.ulc.examples.CustomerInformation;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.application.*;

/**
 * This class is used for acting on the callbacks that
 * occur, when a new account is going to be added to the list of
 * accounts in the accountsTable (in the Notebook).
 * In such a case, this receiver handles the setting of the pagebook,
 * such that the appropriate buttons are available to the user.
 */
class NewAccountToBeAddedAction extends CustomerInformationAction implements IActionListener {
public NewAccountToBeAddedAction(CustomerInformationEditor editor) {
	super(editor);
}
/**
 * Since a new account is now going to be added, clear up
 * the account details fields for that input. Also, have the
 * corresponding page (showing the 'Add' button) set up.
 */
public void actionPerformed(ULCActionEvent e) {
	fEditor.performNewAccountPreprocessing();
}
}
