package com.ibm.ulc.examples.CustomerInformation;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.util.*;
import com.ibm.ulc.application.*;

/**
 * This is the 'main' class in this application, note that it 
 * subclasses ULCContext for this purpose.
 * @see CustomerInformation#main
 * @see CustomerInformation#start
 */
public class CustomerInformation extends ULCContext{
	protected Customer fCustomer;						// The business object
	private ULCApplication fApp;						// The main ULC application instance
	protected CustomerInformationEditor fEditor;	// A separate class to handle the 
															// 		building, editing & user-interactions
	protected static Vector fTestCustomers; 		// A random collection of test-customers.
/**
 * Construct a new instance with a test customer.
 */
public CustomerInformation() {
	setTestCustomer(); // The initial customer whose info will be shown
	init(); // initialize the builder and the editor
}
/**
 * Construct a new instance with the specified customer.
 *
 * @param customer The specified <code>Customer</code> that this instance will be created on.
 */
public CustomerInformation(Customer customer) {
	setCustomer(customer);
	init(); // initialize the builder and the editor
}
/**
 * Add the given shell to the receiver application.
 * Note that each new shell (or a 'sub-shell' created
 * from this shell) is added to the application using
 * this method.
 */
public void addShell(ULCShell shell) {
	fApp.add(shell);
}
public Vector getAccounts() {
	return fCustomer.getAccounts();
}
public Address getAddress() {
	return fCustomer.getAddress();
}
public ULCApplication getApplication() {
	return fApp;
}
public Customer getCustomer() {
	return fCustomer;
}
public String getFirstName() {
	return fCustomer.getFirstName();
}
public String getLastName() {
	return fCustomer.getLastName();
}
/**
 * Returns the Resource Bundle base file name
 *
 * @return <code>String</code>
 */
public String getResourceBundleBaseFileName() {
	return "custinfostrings";
}
public void init() {
	fApp= new ULCApplication(this);
	fEditor= new CustomerInformationEditor(this);
}
/**
 * The ULC.run(args, class) is the useful hook which helps to establish
 * connection to the UIEngine for this application.
 *
 * So every new application could have itself passed 
 * in this way; the ULC.run would then hook back into
 * the start() method, where the actual widget-building
 * can happen.
 *
 * @see			#start()
 */

public static void main (String args[]) {
	ULC.run(args, CustomerInformation.class);
}
public void setCustomer(Customer customer) {
	fCustomer= customer;
}
/**
 * The user has selected a new customer from the UI.
 */
public void setCustomerSelection (Customer customer) {
	setCustomer(customer);
}
public void setTestCustomer() {
	fTestCustomers= Customer.createTestCustomers();
	setCustomer((Customer) fTestCustomers.firstElement());
}
/**
 * The ULC.start() call in main() leads to this point, where
 * one can start with the actual application building.
 * For doing this, pass the receiver application, which will be
 * used by the editor for it's building.
 */
public void start() {
	fEditor.edit(fApp);
}
public void terminateCustInfo() {
	fApp.terminate();
}
}
