package com.ibm.ulc.examples.Browser;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.util.*;
import com.ibm.ulc.application.*;

class SimpleModel extends ULCTableModel {
	private String fBase;
	private int fSize;
public SimpleModel(int size) {
	fSize = size;
	fBase = null;
	notify(TABLE_MODEL_CONTENTS_CHANGED, null, -1, -1);
}
	public void clear() {
		fSize= 0;
		notify(TABLE_MODEL_ROWS_CHANGED, null, 0, fSize-1);
	}
	public String get(int x) {
		return (String) getValueAt(null, x);
	}
public Object getRowAt(int x) {
	if (fSize <= 0)
		return "";
	if (fBase == null)
		return "" + x;
	return fBase + "." + x;
}
	public int getRowCount() {
		return fSize;
	}
	public Object getValueAt(String colId, int x) {
		if (fSize <= 0)
			return "";
		if (fBase == null)
			return "" + x;
		return fBase + "." + x;
	}
	public void set(String b) {
		fBase= b;
		fSize= (int) (Math.random() * 20)+1;
		notify(TABLE_MODEL_CONTENTS_CHANGED, null, 0, fSize-1);
	}
}
