package com.ibm.ulc.comm;

/**
 * Representation of exceptional conditions in a UlcTransport
 *
 * @see UlcTransport
 */
 
import com.ibm.ulc.base.IDefaults;

public class UlcTransportException extends Exception {

	private Exception fCaughtException= null;
	private Error fCaughtError= null;
	private int fReason= IDefaults.TRANSPORT_EX_UNKNOWN_REASON;

public UlcTransportException() {
	super();
}
public UlcTransportException(int reason, Error caughtError) {
	super("UlcTransportException. Reason=" + reason + ", Error=" + caughtError.getMessage());
	fReason = reason;
	fCaughtError = caughtError;
}
public UlcTransportException(int reason, Exception caughtException) {
	super("UlcTransportException. Reason=" + reason + ", Exception=" + caughtException.getMessage());
	fReason = reason;
	fCaughtException = caughtException;
}
public UlcTransportException(String msg, int reason, Error caughtError) {
	super(msg);
	fReason = reason;
	fCaughtError = caughtError;
}
public UlcTransportException(String msg, int reason, Exception caughtException) {
	super(msg);
	fReason = reason;
	fCaughtException = caughtException;
}
public Error getCaughtError() {
	return fCaughtError;
}
public Exception getCaughtException() {
	return fCaughtException;
}
public int getReason() {
	return fReason;
}
public String toString() {
	String s= getMessage();
	s += " (Reason=";
	switch (fReason) {
	case IDefaults.TRANSPORT_EX_UNKNOWN_REASON:
		s += "TRANSPORT_EX_UNKNOWN_REASON)";
		break;
	case IDefaults.TRANSPORT_EX_INIT_CONNECTION_EXCEPTION:
		s += "TRANSPORT_EX_INIT_CONNECTION_EXCEPTION)";
		break;
	case IDefaults.TRANSPORT_EX_INIT_CONNECTION_ERROR:
		s += "TRANSPORT_EX_INIT_CONNECTION_ERROR)";
		break;
	case IDefaults.TRANSPORT_EX_CONNECTION_INTERRUPTED:
		s += "TRANSPORT_EX_CONNECTION_INTERRUPTED)";
		break;
	}
	if (fCaughtException != null)
		s += " (CaughtException=" + fCaughtException + ")";
	return s;
}
}
