package com.ibm.ulc.comm;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.util.*;
import com.ibm.ulc.util.*;
import java.io.*;

/**
 * A RequestProcessor implementation based on a thread pool with worker threads.
 */
public class ThreadPool implements Serializable, Runnable, IRequestProcessor {
	protected UnboundedBuffer fRequests = null;
	protected Vector fThreads = new Vector();
	protected boolean fShutdown = false;
	/**
	 * Constructs a thread pool with the given number of worker threads.
	 * If the number of threads equals 0 the request are processed
	 * in the same thread as the caller.
	 */
	public ThreadPool(int threads, boolean asDaemons) {
	    if (threads > 0) {
//	    	fThreadGroup= new ThreadGroup("ThreadPool");
			fRequests= new UnboundedBuffer();

			for (int i= 0; i < threads; i++) {
//			    Thread t= new DebugThread(fThreadGroup, this, "ThreadPool Worker " + i);
			    Thread t= new DebugThread(this, "ThreadPool Worker " + i);
			    fThreads.addElement(t);
			    t.setDaemon(asDaemons);
			    t.start();
			}
		}
	}
	/**
	 * Adds a request. If there are any worker threads it is passed
	 * to a worker. Otherwise it is executed directly.
	 */
	public void addRequest(Request request) {
		if (fRequests != null) {
			fRequests.put(request);
		} else {
			request.dispatch();
	    }
	}
/**
 * Picks up a request and process it by calling doit.
 * returns false when the request has been dispatched and true when there is  
 * no request to dispatch. 
 * @see Request
 */
public boolean processNextRequest(long timeout) {
	Request r = (Request) fRequests.take(timeout);
	if (r != null) {
		r.dispatch();
		return false;
	}
	return true;
}
	/**
	 * Processes incoming requests.
	 */
	public void run() {
		while (!fShutdown)
			processNextRequest(0);	// wait undefinitely
	}
/**
 *	Shutdown the thread pool
 */
public void shutdown() {
	fShutdown= true;
	/*
	 * The following code is not needed since each thread will finish
	 * on its own as soon as fShutdown is true
	 * Furthermore stop() is never called in the current implementation
	 * because we only create one thread an therefore the current thread
	 * equals to this single thread.
	 *
	 * for (Enumeration e = fThreads.elements(); e.hasMoreElements();) {
	 * 	Thread t = (Thread) e.nextElement();
	 * 	if (Thread.currentThread() != t)
	 * 		t.stop();
	 * }
	 */
	fThreads.removeAllElements();
	fThreads= new Vector();
	fRequests= null;
}
}
