package com.ibm.ulc.application;

/**
 * cache information about a given node in a specific tree view. This is an internal class for use in
 * hierarchical ItemLists
 */
import java.util.Vector;
import com.ibm.ulc.util.UlcHashtable;
public class UlcCachedNode {
	private boolean fUploaded = false;
	private int fOid = -1;
	private int fParentOid = -1;
	private Vector fChildOids = new Vector();
/**
 * Comment
 * @param oid int
 */
public UlcCachedNode(int oid) {
	setOid(oid);
}
/**
 * a the specified childoid to the receiver's currently known childOids
 * @param newOid int
 */
protected void collectChildren(UlcHashtable oids, UlcHashtable hashtable, boolean includeThis) {
	if (includeThis)
		oids.put(new Integer(getOid()), null);
	int[] childOids = getChildOids();
	for (int i = 0; i < childOids.length; i++) {
		Object found = hashtable.get(new Integer(childOids[i]));
		if (found != null) {
			((UlcCachedNode) found).collectChildren(oids, hashtable, true);
		}
	}
}
/**
 * Comment
 * @return java.util.Vector
 */
protected int[] getChildOids() {
	int[] answer = new int[fChildOids.size()];
	for (int i = 0; i < fChildOids.size(); i++) {
		answer[i] = ((Integer) fChildOids.elementAt(i)).intValue();
	}
	return answer;
}
/**
 * Comment
 * @return int
 */
protected int getOid() {
	return fOid;
}
/**
 * Comment
 * @return java.util.Vector
 */
protected java.util.Vector getOids() {
	return fChildOids;
}
/**
 * Comment
 * @return int
 */
protected int getParentOid() {
	return fParentOid;
}
/**
 * answer true if the receiver has the correct number of childOids
 * @return boolean
 */
protected boolean hasAllChildOids(int expectedNumber) {
	return fChildOids.size() == expectedNumber;
}
/**
 * Insert them as possible, will be sorted later
 */
protected void insertOid(int oid, int index) {
	Integer newOid = new Integer(oid);
	if (!fChildOids.contains(newOid)) {
		if (index <= fChildOids.size())
			fChildOids.insertElementAt(newOid, index);
		else
			fChildOids.addElement(newOid);
	}
}
/**
 * Comment
 * @return boolean
 */
protected boolean isUploaded() {
	return fUploaded;
}
/**
 * remove the receiver's children from @hashtable. Having removed all child references, the
 * receiver is no longer considered uploaded.
 * Note: the removal of the children only concerns ULC internal caching, and does NOT change
 * the underlying application objects.
 *
 * @param newOid int
 */
void removeChildren(UlcHashtable hashtable) {
	int[] childOids = getChildOids();
	for (int i = 0; i < childOids.length; i++) {
		Object found = hashtable.get(new Integer(childOids[i]));
		if (found != null) {
			((UlcCachedNode) found).removeWithChildren(hashtable);
		}
	}
	fChildOids = new Vector();
}
/**
 * a the specified childoid to the receiver's currently known childOids
 * @param newOid int
 */
protected void removeFrom(UlcHashtable hashtable) {
	removeFromParent(hashtable);
	removeWithChildren(hashtable);
}
/**
 * a the specified childoid to the receiver's currently known childOids
 * @param newOid int
 */
protected void removeFromParent(UlcHashtable hashtable) {
	if (getParentOid() != -1) {
		Object found = hashtable.get(new Integer(getParentOid()));
		if (found != null) {
			((UlcCachedNode) found).removeOid(getOid());
		}
		setParentOid(-1);
	}
}
/**
 * a the specified childoid to the receiver's currently known childOids
 * @param newOid int
 */
protected void removeOid(int oid) {
	Integer newOid = new Integer(oid);
	fChildOids.removeElement(newOid);
}
/**
 * remove the receiver with all its children from @hashtable
 * @param newOid int
 */
void removeWithChildren(UlcHashtable hashtable) {
	if (hashtable.containsKey(new Integer(getOid())))
		hashtable.remove(new Integer(getOid()));
	removeChildren(hashtable);
	fUploaded = false;
}
/**
 * Comment
 * @param newChildOids java.util.Vector
 */
protected void setChildOids(int[] newChildOids) {
	fChildOids = new Vector(newChildOids.length);
	for (int i = 0; i < newChildOids.length; i++) {
		fChildOids.addElement(new Integer(newChildOids[i]));
	}
}
/**
 * Comment
 * @param newChildOids java.util.Vector
 */
protected void setChildOids(java.util.Vector newChildOids) {
	fChildOids = newChildOids;
}
/**
 * Comment
 * @param newOid int
 */
protected void setOid(int newOid) {
	fOid = newOid;
}
/**
 * Comment
 * @param newParentOid int
 */
protected void setParentOid(int newParentOid) {
	fParentOid = newParentOid;
}
/**
 * Comment
 * @param newUploaded boolean
 */
protected void setUploaded(boolean newUploaded) {
	fUploaded = newUploaded;
}
}
