package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import java.util.Vector;

/**
 * Implementation of a FormModel which forwards its getValueAt and setValueAt requests
 * to a specific row of a tree model.
 * If the tree property is specified then this row model will automatically track 
 * selection changes in the tree widget that it is connected to.
 * If the tree property is not specified then an explicit call to <code>setRow</code> 
 * is needed to specify over which row within the tree model that this row model is acting upon.
 */
public class ULCTreeRowModel extends ULCAbstractRowModel implements IForm {
/**
 *  Constructs a ULCTreeRowModel
 */
public ULCTreeRowModel() {
	super();
}
/**
 * Constructs a ULCTreeRowModel based on the specified TableModel.
 *
 * @param table The <code>ULCAbstractTableModel</code> whose values I track.
 */
public ULCTreeRowModel(ULCAbstractTableModel tableModel) {
	super(tableModel);
}
/**
 * Constructs a ULCTreeRowModel based on the specified TableModel and Tree.
 *
 * @param model 	The <code>ULCAbstractTableModel</code> whose values the receiver is using.
 * @param widget 	The <code>ULCAbstractTree</code> whose current selection the receiver is tracking.
 */
public ULCTreeRowModel(ULCAbstractTableModel model, ULCAbstractTree widget) {
	super(model, widget);
}
/**
 * Return the row index on which the receiver is functioning as FormModel.
 * Note: The table model must be set before this method can be called.
 *
 * @param row	The internal identifier of the row within the <code>ULCTableModel</code> whose values
 *				I now represent.
 *
 * @deprecated wtih R3.0, use getCurrentOid instead.
 */
public int getRow() {
	return getCurrentOid();
}
/**
 * Update the UI with the new row information.
 *
 * @parm rowid		the oid of the row the receiver is currently using.
 */
protected void sendCurrentOid(int rowId) {
	sendUI("setRow", new Anything(rowId));
}
/**
 * Specify the row on which the receiver is functioning as FormModel.
 * Note: The tree model must be set before this method can be called.
 *
 * @param rowid	The oid of the receiver's row as defined by the <code>ULCAbstractTableModel</code>
 *
 * @deprecated with R3.0, use setCurrentOid instead
 */
public void setRow(int rowid) {
	setCurrentOid(rowid);
}
/**
 * Set the <code>ULCTree</code> whose current selection the receiver is tracking.
 *
 */
public void setTree(ULCAbstractTree tree) {
	setList(tree);
}
/**
 * Sets the <code>ULCTreeModel</code> that will serve as my data source.
 *
 * @param	The <code>ULCTreeModel</code>
 *
 * @deprecated with R3.0
 */
public void setTreeModel(ULCTreeModel treeModel) {
	setTableModel(treeModel);
}
}
