package com.ibm.ulc.application;


/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.ORBConnection;
public abstract class ULCToggleMenuItem extends ULCMenuItem implements IEnabler {
	/**
	 *	The current selection state.
	 * @serial	 	 
	 */
	protected boolean fSelected = false;
	protected ULCButtonGroup fGroup = null;
/**
 * ULCToggleMenuItem constructor comment.
 * @param label java.lang.String
 */
public ULCToggleMenuItem(String label) {
	super(label);
}
/**
 * ULCToggleMenuItem constructor comment.
 * @param label java.lang.String
 * @param l com.ibm.ulc.application.IActionListener
 */
public ULCToggleMenuItem(String label, IActionListener l) {
	super(label, l);
}
/**
 * ULCToggleMenuItem constructor comment.
 * @param label java.lang.String
 * @param icon com.ibm.ulc.application.ULCIcon
 */
public ULCToggleMenuItem(String label, ULCIcon icon) {
	super(label, icon);
}
/**
 * ULCToggleMenuItem constructor comment.
 * @param label java.lang.String
 * @param icon com.ibm.ulc.application.ULCIcon
 * @param l com.ibm.ulc.application.IActionListener
 */
public ULCToggleMenuItem(String label, ULCIcon icon, IActionListener l) {
	super(label, icon, l);
}
/**
 * Return the Button Group for this Toggle Button.
 *
 * @return ULCButtonGroup 
 */
public ULCButtonGroup getButtonGroup() {
	return fGroup;
}
/**
 * The UI has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("event")) {
		String type = args.get("type", "???");
		if (type.equals("itemStateChange")) {
			fSelected = args.get("selected", fSelected);
			distributeToListeners("action", new ULCActionEvent(this, (fSelected ? "on" : "off")));
			// FIXME: distribute event
		}
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * Returns the selected-state of the item.
 *
 * @return true if the checkbox is currently selected.
 */
public boolean isSelected() {
	return fSelected;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (fGroup != null)
		a.put("group", fGroup.getRef(fContext));
	if (fSelected)
		a.put("selected", fSelected);
}
/**
 * Set the Button Group for this Toggle Button.
 *
 * @param ULCButtonGroup 
 */
public void setButtonGroup(ULCButtonGroup buttonGroup) {
	fGroup = buttonGroup;
}
/**
 * Sets the selected-state of the menu item.
 *
 * @param selected if true the menu item is selected in the UI
 */
public void setSelected(boolean selected) {
	if (!fSelected == selected) {
		fSelected = selected;
		sendUI("setSelected", new Anything(fSelected));
	}
}
}
