package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.Anything;

/**
 * An implementation of a radio button -- an item that can be selected or deselected,
 * and which displays its state to the user.
 * The current value is either determined by the state of this widget or
 * by an attribute of a ULCFormModel.
 * Used with ULCButtonGroup or ULCBox to create a group of buttons in which
 * only one button at a time can be selected.
 */
public class ULCRadioButton extends ULCToggleButton {
	/**
	 * The optional <code>String</code> value which can be used to turn this button on.
	 * when this button is connected to a FormModel.
	 * @serial	 
	 */
	protected String fValue = null;
public ULCRadioButton() {
	super("", false);
}
/**
 * Constructs a checkbox which tracks the state of the specified attribute of the given FormModel.
 *
 * @param formModel 		The model that will acts as the data source
 * @param formAttributeName	The attribute key of the model whose value will be 
 *							interpreted as a boolean or compared to the <code>switchOnValue</code>.
 * @param label		 		The button's label.
 * @param switchOnValue 	The button is switched on if the FormModel's value matches this value.
 */
public ULCRadioButton(IForm formModel, String formAttributeName, String label, String switchOnValue) {
	super(formModel, formAttributeName, label);
	fValue = switchOnValue;
}
/**
 * Constructs a radio button with the given label in the specified ButtonGroup.
 * Note: if a Button is a member of a ButtonGroup you can't reset its state to false!
 * You have to set another Button's state to true.
 *
 * @param 	buttonGroup 	The <code>ULCButtonGroup</code> which this button is part off.
 * @param 	label			The <code>String</code> value for ths button's label.
 */
public ULCRadioButton(ULCButtonGroup buttonGroup, String label) {
	super(label, false);
	fGroup = buttonGroup;
}
/**
 * Constructs a radio button with the given label.
 *
 * @param 	label	The <code>String</code> value for ths button's label.
 */
public ULCRadioButton(String label) {
	super(label, false);
}
/**
 * Construct a radiobutton with the given label and the specified initial state.
 * On state changes the given listener is notified.
 *
 * @param 	label		The <code>String</code> value for ths button's label.
 * @param 	listener	The <code>IValueChangedListener</code> object interested in my value changed events.
 * @param 	state		The initial selection state.
 */
public ULCRadioButton(String label, IValueChangedListener listener, boolean state) {
	super(label, listener, state);
}
/**
 * Construct a radiobutton with the given label and the specified initial state.
 *
 * @param 	label	The <code>String</code> value for ths button's label.
 * @param 	state	The initial selection state.
 */
public ULCRadioButton(String label, boolean state) {
	super(label, state);
}
/**
 * Return the optional value that if specified will cause this RadioButton 
 * to be selected in the UI whenever the formModel value matches this value.
 *
 * @return String
 */
public String getValue() {
	return fValue;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (fValue != null)
		a.put("value", fValue);
}
/**
 * Set the optional value that if specified will cause this RadioButton 
 * to be selected in the UI whenever the formModel value matches this value.
 *
 * @param String
 */
public void setValue(String value) {
	fValue = value;
}
}
