package com.ibm.ulc.application;

/**
 * Implement an enabler that takes multiple source components and enables its target only 
 * if all its source components are enabled.
 */
public class ULCAndEnabler extends ULCEnabler {
public ULCAndEnabler() {
	super();
}
/**
 * Add a ULCComponent to the list of components that must be enabled 
 * before my target component is enabled.
 *
 * @param c The component to be added.
 */
public void add(IEnabler c) {
	internalAdd(c);
}
/**
 * Remove a ULCComponent to the list of components that must be enabled before my 
 * target component is enabled.
 *
 * @param c The component to be added.
 */
public void remove(IEnabler c) {
	internalRemove(c);
}
/**
 * Convenience method for the Visual Composition editor to ensure it shows up as a property
 */
public void setAnd(IEnabler c) {
	add(c);
}
}
