package com.ibm.ulc.application;

/*
 * Copyright (c) 1997-2000 Object Technology International Inc.
 */
 
/**
 * This interface is used to define the interaction in 
 * an <code>ULCProgramStarter</code> when an error occurs.
 * The <code>programStarterError(ULCProgramStarterErrorEvent)</code> must be implemented to
 * react on errors.
 *
 * @see		ULCProgramStarter
 * @since	R3.1
 */
public interface IProgramStarterErrorListener extends IListener {
/**
 * Notification that an error has occured in the UI
 * during exec or start
 *
 * @param	errorEvent ULCProgramStarterErrorEvent
 * @since	R3.1
 */
void programStarterError(ULCProgramStarterErrorEvent errorEvent);
}
