package com.ibm.ulc.AppController;

/*
 * Copyright (c) 1998 Object Technology International Inc.
 */

import java.util.*;
import java.net.*;
import com.ibm.ulc.application.*;
import com.ibm.ulc.comm.UlcConnection;

class Applications extends ULCTableModel {

	int fAppCount = 0;
	Application fApps[] = null;
	

	public Applications() {
		super(false);	// no veto
		sync();
	}
	Application getApp(int index) {
		if (index < 0 || index >= fApps.length)
			return null;
		return fApps[index];
	}
public int getAppIndex(String url) {
	for (int i = 0; i < fApps.length; i++)
		if (fApps[i].fUrlString.equals(url))
			return i;
	return -1;
}
	public int getAppIndex(String host, int port) {
		for (int i = 0; i < fApps.length; i++) {
			if (fApps[i].getPort() == port) {
				if (host.equals(fApps[i].getHost())
					|| host.equals(fApps[i].fRealHost))
					return i;
			}	
		}
		return -1;
	}
	public int getAppIndex(String host, int port, String url) {
		for (int i = 0; i < fApps.length; i++) {
			if (fApps[i].getPort() == port) {
				if (host.equals(fApps[i].getHost())
					|| host.equals(fApps[i].fRealHost))
					return i;
			}	
		}
		return -1;
	}
public Object getRowAt(int index) {
	return fApps[index];
}
	public int getRowCount() {
		return fAppCount;
	}
	public Object getValueAt(String id, int index) {
		if (id.equals("Label")) {
			return fApps[index].fLabel;
		}
		if (id.equals("Icon")) {
			return fApps[index].fIcon;
		}
		if (id.equals("Language")) {
			return fApps[index].fLanguage;
		}
		if (id.equals("Host")) {
			return fApps[index].getHost();
		}
		if (id.equals("Port")) {
			int port = fApps[index].getPort();
			return new Integer(port);
		}
		if (id.equals("AppName")) {
			return fApps[index].getFile();
		}
		if (id.equals("URL")) {
			return fApps[index].fUrlString;
		}
		if (id.equals("ConnectIcon")) {
			AppController controller = (AppController) getContext();
			switch (fApps[index].fConnected) {
			case Application.NOT_CONNECTED:
				return controller.fRed;
			case Application.CONNECTED:
				return controller.fGreen;
			case Application.CONNECTION_IN_PROGRESS:
				return controller.fYellow;
			}	
		}
		if (id.equals("RunIcon")) {
			AppController controller = (AppController) getContext();
			if (fApps[index].fServerRunning)
				return controller.fGreen;
			return controller.fRed;
		}
		if (id.equals("ConnectStatus")) {
			switch (fApps[index].fConnected) {
			case Application.NOT_CONNECTED:
				return "not connected";
			case Application.CONNECTED:
				return "connected";
			case Application.CONNECTION_IN_PROGRESS:
				return "in progress";
			}	
		}
		if (id.equals("RunStatus")) {
			if (fApps[index].fServerRunning)
				return "running";
			return "not active";
		}
		if (id.equals("AbsoluteAppDir")) {
			return fApps[index].fAbsAppDir;
		}
		if (id.equals("JMainClass")) {
			String jexe = fApps[index].fJavaMainClass;
			if (jexe == null)
				return "";
			return jexe;
		}
		if (id.equals("StExec")) {
			String stexe = fApps[index].fSmalltalkExe;
			if (stexe == null)
				return "";
			return stexe;
		}
		if (id.equals("JAppHome")) {
			return fApps[index].fJavaAppHome;
		}
		if (id.equals("StAppHome")) {
			return fApps[index].fSmalltalkAppHome;
		}
		return "*error*";
	}
public boolean setConnected(int index, int value) {
	boolean changed = false;
	if (index < 0 || index >= fAppCount)
		return changed;
	if (fApps[index].fConnected != value) {
		fApps[index].fConnected= value;
		changed= true;
		if (value == Application.NOT_CONNECTED)
			fApps[index].fConnectionId= "*";
		notify(TABLE_MODEL_CELL_CHANGED, "ConnectIcon", index, index);
	}
	return changed;
}
	public boolean setRunning(int index, boolean value) {
		boolean changed = false;
		if (index < 0 || index >= fAppCount)
			return changed;
		if (fApps[index].fServerRunning != value) {
			fApps[index].fServerRunning = value;
			changed = true;
			notify(TABLE_MODEL_CELL_CHANGED,"RunIcon",index,index);
		}
		return changed;
	}
	void sync() {
		// fill the array of known applications and their properties
		Application[] oldApps = fApps;
		int oldAppCount = fAppCount;
		PropertyManager manager = PropertyManager.getManager();
		Application[] newApps = null;
		int newAppCount = 0;
		synchronized(manager) {
			fAppCount = 0;
			fApps = null;
			notify(TABLE_MODEL_ROWS_REMOVED,null,0,oldAppCount-1);
			newAppCount = manager.getAppCount();
			newApps = new Application[newAppCount];
			for (int i = 0; i < newAppCount; i++) {
				newApps[i] = (Application) manager.getApps()[i].clone();
				newApps[i].fProcess = null;
			}	
			if (oldApps != null) {
				// copy old state to new apps
				for (int i = 0; i < newAppCount; i++) {
					for (int j = 0; j < oldAppCount; j++) {
						if (oldApps[j].fLabel.equals(newApps[i].fLabel)) {
							newApps[i].fConnected = oldApps[j].fConnected;
						}
					}
				}
			}
			fAppCount = newAppCount;
			fApps = newApps;
		}
		notify(TABLE_MODEL_ROWS_ADDED,null,0,fAppCount-1);
	}
}
