package com.ibm.abt.web.servlet;

/**
 * This type was created in VisualAge.
 */

import java.io.* ;
import java.lang.* ;
import java.util.* ;
import java.net.* ;
import javax.servlet.* ;
import javax.servlet.http.* ;
public class Router extends javax.servlet.http.HttpServlet 
	implements WsiConstants {

	public static byte[] HeaderBytes ;
	public RouterConfiguration configuration ; 
	private sun.io.CharToByteISO8859_1 stringConverter ;
/**
 * VastRouterServlet constructor comment.
 */
public Router() {
	super();
}
/**
 * Add the passed to debug string to the log file
 */
private void addDebugString ( String debugString) {

	getConfiguration().logMessage(DEBUG + debugString ) ;

}
/**
 * Build a Cookie using the values passed in inStream.
 */
private Cookie buildCookieFromInputStream(InputStream inStream) throws IOException {
	String cookieName = readNextString(inStream);	
	Cookie cookie = null;
	String propValue = null;

	if (cookieName != null)  {
		cookie = new Cookie(cookieName, readNextString(inStream));
		if (cookie != null) {
			propValue = readNextString(inStream);
			if (propValue != null)
				cookie.setComment(propValue);
			propValue = readNextString(inStream);
			if (propValue != null)
				cookie.setDomain(propValue);
			propValue = readNextString(inStream);
			if (propValue != null)
				cookie.setPath(propValue);

			// Now read the int variables
			cookie.setMaxAge(readNextInt(inStream));
			cookie.setVersion(readNextInt(inStream));

			// Boolean 'secure' is saved as an int
			cookie.setSecure(((readNextInt(inStream) == 0) ? false : true));
		}
	}
	return cookie;
}
/**
 * Return a byte array containing the information required
 * by Smalltalk to process this request.
 */
private void buildVastRequestBuffer ( HttpServletRequest request,OutputStream outStream) {

	int propertyCount = 0;
	int stringLength = 0 ;
	String propertyString = null ;
	InputStream inputStream = null ;
	Cookie[] cookies = null ;
	byte[] buf ;	

	// First determine how many of the properties should be
	// passed to the VAST application
	if ( request.getContentType() != null )
		propertyCount++ ;
	if ( request.getQueryString() != null )
		propertyCount++ ;
	if ( request.getMethod() != null )
		propertyCount++ ;
	if ( request.getPathInfo() != null )
		propertyCount++ ;
	if ( request.getAttribute(MSG_STRING_CONTENT_DATA) != null )
		propertyCount++ ;
	cookies = request.getCookies() ;
	if ( cookies != null ) 
		propertyCount++ ;

	try {

	// Write header information to the output stream
	outStream.write(getRequestHeaderBytes()) ;
	writeInteger(propertyCount, outStream ) ;

	// Determine number of bytes in code page string and write
	// to the output stream.  Value may be null
	propertyString = getConfiguration().getCodePage() ;
	writeString (propertyString,outStream) ;

	// Write each of the defined properties.  The writeString
	// method writes the string preceded by a 4-byte length
	if ( request.getContentType() != null ) {
		writeString(MSG_STRING_CONTENT_TYPE,outStream ) ;
		writeString(request.getContentType(),outStream); }
		
	if ( request.getQueryString() != null ) {
		writeString(MSG_STRING_QUERY_STRING,outStream ) ;
		writeString(request.getQueryString(),outStream); }
	
	if ( request.getMethod() != null ) {
		writeString(MSG_STRING_REQUEST_METHOD,outStream ) ;
		writeString(request.getMethod(),outStream); }
	
	if ( request.getPathInfo() != null ) {
		writeString(MSG_STRING_PATH_INFO,outStream ) ;
		writeString(request.getPathInfo(),outStream); }

	propertyString = (String)request.getAttribute(MSG_STRING_CONTENT_DATA) ;
	if (propertyString != null) {
		writeString(MSG_STRING_CONTENT_DATA,outStream ) ;
		writeString ( propertyString,outStream ) ; }

	if (cookies !=null ) {
		writeString(MSG_STRING_WSI_COOKIE_COUNT, outStream ) ;
		writeString(String.valueOf(cookies.length), outStream ) ; 
		saveCookiesToStream (cookies , outStream ) ;}



	// Read the content from the the request and write to 
	// the outStream
	if ( request.getContentLength() > 0 ) 
		buf = getContentFromRequest(request) ;
	else {
	// Content length came back as a negative number (null)
		if (getConfiguration().getDebug())
		addDebugString(DEBUG_CONTENT_LENGTH + new Integer(request.getContentLength()).toString()) ;
		buf = new byte[0] ;} 
	writeBytes(buf,outStream) ; } 
	
	catch ( IOException e) {} 
	
}
/**
 * Return a byte array containing the 'big endian' representation of the
 * passed int.
 */
private static byte[] byteArrayFromInt(int theInt) {

	byte[] byteArray = new byte[4];
	int lo = theInt & 65535 ;
	int hi = theInt >> 16 ;

	putIntoByteArray(byteArray, lo, 2 ) ;
	putIntoByteArray(byteArray, hi, 0 ) ;

	return byteArray ;

}
/**
 * Clear the HeaderBytes static variable
 */
private static void clearBuffer(byte[] byteArray) {

	for ( int i = 0 ; i < byteArray.length ; i++ )
		byteArray[i] = 0 ;
}
/**
 * Copy the entire sourceByteArray into the targetByteArray.
 * starting at targetOffset in the targetByteArray.
 */
private static void copyBytes (byte[] sourceByteArray,
	byte[] targetByteArray, int targetOffset, int numBytesToCopy)

{
	int sourceByteIndex = 0 ;
	for (int i = targetOffset ; i < targetOffset + numBytesToCopy ; i++ )
		{
			if ( sourceByteIndex < sourceByteArray.length ) {
				targetByteArray[i] = sourceByteArray[sourceByteIndex] ; }
		sourceByteIndex++ ;
		}

}
/**
 * Format the string passed into HTML for display in a browser.
 */
public String formatHtmlError(String errorString) {

	String fileName = getConfiguration().getErrorFileName();
	String line ;
	FileReader fileReader = null ;
	String resultString = null;

	try {
		fileReader = new FileReader(fileName);
	} catch (Throwable exception) {}

	if ( fileReader != null ) {
		ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
		PrintWriter printWriter = new PrintWriter(outputStream);
		BufferedReader bufferedReader = new BufferedReader(fileReader) ;
		
		try {
		while(null != (line = bufferedReader.readLine())) {
	// When a line begins with a '#', substitute error text rather than echoing the line
			if (( line.length() > 0 ) && ( line.charAt(0) == MSG_COMMENT_CHAR ))
				printWriter.println(errorString) ;
			else 
				printWriter.println(line) ; } }
		catch ( IOException e ) {}
		
		try {			
			bufferedReader.close() ;	
			printWriter.close();
			resultString = outputStream.toString() ;}
		catch ( IOException e) {} } 

	if ( resultString == null )
		resultString = formatHtmlErrorUsingDefault(errorString) ;
		
	return resultString ;
}
/**
 * Format the string passed into HTML for display in a browser.
 */
private String formatHtmlErrorUsingDefault(String errorString) {

	ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
	PrintWriter printWriter = new PrintWriter(outputStream);

	printWriter.println(errorString) ;
	printWriter.println("<html>") ;
	printWriter.println("<head>") ;
	printWriter.println("<title>Web Server Interface Error</title>");
	printWriter.println("</head>") ;
	printWriter.println("<body>") ;
	printWriter.println("<h1>Web Server Interface Error</h1>") ;
	printWriter.println("<p>Error processing an HTTP server transaction.") ;
	printWriter.println(errorString) ;
	printWriter.println("<h1>") ;
	printWriter.println("</body>") ;
	printWriter.println("</html>") ;

	printWriter.close() ;
	return outputStream.toString() ;}
	
	
	
/**
 * Return the active configuration information read from 
 * abtwsi.cnf 
 */
public RouterConfiguration getConfiguration() {

	return RouterConfiguration.getCurrent() ;
	
	}
/**
 * Return a byte array containing the content of the passed HttpServletRequest
 */
private byte[] getContentFromRequest(HttpServletRequest request) {
	
	InputStream inputStream = null;
	byte[] content = new byte[request.getContentLength()];
	try {
		inputStream = request.getInputStream();
	} catch (Throwable e) {
		getConfiguration().logMessage(ERR_STRING_GETINPUTSTREAM);
		getConfiguration().logMessage(e.toString());
	}
	if (inputStream != null) {
		if (getConfiguration().getDebug())
			addDebugString(DEBUG_READ_INPUTSTREAM);
		try {
			inputStream.read(content, 0, content.length);
			if (getConfiguration().getDebug())
				addDebugString(DEBUG_CLOSE_INPUTSTREAM);
			inputStream.close();
		} catch (Throwable e) {
			getConfiguration().logMessage(ERR_STRING_READINPUTSTREAM);
			getConfiguration().logMessage(e.toString());
		}
		try {
			if (inputStream != null)
				inputStream.close();			
		} catch (Throwable ee) {}
	};
	if (getConfiguration().getDebug()) {
		addDebugString(DEBUG_CONTENTS);
		addDebugString(new String(content));}

return content;
}
/**
 * Return a byte array that contains the bytes of the header for
 * the output socket stream.
 */
private static byte[] getRequestHeaderBytes() {

	
	if (HeaderBytes == null ) {
		int fieldNum = 0;
		byte[] byteArray = new byte[20] ;

	// Set the magic cookie bytes
	for (int i = 0 ; i < WSI_MAGIC_COOKIE.length ; i++ ) {
		byteArray[i] = (byte)Integer.parseInt(WSI_MAGIC_COOKIE[i],16); }
	fieldNum++ ;

	// Set the major version
	copyBytes( byteArrayFromInt(WSI_MAJOR_VERSION), 
		byteArray, 
		(fieldNum * 4),
		4 ) ;	
	fieldNum++ ;

	//Set the minor version
	copyBytes( byteArrayFromInt(WSI_MINOR_VERSION), 
		byteArray, 
		(fieldNum * 4),
		4 ) ;	
	fieldNum++ ;
	
	//Leave the id field alone since it changes for each request
	//The servlet does not currently use the id field
	fieldNum++ ;

	//Set the type for this request
	copyBytes( byteArrayFromInt(WSI_REQUEST_TYPE_SERVICE), 
		byteArray, 
		(fieldNum * 4),
		4 ) ;	
	
	HeaderBytes = byteArray ;}

	return HeaderBytes ;

}
/** Return a description of this servlet */
public String getServletInfo() {

	return "Servlet used to route requests to the VisualAge for Smalltalk Web Connection." ; }
/**
 * Return a CharToByteISO8859_1 converter to convert passed strings into
 * the code page expected by VAST.
 */
private sun.io.CharToByteConverter getStringConverter() {

	if (stringConverter == null)
		stringConverter = new sun.io.CharToByteISO8859_1() ;

	return stringConverter ; }
/** 
 * Return a String containing the HTTP header key that the passed string is mapped to
 */
private String headerKeyFor(String keyName ) {
	
		if (keyName.equals(MSG_STRING_WSI_LOCATION))
			return MSG_STRING_HTTP_LOCATION ;

		if (keyName.equals(MSG_STRING_WSI_CONTENT_TYPE))
			return MSG_STRING_HTTP_CONTENT_TYPE ;

		return keyName ;
	}

		
/** 
 * Return an int that is determined from the bytes of the
 * passed byteArray.  The int is stored in "big endian" byte
 * order.
 */
private int intFromByteArray ( byte[] byteArray ) {
// Logic copied from VAST #uint32At: implementation for bigEndian

 	int hi ;
	int lo ;
	int unsigned = 255;
	
	
	hi = ( ( byteArray[0] & unsigned) << 8 ) + ( byteArray[1] & unsigned );
	lo = ( ( byteArray[2] & unsigned) << 8 ) + ( byteArray[3] & unsigned ) ;

	return (( hi << 16 ) + lo );
}
/** 
 * When replying to an HTTP request, Smalltalk includes several
 * bytes at the beginning of the stream.  The bytes are laid out
 * as follows:
 * 0-3 - Transaction id  (not used by this servlet)
 * 4-7 - Transaction type (not used by this servlet )
 * 8-11 - Number of key/value pairs containing meta information
 * 11-??  Key/value pairs rendered by VAST Web Connection (not always required)
 * ??-??  Cookies
 */
private void processResponseHeaderBytes(InputStream socketDataIn, HttpServletResponse res) throws IOException {
	byte[] buffer = new byte[12]; // Buffer used for reading stream
	byte[] intByteArray = new byte[4]; // Interim byte array for determining a stored int
	int numProperties; // The number of header properties found
	String propName = null; // The name of a header property
	String propValue = null; // The value of a header property
	int numCookies = 0; // The number of cookies passed in the Smalltalk response stream
	Cookie cookie = null; // A cookie derived from the passed InputStream  

	socketDataIn.read(buffer);

	// Copy bytes 8-11 into the intByteArray
	for (int i = 8; i < 12; i++)
		intByteArray[i - 8] = buffer[i];
	numProperties = intFromByteArray(intByteArray);
	for (int i = 0; i < numProperties; i++) {
		// Get the propertyName
		propName = readNextString(socketDataIn);
		propValue = readNextString(socketDataIn);

		// The header names used by VA WebConnection differ from the actual key names
		// #headerKeyFor() determines the correct http header name.
		propName = headerKeyFor(propName);
		if ((propName != null) & (propValue != null)) {
			if (propName.equals(MSG_STRING_WSI_COOKIE_COUNT))
				numCookies = Integer.parseInt(propValue);
			else
				if (propName.equals(MSG_STRING_HTTP_CONTENT_TYPE))
					res.setContentType(propValue);
				else
					if (propName.equals(MSG_STRING_WSI_STATUS_CODE))
						res.setStatus(Integer.parseInt(propValue));
					else
						res.setHeader(propName, propValue);
		}
		propName = null;
		propValue = null;
	}
	for (int i = 0; i < numCookies; i++) {
		cookie = buildCookieFromInputStream(socketDataIn);
		if (cookie != null)
			res.addCookie(cookie);
	}
}
/**
 * Set the contents of byteArray to the big endian representation of the
 * passed int value.
 */
private static void putIntoByteArray(byte[] byteArray, int value, int offset) {

	int lo = value & 255 ;
	int hi = value >> 8 ;

	byteArray[offset + 1] = (byte)lo ;
	byteArray[offset] = (byte) hi ;


}
/**
 * Read the next 4-byte integer from the inputStream
 */
private int readNextInt(InputStream inStream ) throws IOException {

	byte[] buf = new byte[4] ;
	
	inStream.read(buf) ;
	return intFromByteArray(buf) ;
}
/**
 * Read the next String from the input stream by first extracting the string's length.
 * Then return the String itself
 */
private String readNextString(InputStream inStream ) throws IOException {

	int propSize = 0 ;
	byte[] buffer ;
	String nextString = null ;
	
	propSize = readNextInt(inStream) ;
	if (propSize > 0 ) {
		buffer = new byte[propSize] ;
		inStream.read(buffer) ;
		nextString = new String(buffer) ;}


	return nextString ;
}
/**
 * Clear the HeaderBytes static variable
 */
public static void reset() {	
	HeaderBytes = null ;
}
/**
 * Flatten the data in the passed cookies and save to the outStream
 */
private void saveCookiesToStream ( Cookie[] cookies, OutputStream outStream ) throws IOException {

	for (int i = 0 ; i < cookies.length ; i++ ) {

		writeString(cookies[i].getName(), outStream ) ;
		writeString(cookies[i].getValue(), outStream) ;
		writeString(cookies[i].getComment(), outStream ) ;
		writeString(cookies[i].getDomain(), outStream ) ;
		writeString(cookies[i].getPath(), outStream ) ;
	
	// Now write out the int variables
		writeInteger(cookies[i].getMaxAge(), outStream ) ;
		writeInteger(cookies[i].getVersion(), outStream ) ;
		writeInteger( ( cookies[i].getSecure() ? 1 : 0 ), outStream );

	} }
/** 
 * Process a service request for the servlet.
 * Opens a socket and sends the request to Smalltalk. 
 */
public void service(HttpServletRequest req, HttpServletResponse res) throws javax.servlet.ServletException, IOException {
	WsiTransport transport;
	ByteArrayOutputStream socketDataOut = new ByteArrayOutputStream();
	boolean debug = getConfiguration().getDebug();
	InputStream socketDataIn;
	byte[] buffer;
	int contentLength;
	int bytesRead;
	String hostName = null;
	res.setContentType(DEFAULT_CONTENT_TYPE);
	ServletOutputStream htmlOutputStream = null;
	Socket socket = null;

	if ((req.getPathInfo() == null) || (req.getPathInfo().length() <= 0 )) {
		try { 
			writeHtmlError(ERR_STRING_PATHINFONOTSET, res ) ;
			return;} 
		catch (IOException e) 
			{res.sendError(500,ERR_STRING_PATHINFONOTSET); }};
		
	if (debug)
		addDebugString(DEBUG_HOSTLOOKUP);
	// Determine the correct hostName to process the request
	transport = getConfiguration().getTransportForPathInfo(req.getPathInfo());
	if (transport != null) {
		try {
			hostName = transport.getHostName();
			if (hostName.equals("-"))
				hostName = InetAddress.getLocalHost().getHostName();
			if (debug) {
				addDebugString(DEBUG_HOSTNAME + hostName);
				addDebugString(DEBUG_SOCKET_NEW); }
			socket = new Socket(hostName, transport.getPortNumber());
		} catch (UnknownHostException e) {
			getConfiguration().logMessage(e.toString());
			if (!debug) {
				try { writeHtmlError(e.toString() , res ) ; } catch (IOException ee) { throw e; } ;
				return ; }
			else
				getConfiguration().logMessage(DEBUG_HOSTNAME + hostName);	
				throw e;
		} catch (IOException e) {
			getConfiguration().logMessage(e.toString());
			if (!debug)  {
				try { writeHtmlError(e.toString() , res ) ; } catch (IOException ee) { throw e ;} ;
				return ; }
			else
				throw e; }

		try {
			if (debug)
				addDebugString(DEBUG_SOCKET_TIMEOUT);
		// Set the timeout for this socket; otherwise, it could wait forever
			socket.setSoTimeout(getConfiguration().getSoTimeout());
			
			if (debug)
				addDebugString(DEBUG_BUILDREQUEST);
		// Build a stream to describe this request for VAST
			buildVastRequestBuffer(req, socketDataOut);

			if (debug)
				addDebugString(DEBUG_SOCKET_WRITE);
			socket.getOutputStream().write(socketDataOut.toByteArray());
			
			socketDataIn = socket.getInputStream();
			if (debug)
				addDebugString(DEBUG_SOCKET_READHEADER);
		// VAST WebConnection adds several bytes to the beginning
		// of the stream before the HTML content
			processResponseHeaderBytes(socketDataIn, res);

		// 'contentLength' is stored in the four bytes that follow
		// the header bytes.
			buffer = new byte[4];
			socketDataIn.read(buffer);
			contentLength = intFromByteArray(buffer);
			buffer = new byte[contentLength];

		// Continue to read the input stream until all data is 
		// processed. The 'read' method returns the number of
		// bytes that were read.
			if (debug)
				addDebugString(DEBUG_SOCKET_READBODY);
			htmlOutputStream = res.getOutputStream();
			while ((bytesRead = socketDataIn.read(buffer)) != -1) {
				if (debug)
					addDebugString(DEBUG_HTML_WRITE + (new Integer(bytesRead)).toString());
				htmlOutputStream.write(buffer,0,bytesRead);
				clearBuffer(buffer);
			}
			if (debug)
				addDebugString(DEBUG_SOCKET_CLOSE);
			socket.close();
			if (debug)
				addDebugString(DEBUG_HTML_CLOSE);
			htmlOutputStream.close();
			
		} catch (IOException e) {
			getConfiguration().logMessage(e.toString());
			try { 
				socket.close();
		// If debug is active, throw the exception; otherwise provide a nicely formatted error
				if ((debug) && (htmlOutputStream != null ))
					throw e ;
				else 
					try { writeHtmlError(e.toString() , res ) ; } catch (IOException ee) { throw e ; } ;
				 }
		 	catch ( IOException ee ) {}  
		}
	}
	else
		try { writeHtmlError(ERR_STRING_MISSINGLINK , res ) ; } 
		catch (IOException e) { res.sendError(500,ERR_STRING_MISSINGLINK); } ;	
}
/**
 * Write the passed byte array and its length to the output stream.
 * A length of 0 is written out if the byteArray size is 0, but no data bytes are written
 */
private void writeBytes ( byte[] byteArray, OutputStream outStream) {

	byte[] buf;   
		
	try {
	buf =  byteArrayFromInt(byteArray.length );
	outStream.write(buf) ;
	if ( byteArray.length > 0 ) {		
		outStream.write(byteArray); } }
	
	catch ( IOException e) { getConfiguration().logMessage(e.toString());} }
	
/**
 * Format the error string and write it to the HTML output stream
 */
private void writeHtmlError ( String errorString, HttpServletResponse res ) throws IOException {

		PrintWriter html = res.getWriter() ;

		if (html !=  null ) {
			html.print(formatHtmlError(errorString)) ;
			html.close() ; }
	}
/**
 * Write the passed integer to the outStream
 */
private void writeInteger ( int passedInt, OutputStream outStream ) throws IOException {

	byte[] buf ;

	buf = byteArrayFromInt(passedInt );
	// Write the number of properties being passed 
	outStream.write(buf) ;
}
/**
 * Write the passed string and its length to the output stream.
 * A length of 0 is written out if null is passed (no content written for this case).
 * The length is written first
 */
private void writeString ( String propertyString, OutputStream outStream) {
	
	if ( propertyString == null )
		writeBytes(new byte[0], outStream ) ;
	else
		try {
			writeBytes(getStringConverter().convertAll(propertyString.toCharArray()), outStream) ; }
		catch (sun.io.MalformedInputException e ) {
			writeBytes(propertyString.getBytes(), outStream); } }
	
}
