
#ifndef esuser_h
#define esuser_h

#include "escomp.h"
#include "es.h"

/* platform specific, describes included modules */
#include "esparts.h"		

typedef	ESObjectHeader * EsObject;
typedef	ESVMContext * EsVMContext;
typedef	ESBehavior * EsBehavior;
typedef	ESGlobalInfo EsGlobalInfo;


/* for vm options set in parse.c */

#define DEFAULT_VALUE	(-1)

typedef struct EsVMOptions {
	char *key;
	U_32 *address;
	I_32 defaultValue;
} EsVMOptions;

/* Include here so it can see the above Es types */

#include "espriv.h"

#ifdef	WIN32
#define	ESPOINTERCONVERT
#endif

#ifdef	OS2
#define	ESPOINTERCONVERT
#endif

#ifdef ESPOINTERCONVERT
U_32 VMAPICALL EsSelectorOffsetToLinear PROTOTYPE((U_32));
U_32 VMAPICALL EsLinearToSelectorOffset PROTOTYPE((U_32));
#endif

/* Options for image loading */
#define COPY_NOTHING	 0
#define COPY_TO_BASE_ADDRESS 1
/* #define COPY_ALL_SEGMENTS 2 */
#define COPY_RAM_SEGMENTS 4
#define COPY_DYNAMIC_SEGMENTS 8
#define DEPENDENT_NOT_LINKED 16
#define BASE_NOT_LINKED 32

/* Runtime options */
#define RUNTIME_NO_FILEPOINTERS 1
#define RUNTIME_NO_CMINFO 2
#define RUNTIME_NO_CATEGORIES 4
#define RUNTIME_NO_APPLICATIONS 8
#define RUNTIME_DUMP_IMAGE_ON_ERROR 16

/* User primitives */

/* To define a user primitive table, do the following:

	EsDefinePrimitiveTable(tableName)
		EsPrimitiveTableEntry(name, function)
		...
	EsEndPrimitiveTable

	name from above is the string by which smalltalk identifies the
	user primitive.  function is the C user primitive function which
	will be called.

	Tables may be nested by using EsSubTable(tableName) in place of
	a primitive table entry.

	The tables have type EsPrimitiveTable.
*/


#if 1
typedef struct {
	char * name;
	void * funcOrTable;
} EsPrimitiveTableSlot;

typedef	EsPrimitiveTableSlot EsPrimitiveTable[];


#if defined(ESVM_DYNAMIC_LINK_USER_PRIMS) && defined(ES_DYNAMIC_LINK_USER_PRIMS)
struct EsUserPrimitiveEntryPoints;
void EsPrivateInit PROTOTYPE((struct EsUserPrimitiveEntryPoints *));
#define	EsDefinePrimitiveTable(name)	EsPrimitiveTableSlot name [] = { { (char *) ("EsPrivateInit"), (void *) (EsPrivateInit)},
#else
#define	EsDefinePrimitiveTable(name)	EsPrimitiveTableSlot name [] = {
#endif
#define	EsSubTable(table)		EsPrimitiveTableEntry(0, (table))
#define	EsPrimitiveTableEntry(name, fn)	{ (char *) (name), (void *) (fn) },
#define	EsEndPrimitiveTable             { (char *) 0, (void *) 0} };

#endif

/* User primitives are defined by:

	EsUserPrimitive(name)
	{
		...code...
	}

	Within the primitive, the following are defined:

	EsPrimVMContext     - VM context of the process calling the primitive
	EsPrimReceiver      - the receiver of the primitive
	EsPrimArgument(n)   - argument n of the primitive (1 indexed)
	EsPrimArgumentCount - the number of arguments passed to the primitive

	If the primitive fails, use EsPrimFail(err, arg) where err
	is one of the EsPrimErr values from below and arg is the argument in
	which the error occurred (1 indexed).  If the error occurred in the
	receiver, use EsPrimArgNumSelf.  If the error occurred in no
	particular argument (e.g. not enough memory to allocate an object),
	use EsPrimArgNumNoArg.  If the error is EsPrimErrOSError, the arg
	value is the OS error number.  EsPrimFail returns from the
	enclosing function and executes the fail code in the smalltalk
	user primitive method.

	If the primitive succeeds, use EsPrimSucceed(object).  The enclosing
	function is returned from and object is answered to the sender of the
	user primitive method in smalltalk.
*/


#ifdef USE_PROTOTYPES 
#define	EsUserPrimitive(name) \
extern BOOLEAN VMCALL name (EsVMContext EsPrimVMContext, U_32 EsPrimArgumentCount, U_32 EsPrimPushCount); \
BOOLEAN VMCALL name (EsVMContext EsPrimVMContext, U_32 EsPrimArgumentCount, U_32 EsPrimPushCount)
#else
#define	EsUserPrimitive(name)	\
BOOLEAN VMCALL name (EsPrimVMContext, EsPrimArgumentCount, EsPrimPushCount) \
					EsVMContext EsPrimVMContext; \
					U_32 EsPrimArgumentCount; \
					U_32 EsPrimPushCount;
#endif

#define	EsPrimArgument(n)	(EsPrimVMContext->sp[EsPrimPushCount-(n)])
#define	EsPrimReceiver		EsPrimArgument(EsPrimArgNumSelf)
#define	EsPrimFail(err, arg)	return((EsPrimVMContext->errorCode = (err)), \
				       (EsPrimVMContext->argNumber = (U_32) (arg)), \
				       FALSE)
#define	EsPrimSucceed(val)	return((EsPrimReceiver = (val)), TRUE)

/* User primitive environment setup for non-user primitives.  Declare the
   environment in the local variable section of your function.
*/

#define	EsDefineUserPrimitiveEnvironment(globalInfo) \
	EsVMContext EsPrimVMContext = (EsVMContext) ((globalInfo)->currentVMContext); \
	U_32 EsPrimPushCount = 0

/* User primitive error codes */

#define	EsPrimErrNoError						0
#define	EsPrimErrInvalidClass					1
#define	EsPrimErrIndexOutOfRange				2
#define	EsPrimErrNotIndexable					3
#define	EsPrimErrValueOutOfRange				4
#define	EsPrimErrReadOnly						5
#define	EsPrimErrSignedNotDefined				6
#define	EsPrimErrFPOverflow						7
#define	EsPrimErrFPDomainError					8
#define	EsPrimErrFPGeneralError					9
#define	EsPrimErrDivideByZero					10
#define	EsPrimErrInvalidSize					11
#define	EsPrimErrNotEnoughMemory				12
#define	EsPrimErrUserPrimitiveNotFound		13
#define	EsPrimErrUnknownAPIType				15
#define	EsPrimErrUnknownConversionType	16
#define	EsPrimErrInvalidArgumentCount		17
#define	EsPrimErrOSError						18
#define	EsPrimErrProcessDead					19
#define	EsPrimErrProcessActive					20
#define	EsPrimErrInvalidArgCount				EsPrimErrInvalidArgumentCount
#define	EsPrimErrUnboundFunction				22
#define	EsPrimErrUnimplementedPrimitive			23
#define	EsPrimErrInvalidInCallback				24
#define	EsPrimErrCannotReturn					25
#define	EsPrimErrDebugNotSupported				26
#define	EsPrimErrDNURecursion					27
#define	EsPrimErrProcessTerminatedDuringCallIn	28
#define	EsPrimErrStackOverflow					29
#define	EsPrimErrInvalidReftype					30
#define	EsPrimErrInvalidReference				31
#define	EsPrimErrInvalidOffset					32
#define	EsPrimErrImageFileOpenError				33
#define	EsPrimErrImageReadError					34
#define	EsPrimErrMaxMemorySegmentsExceeded		35
#define	EsPrimErrRSGrowFail						36
#define	EsPrimErrImageFileInvalid				37
#define	EsPrimErrSupportDLLMissing				38
#define	EsPrimErrInternalError					39
#define	EsPrimErrMaxImageSavesExceeded			40
#define	EsPrimErrAsyncQueueOverrun	41
#define	EsPrimErrNMI			42
#define	EsPrimErrUnimplementedBytecode	43
#define	EsPrimErrImageSaveError		44
#define	EsPrimErrInvalidAsyncMessage		45
#define	EsPrimErrDecimalError		46
#define	EsPrimErrDecimalPrecisionScaleMismatch	47
#define	EsPrimErrDecimalInvalidScale		48
#define	EsPrimErrDecimalInvalidPrecision		49
#define	EsPrimErrDecimalPrecisionOverflow		50
#define	EsPrimErrInvalidMemorySegment		51
#define	EsPrimErrGPF	52
#define	EsPrimErrGPFInvalidRead	53
#define	EsPrimErrGPFInvalidWrite	54
#define	EsPrimErrGPFInvalidInstruction	55
#define	EsPrimErrOutOfScopeReturnFromCallIn	56
#define	EsPrimErrNoMoreEntryPoints	57
#define	EsPrimErrInvalidRelocation		58
#define	EsPrimErrFPUnderflow		59
#define	EsPrimErrExitDueToWalkback		60
#define	EsPrimErrEvaluationTimeLimitExpired	61
#define	EsPrimErrExitDueToStackDump	62

/* Error numbers from 1 to EsPrimErrMinUserError
are reserved by the system.
*/
#define EsPrimErrMinUserError					8192

/* Special fail argument values */

#define	EsPrimArgNumSelf			0
#define	EsPrimArgNumNoArg			(-1)

/* Immediate objects */

#define	EsTrue			((EsObject) 0x1E)
#define	EsFalse			((EsObject) 0x2E)
#define	EsNil			((EsObject) 0x0E)

/* Object type testing.  EsObjectShape(o) is one of the EsShape values
   below.
*/

#define	EsObjectShape(o)	(EsFlags(o) & 6)
#define	EsShapePointers		0
#define	EsShapeBytes		2
#define	EsShapeWords		4
#define	EsShapeLongs		6
#define	EsIsImmediate(o)	(EsLow2Bits(o) != 0)
#define	EsIsSmallInteger(o)	(EsLowBit(o) == EsTagSmallInteger)
#define	EsIsCharacter(o)	(EsLow4Bits(o) == EsTagCharacter)
#define	EsIsTrue(o)			((o) == EsTrue)
#define	EsIsFalse(o)		((o) == EsFalse)
#define	EsIsNil(o)			((o) == EsNil)
#define	EsIsBoolean(o)		(EsIsTrue(o) || EsIsFalse(o))
#define	EsIsLargeInteger(o)	((!EsIsImmediate(o)) && (EsPrivateClass(o) == EsPrimClassLargeInteger))
#define	EsIsFloat(o)		((!EsIsImmediate(o)) && (EsPrivateClass(o) == EsPrimClassFloat))
#define	EsIsBytes(o)		((!EsIsImmediate(o)) && (EsObjectShape(o) == EsShapeBytes))
#define	EsIsWords(o)		((!EsIsImmediate(o)) && (EsObjectShape(o) == EsShapeWords))
#define	EsIsLongs(o)		((!EsIsImmediate(o)) && (EsObjectShape(o) == EsShapeLongs))
#define	EsIsPointers(o)		((!EsIsImmediate(o)) && (EsObjectShape(o) == EsShapePointers))
#define	EsIsIndexable(o)	((!EsIsImmediate(o)) && (EsFlags(o) & EsIndexableBit))
#define	EsIsReadOnly(o)		(EsIsImmediate(o) || (EsFlags(o) & EsReadOnlyBit))
#define EsIsCharacters(o) 	EsPrivateIsCharacters(EsPrimVMContext, (o))

/* C -> Smalltalk conversion */

#define	EsI32ToSmallInteger(val)	((EsObject) (((val) << EsShiftSmallInteger) | EsTagSmallInteger))
#define	EsU16ToCharacter(c)	((EsObject) (((((U_32) (c)) & 0xFFFF) << EsShiftCharacter) | EsTagCharacter))
#define	EsCharToCharacter(c)	EsU16ToCharacter(c)

/* These convert val into an object and store it in *o.  The return value is
   an EsPrimErr.  If it is EsPrimErrNoError, *o is valid.  Otherwise, *o is
   invalid.  o is an EsObject *.  val is an I_32, U_32 or double depending on
   which conversion is being used.
*/

#define	EsI32ToInteger(val, o)	EsMakeSignedInteger((val), (o), EsPrimVMContext)
#define	EsU32ToInteger(val, o)	EsMakeUnsignedInteger((val), (o), EsPrimVMContext)
#define	EsCDoubleToFloat(val, o)	EsMakeDouble((val), (o), EsPrimVMContext)

/* Smalltalk -> C conversion */

#define	EsSmallIntegerToI32(o)	(((I_32) (o)) >> EsShiftSmallInteger)
#define	EsCharacterToChar(o)	((char) EsCharacterToU16(o))
#define	EsCharacterToU16(o)	((U_16) (((U_32) (o)) >> EsShiftCharacter))

/* These convert o into a C integer or double and store it in *val.  The
   return value is an EsPrimErr.  If it is EsPrimErrNoError, *val is valid.
   Otherwise, *val is invalid.  o is an EsObject.  val is an I_32 *, a U_32 *,
   or double *, depending on which conversion is being used.
*/

#define	EsIntegerToI32(o, val)	EsGetI32((o), (val), EsPrimVMContext)
#define	EsIntegerToU32(o, val)	EsGetU32((o), (val), EsPrimVMContext)
#define	EsFloatToCDouble(o, val)	EsGetDouble((o), (val), EsPrimVMContext)

/* Accessors */

#define	EsInstSize(o)	(EsIsImmediate(o) ? 0 : EsPrivateInstSize(o))

#define	EsObjectClass(o)	EsGetClass((o), EsPrimVMContext)

/* Note that the AtPut macros have no return value.  EsInstVarAt,
   EsInstVarPut, EsAt and EsAtPut are for pointer objects only.
*/

#define	EsInstVarAddr(o)	((U_32 *) EsObjectData(o))
#define	EsInstVarAt(o, idx) (EsObjectData(o)[(idx) - 1])
#define	EsInstVarAtPut(o, idx, val) (EsInstVarAt(o, idx) = (val)), EsRememberObjectStore(EsPrimVMContext, (o), (val))
#define	EsAt(o, idx) EsInstVarAt(o, (idx) + EsPrivateInstSize(o))
#define	EsAtPut(o, idx, val) EsInstVarAtPut(o, (idx) + EsPrivateInstSize(o), val)
#define	EsByteAt(o, idx) (((U_8 *) EsObjectData(o))[(idx) - 1])
#define	EsByteAtPut(o, idx, val) EsByteAt(o, idx) = (U_8) (val)
#define	EsWordAt(o, idx) (((U_16 *) EsObjectData(o))[(idx) - 1])
#define	EsWordAtPut(o, idx, val) EsWordAt(o, idx) = (U_16) (val)
#define	EsLongAt(o, idx) (((U_32 *) EsObjectData(o))[(idx) - 1])
#define	EsLongAtPut(o, idx, val) EsLongAt(o, idx) = (U_32) (val)
#define	EsSignedByteAt(o, idx) ((I_8) EsByteAt(o, idx))
#define	EsSignedByteAtPut(o, idx, val) EsByteAtPut(o, idx, val)
#define	EsSignedWordAt(o, idx) ((I_16) EsWordAt(o, idx))
#define	EsSignedWordAtPut(o, idx, val) EsWordAtPut(o, idx, val)
#define	EsSignedLongAt(o, idx) ((I_32) EsLongAt(o, idx))
#define	EsSignedLongAtPut(o, idx, val) EsLongAtPut(o, idx, val)

/* EsSaveObject(o) pushes o onto the smalltalk stack so that it is not
   lost during a GC.

   EsRestoreObject() pops the object on top of the smalltalk stack and
   returns it.	  

   Because of the nature of the stack, objects must be restored in the
   opposite order they were saved.

   All saved objects must be restored before the primitive fails or succeeds.
*/

#define	EsSaveObject(o)	++EsPrimPushCount, *--(EsPrimVMContext->sp) = (o)
#define	EsRestoreObject() (--EsPrimPushCount, *(EsPrimVMContext->sp++))

/* Classes */

#define	EsPrimClassSmallInteger	EsVMClass(EsPrimVMContext, classSmallInteger)
#define	EsPrimClassTrue		EsVMClass(EsPrimVMContext, classTrue)
#define	EsPrimClassFalse	EsVMClass(EsPrimVMContext, classFalse)
#define	EsPrimClassUndefinedObject	EsVMClass(EsPrimVMContext, classUndefinedObject)
#define	EsPrimClassCharacter	EsVMClass(EsPrimVMContext, classCharacter)
#define	EsPrimClassPointer	EsVMClass(EsPrimVMContext, classPointer)

#define	EsPrimClassString	EsRegistryClass(EsPrimVMContext, stringClassAssoc)
#define	EsPrimClassDBString	EsRegistryClass(EsPrimVMContext, dbStringClassAssoc)
#define	EsPrimClassArray	EsRegistryClass(EsPrimVMContext, arrayClassAssoc)
#define	EsPrimClassFloat	EsRegistryClass(EsPrimVMContext, floatClassAssoc)
#define	EsPrimClassLargeInteger	EsRegistryClass(EsPrimVMContext, largeIntegerClassAssoc)
#define	EsPrimClassByteArray	EsRegistryClass(EsPrimVMContext, byteArrayClassAssoc)

/* GC Deferral */

#define	EsShouldDeferGC(vm)	(((vm)->globalInfo->entryAndDefer & 0xFFFF) != 0)

#define EsAllocateArray(vm,size) \
EsAllocateObject((vm), EsPrimClassArray, (size), 0, (EsObject **) NULL)

#define EsAllocateString(vm,size) \
EsAllocateObject((vm), EsPrimClassString, (size), 0, (EsObject **) NULL)

#define EsAllocateDBString(vm,size) \
EsAllocateObject((vm), EsPrimClassDBString, (size), 0, (EsObject **) NULL)

#define EsAllocateByteArray(vm,size) \
EsAllocateObject((vm), EsPrimClassByteArray, (size), 0, (EsObject **) NULL)

/* Function prototypes */
#if defined(ESVM_DYNAMIC_LINK_USER_PRIMS)
struct EsUserPrimitiveEntryPoints {
/* from espriv.h */
	U_32 (VMCALL *mEsMakeSignedInteger) PROTOTYPE((I_32, EsObject *, EsVMContext));
	U_32 (VMCALL *mEsMakeUnsignedInteger) PROTOTYPE((U_32, EsObject *, EsVMContext));
	U_32 (VMCALL *mEsMakeDouble) PROTOTYPE((double, EsObject *, EsVMContext));
	U_32 (VMCALL *mEsGetI32) PROTOTYPE((EsObject, I_32 *, EsVMContext));
	U_32 (VMCALL *mEsGetU32) PROTOTYPE((EsObject, U_32 *, EsVMContext));
	U_32 (VMCALL *mEsGetDouble) PROTOTYPE((EsObject, double *, EsVMContext));
	EsBehavior (VMCALL *mEsGetClass) PROTOTYPE((EsObject, EsVMContext));
	BOOLEAN (VMCALL *mEsPrivateIsCharacters) PROTOTYPE((EsVMContext, EsObject));
	I_32 (VMCALL *mEsDaysFrom1901) PROTOTYPE((void));

/* from esuser.h */
	EsGlobalInfo * (VMCALL *mEsInitializeImage) PROTOTYPE((void));
	I_32 (VMCALL *mEsShutdownImage) PROTOTYPE((EsGlobalInfo *));
	I_32 (VMCALL *mEsInitializeTargetInterface) PROTOTYPE((I_32 argc, char ** argv, char ** envp, ESGlobalInfo *ginfo));
	void (VMCALL *mEsShutDownTargetInterface) PROTOTYPE((ESGlobalInfo *ginfo));
	void (VMCALL *mEsReportError) PROTOTYPE((I_32 err, ESGlobalInfo *globalInfo));
#ifndef EsNoPrintfPrototype
	void (VMCALL *mEsPrintf)();	/* must have no PROTOTYPE */
#endif
	I_32 (VMCALL *mEsLoadFileImage) PROTOTYPE((int argc, char *argv[], char *envp[], EsGlobalInfo * info));
	I_32 (VMCALL *mEsExecuteImage) PROTOTYPE((EsGlobalInfo *));
	U_32 (VMCALL *mEsVMVersion) PROTOTYPE((void));
	char * (*mEsVMVersionString) PROTOTYPE((void));
	I_32 (VMCALL *mEsSendMessage) PROTOTYPE((EsVMContext, EsObject *, EsObject, EsObject, U_32 VARARGS));
	EsObject (VMCALL *mEsAllocateObject) PROTOTYPE((EsVMContext, EsBehavior, U_32, U_32, EsObject **));
	EsObject (VMCALL *mEsAllocateFixedObject) PROTOTYPE((EsVMContext, EsBehavior, U_32, U_32, EsObject **));
	void (VMCALL *mEsPostNMI) PROTOTYPE((EsVMContext));
	BOOLEAN (VMCALL *mEsPostAsyncMessage) PROTOTYPE((EsVMContext, EsObject, EsObject, U_32 VARARGS));
	void (VMCALL *mEsScavenge) PROTOTYPE((EsVMContext,U_32));
	void (VMCALL *mEsGGC) PROTOTYPE((EsVMContext,U_32));
	void (VMCALL *mEsRememberObjectStore) PROTOTYPE((EsVMContext, EsObject, EsObject));
	U_32 (VMCALL *mEsBasicHash) PROTOTYPE((EsObject));
	U_32 (VMCALL *mEsBasicSize) PROTOTYPE((EsObject));
	void (VMCALL *mEsSetImageUserField) PROTOTYPE((ESGlobalInfo * globalInfo, U_32 value));
	U_32 (VMCALL *mEsGetImageUserField) PROTOTYPE((ESGlobalInfo * globalInfo));
};
#endif

#if !defined(ES_DYNAMIC_LINK_USER_PRIMS) || !defined(ESVM_DYNAMIC_LINK_USER_PRIMS)

EsGlobalInfo * VMCALL EsInitializeImage PROTOTYPE((void));

I_32 VMCALL EsShutdownImage PROTOTYPE((EsGlobalInfo *));

I_32 VMCALL EsInitializeTargetInterface PROTOTYPE((I_32 argc, char ** argv, char ** envp, ESGlobalInfo *ginfo));

void VMCALL EsShutDownTargetInterface PROTOTYPE((ESGlobalInfo *ginfo));

void VMCALL EsReportError PROTOTYPE((I_32 err, ESGlobalInfo *globalInfo));

#ifndef EsNoPrintfPrototype
void VMCALL EsPrintf();	/* must have no PROTOTYPE */
void VMCALL EsSplashPrintf();	/* must have no PROTOTYPE */
#endif

I_32 VMCALL EsLoadFileImage PROTOTYPE((int argc, char *argv[], char *envp[], EsGlobalInfo * info));

I_32 VMCALL EsExecuteImage PROTOTYPE((EsGlobalInfo *));

U_32 VMCALL EsVMVersion PROTOTYPE((void));

char * EsVMVersionString PROTOTYPE((void));

I_32 VMCALL EsSendMessage PROTOTYPE((EsVMContext, EsObject *, EsObject, EsObject, U_32 VARARGS));

EsObject VMCALL EsAllocateObject PROTOTYPE((EsVMContext, EsBehavior, U_32, U_32, EsObject **));

EsObject VMCALL EsAllocateFixedObject PROTOTYPE((EsVMContext, EsBehavior, U_32, U_32, EsObject **));

void VMCALL EsPostNMI PROTOTYPE((EsVMContext));

BOOLEAN VMCALL EsPostAsyncMessage PROTOTYPE((EsVMContext, EsObject, EsObject, U_32 VARARGS));

void VMCALL EsScavenge PROTOTYPE((EsVMContext,U_32));

void VMCALL EsGGC PROTOTYPE((EsVMContext,U_32));

void VMCALL EsRememberObjectStore PROTOTYPE((EsVMContext, EsObject, EsObject));

U_32 VMCALL EsBasicHash PROTOTYPE((EsObject));

U_32 VMCALL EsBasicSize PROTOTYPE((EsObject));

void VMCALL EsSetImageUserField PROTOTYPE((ESGlobalInfo * globalInfo, U_32 value));

U_32 VMCALL EsGetImageUserField PROTOTYPE((ESGlobalInfo * globalInfo));
#else
extern struct EsUserPrimitiveEntryPoints *ptrTable;

/* espriv.h */
#define EsMakeSignedInteger(a,b,c) (ptrTable->mEsMakeSignedInteger)(a,b,c)
#define EsMakeUnsignedInteger(a,b,c) (ptrTable->mEsMakeUnsignedInteger)(a,b,c)
#define EsMakeDouble(a,b,c) (ptrTable->mEsMakeDouble)(a,b,c)
#define EsGetI32(a,b,c) (ptrTable->mEsGetI32)(a,b,c)
#define EsGetU32(a,b,c) (ptrTable->mEsGetU32)(a,b,c)
#define EsGetDouble(a,b,c) (ptrTable->mEsGetDouble)(a,b,c)
#define EsGetClass(a,b) (ptrTable->mEsGetClass)(a,b)
#define EsPrivateIsCharacters(a,b) (ptrTable->mEsPrivateIsCharacters)(a,b)
#define EsDaysFrom1901() (ptrTable->mEsDaysFrom1901)()

/* esuser.h */
#define EsInitializeImage() (ptrTable->mEsInitializeImage)()
/*	) PROTOTYPE((void));*/
#define EsShutdownImage(a) (ptrTable->mEsShutdownImage)(a)
/*	) PROTOTYPE((EsGlobalInfo *));*/
#define EsInitializeTargetInterface(a,b,c,d) (ptrTable->mEsInitializeTargetInterface)(a,b,c,d)
/*	) PROTOTYPE((I_32 argc, char ** argv, char ** envp, ESGlobalInfo *ginfo)); */
#define EsShutDownTargetInterface(a) (ptrTable->mEsShutDownTargetInterface)(a)
/*	) PROTOTYPE((ESGlobalInfo *ginfo)); */
#define EsReportError(a,b) (ptrTable->mEsReportError)(a,b)
/*	) PROTOTYPE((I_32 err, ESGlobalInfo *globalInfo)); */

#ifndef EsNoPrintfPrototype
#define EsPrintf	(ptrTable->mEsPrintf)
#endif

#define EsLoadFileImage(a,b,c,d) (ptrTable->mEsLoadFileImage)(a,b,c,d)
/*	) PROTOTYPE((int argc, char *argv[], char *envp[], EsGlobalInfo * info)); */
#define EsExecuteImage(a) (ptrTable->mEsExecuteImage)(a)
/*	) PROTOTYPE((EsGlobalInfo *)); */
#define EsVMVersion (ptrTable->mEsVMVersion)
/*	) PROTOTYPE((void)); */
#define EsVMVersionString (ptrTable->mEsVMVersionString)
/* ) PROTOTYPE((void)); */
#define EsSendMessage (ptrTable->mEsSendMessage)
/*) PROTOTYPE((EsVMContext, EsObject *, EsObject, EsObject, U_32 VARARGS)); */
#define EsAllocateObject(a,b,c,d,e) (ptrTable->mEsAllocateObject)(a,b,c,d,e)
/*) PROTOTYPE((EsVMContext, EsBehavior, U_32, U_32, EsObject **)); */
#define EsAllocateFixedObject(a,b,c,d,e) (ptrTable->mEsAllocateFixedObject)(a,b,c,d,e)
/*) PROTOTYPE((EsVMContext, EsBehavior, U_32, U_32, EsObject **)); */
#define EsPostNMI(a) (ptrTable->mEsPostNMI)(a)
/*) PROTOTYPE((EsVMContext)); */
#define EsPostAsyncMessage (ptrTable->mEsPostAsyncMessage)
/*) PROTOTYPE((EsVMContext, EsObject, EsObject, U_32 VARARGS)); */
#define EsScavenge(a,b) (ptrTable->mEsScavenge)(a,b)
/*) PROTOTYPE((EsVMContext,U_32)); */
#define EsGGC(a,b) (ptrTable->mEsGGC)(a,b)
/*) PROTOTYPE((EsVMContext,U_32)); */
#define EsRememberObjectStore(a,b,c) (ptrTable->mEsRememberObjectStore)(a,b,c)
/*) PROTOTYPE((EsVMContext, EsObject, EsObject)); */
#define EsBasicHash(a) (ptrTable->mEsBasicHash)(a)
/*) PROTOTYPE((EsObject)); */
#define EsBasicSize(a) (ptrTable->mEsBasicSize)(a)
/*) PROTOTYPE((EsObject)); */
#define EsSetImageUserField(a,b) (ptrTable->mEsSetImageUserField)(a,b)
/*) PROTOTYPE((ESGlobalInfo * globalInfo, U_32 value)); */
#define EsGetImageUserField(a) (ptrTable->mEsGetImageUserField)(a)
/*) PROTOTYPE((ESGlobalInfo * globalInfo)); */
#endif

#endif /* esuser_h */

