/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.connector.imstoc;

import com.ibm.connector.AlreadyConnectedException;
import com.ibm.connector.Communication;
import com.ibm.connector.CommunicationException;
import com.ibm.connector.ConnectionSpec;
import com.ibm.connector.InteractionSpec;
import com.ibm.connector.NoConnectionAvailableException;
import com.ibm.connector.NotConnectedException;
import com.ibm.connector.imstoc.IMSConnection;
import com.ibm.connector.imstoc.IMSConnectionSpec;
import com.ibm.connector.imstoc.IMSManagedFactory;
import com.ibm.connector.imstoc.IMSTOCResourceException;
import com.ibm.connector.infrastructure.Coordinator;
import com.ibm.connector.infrastructure.RASService;
import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.connector.internal.BadInvOrderException;
import com.ibm.connector.internal.ConnectionManager;
import com.ibm.connector.internal.Managed;
import com.ibm.connector.internal.ManagedFactory;
import com.ibm.connector.internal.Resource;
import com.ibm.connector.internal.ResourceException;
import com.ibm.imstoc.IMSTimer;
import java.io.Serializable;

public class IMSCommunication
implements Communication,
Serializable {
    private static String copyrights = "Licensed Material - Property of IBM IBM IMS TCP/IP OTMA Connection Connector for Java, Version 1, Release 1. (C) Copyright IBM Corp. 1998.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private IMSConnectionSpec _ConnectionSpec = null;
    private IMSConnection _Connection;
    private RuntimeContext _RuntimeContext;
    private IMSTimer _Timer;

    public IMSCommunication() {
        this._Connection = null;
        this._RuntimeContext = RuntimeContext.getCurrent();
    }

    protected IMSCommunication(IMSConnection connection) {
        this._Connection = connection;
        this._RuntimeContext = RuntimeContext.getCurrent();
    }

    public void connect() throws AlreadyConnectedException, NoConnectionAvailableException, CommunicationException, BadInvOrderException {
        String methodName = String.valueOf(super.toString()) + ".IMSCommunication.connect()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        ConnectionManager connectionManager = this._RuntimeContext.getConnectionManager();
        if (this._Connection != null) {
            connectionManager.release((Managed)this._Connection);
            this._Connection = null;
        }
        this._Connection = (IMSConnection)connectionManager.reserve((ManagedFactory)new IMSManagedFactory(), this.getConnectionSpec());
        try {
            this._Connection.connect();
        }
        catch (BadInvOrderException e1) {
            connectionManager.release((Managed)this._Connection);
            this._Connection = null;
            throw e1;
        }
        catch (CommunicationException e2) {
            connectionManager.release((Managed)this._Connection);
            this._Connection = null;
            throw e2;
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void disconnect() throws NotConnectedException, CommunicationException {
        String methodName = String.valueOf(super.toString()) + ".disconnect()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        if (this._Connection != null) {
            this._RuntimeContext.getConnectionManager().release((Managed)this._Connection);
            this._Connection = null;
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public String dumpObjStr() {
        return "\t[" + super.toString() + "]" + "\n\t\truntimeContext: [" + this._RuntimeContext + "]" + "\n\t\tconnectionSpec: [" + this._ConnectionSpec + "]" + "\n\t\tconnection: [" + this._Connection + "\n\t\t]";
    }

    public synchronized void execute(InteractionSpec interactionSpec, Object input, Object output) throws CommunicationException, IllegalArgumentException, NotConnectedException, ResourceException, IMSTOCResourceException, BadInvOrderException {
        String methodName = String.valueOf(super.toString()) + ".execute(InteractionSpec, Object, Object)";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        if (rasService.getTraceLevel() >= 3) {
            rasService.logTraceInfo(this.dumpObjStr());
        }
        Coordinator coordinator = this._RuntimeContext.getCoordinator();
        if (this._Connection == null) {
            this.connect();
        }
        if (coordinator.isCoordinating() && this._Connection.getCoordinationID() == null) {
            coordinator.register((Resource)this._Connection);
            this._Connection.setCoordinationID(coordinator.getCoordinationID());
        }
        this._Connection.call(interactionSpec, input, output);
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public ConnectionSpec getConnectionSpec() {
        String methodName = String.valueOf(super.toString()) + ".getConnectionSpec()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        return this._ConnectionSpec;
    }

    public void setConnectionSpec(ConnectionSpec connectionSpec) {
        String methodName = String.valueOf(super.toString()) + ".setConnectionSpec(ConnectionSpec)";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        this._ConnectionSpec = (IMSConnectionSpec)connectionSpec;
    }
}

