package COM.ibm.ivj.javabeans;

import java.util.EventObject;
import java.lang.*;

/** IParameterEvent objects are events that contain parameters.  
  * This is the base class of many of the events in the IBM Runtime
  * libraries.
  */
public class IParameterEvent extends java.util.EventObject
{
   private static String copywrite = "IBM(R) VisualAge(TM) for Java(TM), Version 1 and others\n - Licensed Material - Program-Property of IBM\n(C) Copyright IBM Corp. 1997 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
   private Object parameter = null;

/** This constructor creates an IParameterEvent object with the 
  * passed-in source and a null parameter.
  * @param source the java.lang.Object that is the source of the event.
  */
   public IParameterEvent(Object source) { this(source,null); }

/** This constructor creates an IParameterEvent object with the
  * passed-in source and parameter.
  * @param source the java.lang.Object that is the source of the event.
  * @param aParameter the java.lang.Object parameter associated with the event.
  */
   public IParameterEvent(Object source, Object aParameter)
   {
      super(source);
      parameter = aParameter;
   }

/** Use this method to get the parameter associated with the event.
  * @return java.lang.Object the parameter associated with the event.
  */
   public Object getParameter() { return parameter; }

/** Use this method to set the value of the parameter to be associated with the event.
  * @param aParameter java.lang.Object parameter associated with the event.
  */
   public void setParameter(Object aParameter) { parameter = aParameter; }

/** Use this method to append the toString of the parameter to the 
  * toString of the event.
  * @return java.lang.String containing the event and parameter.
  */
   public String toString()
   {
      if ( parameter == null )
         return super.toString();
      else
         return super.toString() + ": " + parameter.toString();
   }
}
