// Please refer to the readme on how to run this sample.

package COM.ibm.ivj.examples.database.minisamp.ODBC;
import  ODBCgen.*;

import java.lang.*;
import java.util.*;
import COM.ibm.ivj.eab.data.*;

public class gifget
{
  public static void main(String argv[])
  {
    try
    {
      // Create the Datastore and Manager objects
      Emp_photoDatastore     thePhotoDatastore  = new Emp_photoDatastore();
      Emp_photo              thePhoto           = new Emp_photo();

      // Connect to database
      System.out.println("Connecting to EmpPhoto database...");
      thePhotoDatastore.connect();
      System.out.println("...Connected");

      if ( argv.length == 0 )
      {
        System.out.println( "Please enter an employee number" );
      }
      else
      {
         System.out.println("Select first Gif photo");
         thePhoto.setEmpno( argv[0] );
         thePhoto.setPhoto_format( "gif" );
         String fileName = argv[0] + ".gif";
         thePhoto.setPicture( new DAIOStream( fileName ) );
         try
         {
           thePhoto.retrieve();
           System.out.println("Gif for " + argv[0] + " has been retrieved into file " + fileName );
         }
         catch( Throwable s )
         {
           System.out.println("Gif for " + argv[0] + " not found." );
         }
       }
       // Disconnect from the database
       thePhotoDatastore.rollback();
       thePhotoDatastore.disconnect();

       // All done
       System.out.println();
       System.out.println("Done");
     }

       // Catch all Throwables here and print out what information we can.
       catch (Throwable s)
       {
          System.out.println( "Throwable caught:" );
          System.out.println( "message: " + s.getMessage() );
          System.out.println( "Stack Trace:" );
          s.printStackTrace();
       }
   }
}
