// Please refer to the readme on how to run this sample.

package COM.ibm.ivj.examples.database.minisamp.DB2;
import DB2gen.*;

import java.lang.*;
import java.util.*;

public class curfetch
{
   public static void main(String args[])
   {
      try
      {
         // Create the Datastore and Manager objects
         DepartmentDatastore theDepartmentDatastore = new DepartmentDatastore();
         DepartmentManager   theDeptMgr             = new DepartmentManager();

         // Connect to database
         System.out.println("Connecting to DEPARTMENT database...");
         if ( args.length > 1 )
            theDepartmentDatastore.connect( args[0], args[1] );
         else
            theDepartmentDatastore.connect();
         System.out.println("...Connected");

         System.out.println("Listing of all departments, sorted by name:");

         // Open the cursor on the entire database,
         // ordering the records by department name
         theDeptMgr.open( "ORDER BY DEPTNAME" );

         // Repeat for each row
         while( theDeptMgr.fetchNext() )
         {
            // Get the row
            Department theDept = theDeptMgr.element();

            // Print out the row
            System.out.println( theDept.toString() );
         }

         // close the cursor
         theDeptMgr.close();

         // Disconnect from the database
         theDepartmentDatastore.rollback();
         theDepartmentDatastore.disconnect();

         // All done
         System.out.println();
         System.out.println("Done");
       }

       // Catch all Throwables here and print out what information we can.
       catch (Throwable s)
       {
          System.out.println( "Throwable caught:" );
          System.out.println( "message: " + s.getMessage() );
          System.out.println( "Stack Trace:" );
          s.printStackTrace();
       }
   }
}
