/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.tool;

import com.objectshare.gf.base.GF2DGO;
import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGOArray;
import com.objectshare.gf.base.GFHandle;
import com.objectshare.gf.base.GFUnsortedGOArray;
import com.objectshare.gf.base.event.GFDrawingMouseEvent;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.connect.GF2DFinalPointPlug;
import com.objectshare.gf.connect.GF2DIndexedPointPlug;
import com.objectshare.gf.connect.GFConnector;
import com.objectshare.gf.connect.GFPlug;
import com.objectshare.gf.go.GFLineGO;
import com.objectshare.gf.tool.GFConnectionHandle;
import com.objectshare.gf.tool.GFCreationTool;
import com.objectshare.gf.tool.GFTool;
import com.objectshare.gf.tool.event.GFConnectionEndingEvent;
import com.objectshare.gf.tool.event.GFConnectionStartingEvent;
import com.objectshare.gf.tool.event.GFConnectionToolEvent;
import com.objectshare.gf.tool.event.GFConnectionToolListener;
import com.objectshare.gf.tool.event.GFCreatingGOEvent;
import com.objectshare.gf.tool.event.GFCreationToolEvent;
import com.objectshare.gf.tool.event.GFCreationToolListener;
import com.objectshare.gf.tool.event.GFToolEventMulticaster;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class GFConnectionTool
extends GFTool
implements GFCreationToolListener {
    protected GFGO defaultConnectingGO = new GFLineGO(0.0f, 0.0f, 0.0f, 0.0f);
    protected GFPlug defaultStartPlug = new GF2DIndexedPointPlug(null, 0);
    protected GFPlug defaultEndPlug = new GF2DFinalPointPlug(null);
    protected GFGO connectingGOPrototype;
    protected GFGO connectingGO;
    protected GFHandle creationHandlePrototype;
    protected GFHandle creationHandle;
    protected GFConnectionHandle startHandle;
    protected GFConnector startConnector;
    protected GFConnector endConnector;
    protected Dimension sensorExtent = new Dimension(30, 30);
    protected GFGOArray displayedConnectionHandleOwners = new GFUnsortedGOArray();
    protected GFCreationTool creationTool;
    protected GFDrawingMouseEvent mouseUp;
    protected GFConnectionToolListener connectionToolListener;

    public GFConnectionTool() {
    }

    public GFConnectionTool(GFGO gFGO) {
        this.setConnectingGO(gFGO);
    }

    public GFConnectionTool(GFGO gFGO, GFHandle gFHandle) {
        this.setConnectingGO(gFGO);
        this.setCreationHandle(gFHandle);
    }

    public GFConnectionTool(Image image) {
        this(null, null, image);
    }

    public GFConnectionTool(String string) {
        this(null, null, string);
    }

    public GFConnectionTool(GFGO gFGO, Image image) {
        this(gFGO);
        this.setImage(image);
    }

    public GFConnectionTool(GFGO gFGO, String string) {
        this(gFGO);
        this.setImage(string);
    }

    public GFConnectionTool(GFGO gFGO, GFHandle gFHandle, Image image) {
        this(gFGO, gFHandle);
        this.setImage(image);
    }

    public GFConnectionTool(GFGO gFGO, GFHandle gFHandle, String string) {
        this(gFGO, gFHandle);
        this.setImage(string);
    }

    public GFGO getConnectingGO() {
        return this.connectingGOPrototype;
    }

    public void setConnectingGO(GFGO gFGO) {
        this.connectingGOPrototype = gFGO;
    }

    public GFHandle getCreationHandle() {
        return this.creationHandlePrototype;
    }

    public void setCreationHandle(GFHandle gFHandle) {
        this.creationHandlePrototype = gFHandle;
    }

    protected void basicActivated(GFDrawingManager gFDrawingManager) {
        this.displayedConnectionHandleOwners = gFDrawingManager.getHandleLayer().getAllConnectionOwners();
    }

    protected void basicProcessMouseDown(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFConnectionHandle gFConnectionHandle = this.connectionHandleContaining(gFDrawingMouseEvent.getWorldLocation());
        if (gFConnectionHandle != null) {
            this.processMouseDownInConnectionHandle(gFConnectionHandle, gFDrawingMouseEvent);
            gFDrawingMouseEvent.setHandled(true);
        }
    }

    protected void processMouseDownInConnectionHandle(GFConnectionHandle gFConnectionHandle, GFDrawingMouseEvent gFDrawingMouseEvent) {
        this.startHandle = gFConnectionHandle;
        GFGO gFGO = this.connectingGO = this.connectingGOPrototype == null ? this.defaultConnectingGO.copyForCreation() : this.connectingGOPrototype.copyForCreation();
        this.creationHandle = this.creationHandlePrototype != null ? this.creationHandlePrototype.copyForOwner(this.connectingGO) : (this.connectingGO != null ? this.connectingGO.defaultCreationHandle() : null);
        GFConnectionStartingEvent gFConnectionStartingEvent = this.triggerConnectionStartingEvent();
        this.connectingGO = gFConnectionStartingEvent.getConnectingGO();
        this.creationHandle = gFConnectionStartingEvent.getCreationHandle();
        if (gFConnectionStartingEvent.isConnectionVetoed()) {
            return;
        }
        this.creationTool = new GFCreationTool();
        this.creationTool.addCreationToolListener(this);
        this.processMouseDownInDelegate(this.creationTool, gFDrawingMouseEvent);
        GFPlug gFPlug = gFConnectionStartingEvent.getStartPlug();
        if (gFPlug != null) {
            if (gFPlug.getTarget() != this.connectingGO) {
                gFPlug = gFPlug.copyForTarget(this.connectingGO);
            }
            this.startConnector = GFConnector.newFor(this.startHandle.getLocator(), gFPlug);
        }
    }

    public void toolCreatingGO(GFCreatingGOEvent gFCreatingGOEvent) {
        gFCreatingGOEvent.setGraphicObject(this.connectingGO);
        gFCreatingGOEvent.setCreationHandle(this.creationHandle);
    }

    public void toolCreatedGO(GFCreationToolEvent gFCreationToolEvent) {
        GFGO gFGO = gFCreationToolEvent.getGraphicObject();
        if (gFGO instanceof GF2DGO) {
            ((GF2DGO)gFGO).sendToBack();
        }
        this.triggerConnectionStartedEvent();
    }

    public void toolGOCreationCompleted(GFCreationToolEvent gFCreationToolEvent) {
        this.creationTool = null;
    }

    protected void basicProcessMouseUp(GFDrawingMouseEvent gFDrawingMouseEvent) {
        this.mouseUp = gFDrawingMouseEvent;
        GFConnectionHandle gFConnectionHandle = this.connectionHandleContaining(gFDrawingMouseEvent.getWorldLocation());
        if (gFConnectionHandle != null && this.creationTool != null && this.hasDelegate(this.creationTool)) {
            this.creationTool.complete();
        }
        gFDrawingMouseEvent.setHandled(true);
    }

    protected void completed() {
        if (this.connectingGO == null || !this.getManager().includes(this.connectingGO)) {
            this.connectingGO = null;
            return;
        }
        this.processMouseUpConnecting(this.mouseUp);
    }

    protected void processMouseUpConnecting(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFDrawingManager gFDrawingManager = this.getManager();
        GFConnectionEndingEvent gFConnectionEndingEvent = this.triggerConnectionEndingEvent(gFDrawingMouseEvent);
        boolean bl = gFConnectionEndingEvent.isConnectionVetoed();
        bl = bl || gFConnectionEndingEvent.getNumExistingConnections() >= 1;
        boolean bl2 = bl = bl || gFConnectionEndingEvent.isEqualStartEnd();
        if (bl) {
            gFDrawingManager.remove(this.connectingGO);
        } else if (!gFConnectionEndingEvent.isConnectionDenied()) {
            GFConnectionHandle gFConnectionHandle = gFConnectionEndingEvent.getConnectionEndHandle();
            GFPlug gFPlug = gFConnectionEndingEvent.getEndPlug();
            if (gFPlug.getTarget() != this.connectingGO) {
                gFPlug = gFPlug.copyForTarget(this.connectingGO);
            }
            this.endConnector = GFConnector.newFor(gFConnectionHandle.getLocator(), gFPlug);
        }
        if (this.creationHandle != null) {
            gFDrawingManager.remove(this.creationHandle);
            this.creationHandle = null;
        }
        if (!bl) {
            this.triggerConnectionEndedEvent();
        }
        this.connectingGO = null;
        this.startHandle = null;
        this.startConnector = null;
        this.endConnector = null;
    }

    public void basicProcessMouseMove(GFDrawingMouseEvent gFDrawingMouseEvent) {
        this.displayNeighboringConnectionHandles(gFDrawingMouseEvent.getViewLocation(), true);
        gFDrawingMouseEvent.setHandled(true);
    }

    public void basicProcessMouseDrag(GFDrawingMouseEvent gFDrawingMouseEvent) {
        this.displayNeighboringConnectionHandles(gFDrawingMouseEvent.getViewLocation(), false);
        gFDrawingMouseEvent.setHandled(true);
    }

    public void displayNeighboringConnectionHandles(Point point, boolean bl) {
        GFDrawingManager gFDrawingManager = this.getManager();
        Rectangle rectangle = new Rectangle(point.x - this.sensorExtent.width / 2, point.y - this.sensorExtent.height / 2, this.sensorExtent.width, this.sensorExtent.height);
        GF2DRectangle gF2DRectangle = gFDrawingManager.getWorldViewTransform().view2World(rectangle);
        GFGOArray gFGOArray = gFDrawingManager.getHandleLayer().getAllConnectionOwners();
        GFGOArray gFGOArray2 = gFDrawingManager.graphicObjectsIntersecting(gF2DRectangle);
        gFGOArray2.addAllOnce(this.displayedConnectionHandleOwners);
        gFDrawingManager.getHandleLayer().removeAllFor(gFGOArray.subtract(gFGOArray2));
        GFGOArray gFGOArray3 = gFGOArray2.subtract(gFGOArray);
        int n = 0;
        while (n < gFGOArray3.size()) {
            if (bl) {
                gFDrawingManager.addAll(gFGOArray3.elementAt(n).getStartConnectionHandles());
            } else {
                gFDrawingManager.addAll(gFGOArray3.elementAt(n).getEndConnectionHandles());
            }
            ++n;
        }
    }

    public void addConnectionToolListener(GFConnectionToolListener gFConnectionToolListener) {
        this.connectionToolListener = GFToolEventMulticaster.add(this.connectionToolListener, gFConnectionToolListener);
    }

    public void removeConnectionToolListener(GFConnectionToolListener gFConnectionToolListener) {
        this.connectionToolListener = GFToolEventMulticaster.remove(this.connectionToolListener, gFConnectionToolListener);
    }

    public GFConnectionStartingEvent triggerConnectionStartingEvent() {
        GFConnectionStartingEvent gFConnectionStartingEvent = new GFConnectionStartingEvent(this, this.startHandle, this.connectingGO, this.creationHandle, this.defaultStartPlug);
        GFConnectionToolListener gFConnectionToolListener = this.connectionToolListener;
        if (gFConnectionToolListener != null) {
            gFConnectionToolListener.toolConnectionStarting(gFConnectionStartingEvent);
        }
        return gFConnectionStartingEvent;
    }

    public void triggerConnectionStartedEvent() {
        GFConnectionToolListener gFConnectionToolListener = this.connectionToolListener;
        if (gFConnectionToolListener != null) {
            gFConnectionToolListener.toolConnectionStarted(new GFConnectionToolEvent(this, this.connectingGO));
        }
    }

    public GFConnectionEndingEvent triggerConnectionEndingEvent(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GF2DPoint gF2DPoint = gFDrawingMouseEvent.getWorldLocation();
        GFGO gFGO = this.connectionHandleContaining(gF2DPoint);
        if (gFGO == null) {
            gFGO = this.graphicObjectContaining(gF2DPoint);
        }
        GFConnectionEndingEvent gFConnectionEndingEvent = new GFConnectionEndingEvent(this, gFDrawingMouseEvent, this.startConnector, this.connectingGO, gFGO, this.defaultEndPlug);
        GFConnectionToolListener gFConnectionToolListener = this.connectionToolListener;
        if (gFConnectionToolListener != null) {
            gFConnectionToolListener.toolConnectionEnding(gFConnectionEndingEvent);
        }
        return gFConnectionEndingEvent;
    }

    public void triggerConnectionEndedEvent() {
        GFConnectionToolListener gFConnectionToolListener = this.connectionToolListener;
        if (gFConnectionToolListener != null) {
            gFConnectionToolListener.toolConnectionEnded(new GFConnectionToolEvent(this, this.connectingGO));
        }
    }
}

