/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.go;

import com.objectshare.gf.base.GF2DWorldViewTransform;
import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGOArray;
import com.objectshare.gf.base.GFGraphics;
import com.objectshare.gf.base.GFHandle;
import com.objectshare.gf.base.GFUnsortedGOArray;
import com.objectshare.gf.base.geometry.GF2DMatrix;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DPolygon;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.base.geometry.GF2DVector;
import com.objectshare.gf.connect.GF2DIndexedPointLocator;
import com.objectshare.gf.go.GF2DIndexedPointGO;
import com.objectshare.gf.go.GFAbstractPathGO;
import com.objectshare.gf.go.lineend.GFAbstractLineEnd;
import com.objectshare.gf.go.lineend.GFLineEnd;
import com.objectshare.gf.tool.GF2DPointHandle;
import com.objectshare.gf.tool.GFPolylineCreationHandle;
import java.awt.Color;
import java.awt.Polygon;
import java.util.Vector;

public class GFPolylineGO
extends GFAbstractPathGO
implements GF2DIndexedPointGO {
    protected boolean closed;
    protected Color fillColor;
    protected GF2DPolygon polygon;
    protected GF2DPolygon displayedPolygon;
    protected GFLineEnd[] lineEnds = new GFLineEnd[2];

    protected GFPolylineGO() {
    }

    public GFPolylineGO(GF2DPolygon gF2DPolygon) {
        this.fillColor = null;
        this.basicSetPolygon(gF2DPolygon);
    }

    public GFPolylineGO(Polygon polygon) {
        this(new GF2DPolygon(polygon));
    }

    public GFPolylineGO(GF2DPoint[] gF2DPointArray) {
        this(new GF2DPolygon(gF2DPointArray));
    }

    public GFPolylineGO(GF2DPoint[] gF2DPointArray, int n) {
        this(new GF2DPolygon(gF2DPointArray, n));
    }

    public GFPolylineGO(Vector vector) {
        this(new GF2DPolygon(vector));
    }

    public GFPolylineGO(GF2DPoint gF2DPoint, GF2DPoint gF2DPoint2) {
        this(new GF2DPolygon(gF2DPoint, gF2DPoint2));
    }

    public GFGO copyForCreation() {
        return this.copyForCreationInto(new GFPolylineGO());
    }

    protected GFGO copyForCreationInto(GFGO gFGO) {
        super.copyForCreationInto(gFGO);
        GFPolylineGO gFPolylineGO = (GFPolylineGO)gFGO;
        gFPolylineGO.closed = this.closed;
        gFPolylineGO.fillColor = this.fillColor;
        gFPolylineGO.basicSetPolygon(this.polygon);
        if (this.lineEnds[0] != null) {
            gFPolylineGO.setLineEnd(0, this.lineEnds[0].copyForLine());
        }
        if (this.lineEnds[1] != null) {
            gFPolylineGO.setLineEnd(-1, this.lineEnds[1].copyForLine());
        }
        return gFGO;
    }

    public void basicSetManager(GFDrawingManager gFDrawingManager) {
        super.basicSetManager(gFDrawingManager);
        int n = 0;
        while (n < this.lineEnds.length) {
            if (this.lineEnds[n] != null) {
                this.lineEnds[n].basicSetManager(gFDrawingManager);
            }
            ++n;
        }
    }

    public void basicSetAllManagerAttributes(GFDrawingManager gFDrawingManager) {
        super.basicSetAllManagerAttributes(gFDrawingManager);
        int n = 0;
        while (n < this.lineEnds.length) {
            if (this.lineEnds[n] != null) {
                this.lineEnds[n].basicSetAllManagerAttributes(gFDrawingManager);
            }
            ++n;
        }
    }

    protected void basicSetFillColor(Color color) {
        this.fillColor = color;
    }

    public Color getBorderColor() {
        return this.getColor();
    }

    public int getBorderWidth() {
        return this.getWidth();
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setBorderColor(Color color) {
        this.setColor(color);
    }

    public void setBorderWidth(int n) {
        this.setWidth(n);
    }

    public void setFillColor(Color color) {
        this.beginDamage();
        this.basicSetFillColor(color);
        this.endDamage();
    }

    public void setLineEnd(int n, GFLineEnd gFLineEnd) {
        int n2;
        this.beginDamage();
        int n3 = n2 = GFAbstractLineEnd.getEndPointForIndex(this, n) == 0 ? 0 : 1;
        if (this.lineEnds[n2] != null) {
            this.lineEnds[n2].basicSetLine(null, 0);
        }
        this.lineEnds[n2] = gFLineEnd;
        if (gFLineEnd != null) {
            gFLineEnd.basicSetLine(this, GFAbstractLineEnd.getIndexForEndPoint(this, n));
        }
        this.basicSetPolygon(this.polygon);
        this.endDamage();
    }

    public GFLineEnd getLineEnd(int n) {
        int n2 = GFAbstractLineEnd.getEndPointForIndex(this, n) == 0 ? 0 : 1;
        return this.lineEnds[n2];
    }

    public boolean isLineEndsVisible() {
        return !this.isClosed() && this.getNumPoints() >= 2;
    }

    public void setLineEndAttachment(int n, GF2DPoint gF2DPoint) {
        if (!this.isLineEndsVisible()) {
            return;
        }
        int n2 = GFAbstractLineEnd.getIndexForEndPoint(this, n);
        this.displayedPolygon = this.polygon.setPoint(n2, gF2DPoint);
    }

    public void display(GFGraphics gFGraphics) {
        Color color = this.getFillColor();
        if (this.isClosed() && color != null) {
            gFGraphics.setColor(color);
            gFGraphics.fillPolygon(this.displayedPolygon);
        }
        gFGraphics.setColor(this.getBorderColor());
        gFGraphics.drawPolygon(this.displayedPolygon);
        if (this.isLineEndsVisible()) {
            int n = 0;
            while (n < this.lineEnds.length) {
                if (this.lineEnds[n] != null) {
                    this.lineEnds[n].display(gFGraphics);
                }
                ++n;
            }
        }
    }

    public void displayShape(GFGraphics gFGraphics) {
        gFGraphics.setColor(Color.black);
        if (this.isClosed() && this.getFillColor() != null) {
            gFGraphics.fillPolygon(this.displayedPolygon);
        }
        gFGraphics.drawPolygon(this.displayedPolygon);
        if (this.isLineEndsVisible()) {
            int n = 0;
            while (n < this.lineEnds.length) {
                if (this.lineEnds[n] != null) {
                    this.lineEnds[n].displayShape(gFGraphics);
                }
                ++n;
            }
        }
    }

    protected boolean checkClosed() {
        this.closed = this.polygon.getNumPoints() < 3 ? false : this.polygon.points[0].equals(this.polygon.points[this.polygon.getNumPoints() - 1]);
        return this.closed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void makeClosed() {
        if (this.polygon.getNumPoints() < 1 || this.isClosed()) {
            return;
        }
        this.beginDamage();
        this.polygon = this.polygon.addPoint(new GF2DPoint(this.polygon.points[0]));
        this.checkClosed();
        this.basicSetPolygon(this.polygon);
        this.endDamage();
    }

    public void makeOpen() {
        if (!this.isClosed() || this.polygon.getNumPoints() < 3) {
            return;
        }
        this.beginDamage();
        this.polygon = new GF2DPolygon(this.polygon.points, this.polygon.getNumPoints() - 1);
        this.checkClosed();
        this.basicSetPolygon(this.polygon);
        this.endDamage();
    }

    public int getNumPoints() {
        return this.polygon.getNumPoints();
    }

    public GF2DPoint getPoint(int n) {
        if (n < 0 || n >= this.polygon.getNumPoints()) {
            throw new IndexOutOfBoundsException("Invalid point index " + n + " for polygon: " + this.polygon);
        }
        return this.polygon.points[n];
    }

    public void setPoint(int n, GF2DPoint gF2DPoint) {
        GF2DPolygon gF2DPolygon = this.polygon.setPoint(n, gF2DPoint);
        this.beginDamage();
        if (this.closed) {
            int n2 = this.polygon.getNumPoints() - 1;
            if (n == 0) {
                gF2DPolygon = gF2DPolygon.setPoint(n2, new GF2DPoint(gF2DPoint));
            } else if (n == n2) {
                gF2DPolygon = gF2DPolygon.setPoint(0, new GF2DPoint(gF2DPoint));
            }
        }
        this.basicSetPolygon(gF2DPolygon);
        this.endDamage();
        this.triggerReshapedEvent();
    }

    protected void basicSetPolygon(GF2DPolygon gF2DPolygon) {
        this.polygon = gF2DPolygon;
        this.displayedPolygon = gF2DPolygon;
        this.checkClosed();
        if (this.isLineEndsVisible()) {
            int n = 0;
            while (n < this.lineEnds.length) {
                if (this.lineEnds[n] != null) {
                    this.lineEnds[n].lineChanged();
                }
                ++n;
            }
        }
    }

    public void setPolygon(GF2DPolygon gF2DPolygon) {
        this.beginDamage();
        this.basicSetPolygon(gF2DPolygon);
        this.endDamage();
        this.triggerReshapedEvent();
    }

    public GF2DPolygon getPolygon() {
        return this.polygon;
    }

    public GF2DRectangle displayBox() {
        GF2DRectangle gF2DRectangle = this.displayedPolygon.getBoundingBox();
        if (this.isLineEndsVisible()) {
            int n = 0;
            while (n < this.lineEnds.length) {
                if (this.lineEnds[n] != null) {
                    gF2DRectangle = gF2DRectangle.union(this.lineEnds[n].displayBox());
                }
                ++n;
            }
        }
        return gF2DRectangle;
    }

    public boolean containsPoint(GF2DPoint gF2DPoint) {
        if (this.isLineEndsVisible()) {
            int n = 0;
            while (n < this.lineEnds.length) {
                if (this.lineEnds[n] != null && this.lineEnds[n].containsPoint(gF2DPoint)) {
                    return true;
                }
                ++n;
            }
        }
        if (this.isClosed() && this.fillColor != null && this.polygon.inside(gF2DPoint)) {
            return true;
        }
        GF2DWorldViewTransform gF2DWorldViewTransform = this.getWorldViewTransform();
        GF2DPoint gF2DPoint2 = new GF2DPoint(gF2DWorldViewTransform.world2View(gF2DPoint));
        int n = 0;
        while (n < this.polygon.getNumPoints()) {
            int n2 = n == this.polygon.getNumPoints() - 1 ? 0 : n + 1;
            GF2DVector gF2DVector = new GF2DVector(gF2DWorldViewTransform.world2View(this.displayedPolygon.points[n]), gF2DWorldViewTransform.world2View(this.displayedPolygon.points[n2]));
            if (gF2DVector.includes(gF2DPoint2, 4.0f)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean intersects(GF2DRectangle gF2DRectangle) {
        int n = 0;
        while (n < this.polygon.getNumPoints()) {
            int n2 = n == this.polygon.getNumPoints() - 1 ? 0 : n + 1;
            GF2DVector gF2DVector = new GF2DVector(this.polygon.points[n], this.polygon.points[n2]);
            if (gF2DVector.liangBarskyClipTo(gF2DRectangle) != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public float getTangentialTheta(int n, int n2) {
        GF2DPoint gF2DPoint;
        GF2DPoint gF2DPoint2 = this.getPoint(n);
        if (n2 == 0) {
            if (n == 0) {
                throw new IllegalArgumentException();
            }
            gF2DPoint = this.getPoint(n - 1);
        } else {
            if (n >= this.getNumPoints() - 1) {
                throw new IllegalArgumentException();
            }
            gF2DPoint = this.getPoint(n + 1);
        }
        GF2DPoint gF2DPoint3 = gF2DPoint.subtract(gF2DPoint2);
        return (float)Math.atan2(gF2DPoint3.y, gF2DPoint3.x);
    }

    public boolean basicReshape(float f, float f2, float f3, float f4) {
        if (this.polygon.getNumPoints() < 1) {
            return false;
        }
        GF2DRectangle gF2DRectangle = this.displayBox();
        float f5 = f3 / gF2DRectangle.width;
        float f6 = f - f5 * gF2DRectangle.x;
        float f7 = f4 / gF2DRectangle.height;
        float f8 = f2 - f7 * gF2DRectangle.y;
        GF2DPoint[] gF2DPointArray = new GF2DPoint[this.polygon.getNumPoints()];
        int n = 0;
        while (n < this.polygon.getNumPoints()) {
            gF2DPointArray[n] = new GF2DPoint(f6 + this.polygon.points[n].x * f5, f8 + this.polygon.points[n].y * f7);
            ++n;
        }
        this.basicSetPolygon(new GF2DPolygon(gF2DPointArray));
        return true;
    }

    public boolean basicTranslate(float f, float f2) {
        if (this.polygon.getNumPoints() < 1) {
            return false;
        }
        this.basicSetPolygon(this.polygon.translateBy(f, f2));
        return true;
    }

    public boolean basicRotate(float f, GF2DPoint gF2DPoint) {
        GF2DMatrix gF2DMatrix = gF2DPoint.x == 0.0f && gF2DPoint.y == 0.0f ? GF2DMatrix.rotation(f) : GF2DMatrix.translation(-gF2DPoint.x, -gF2DPoint.y).multiply(GF2DMatrix.rotation(f)).multiply(GF2DMatrix.translation(gF2DPoint.x, gF2DPoint.y));
        GF2DPoint[] gF2DPointArray = new GF2DPoint[this.polygon.points.length];
        int n = 0;
        while (n < this.polygon.points.length) {
            gF2DPointArray[n] = gF2DMatrix.multiply(this.polygon.points[n]);
            ++n;
        }
        this.basicSetPolygon(new GF2DPolygon(gF2DPointArray));
        return true;
    }

    public GFGOArray defaultHandles() {
        int n = this.isClosed() ? this.getNumPoints() - 1 : this.getNumPoints();
        GFUnsortedGOArray gFUnsortedGOArray = new GFUnsortedGOArray(n);
        int n2 = 0;
        while (n2 < n) {
            gFUnsortedGOArray.add(new GF2DPointHandle(new GF2DIndexedPointLocator(this, n2, 0.0f, 0.0f), n2, 1.0f, 1.0f));
            ++n2;
        }
        return gFUnsortedGOArray;
    }

    public GFHandle defaultCreationHandle() {
        return new GFPolylineCreationHandle(this);
    }

    public GFGOArray defaultConnectionHandles() {
        if (this.isClosed()) {
            return super.defaultConnectionHandles();
        }
        return new GFUnsortedGOArray();
    }
}

