/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.example.howto.swapdrawings;

import com.objectshare.base.example.OSIExampleApplet;
import com.objectshare.base.example.OSIExampleFrame;
import com.objectshare.gf.base.GFDrawing;
import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.example.howto.HowTo;
import com.objectshare.gf.go.GFTextGO;
import com.objectshare.gf.tool.GFToolCategory;
import com.objectshare.gf.tool.GFToolPalette;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

public class SwapDrawings
extends HowTo {
    protected int numberOfDrawings = 3;
    protected GFDrawing[] drawings;

    protected void preInit() {
        HowTo.frameInset = 5;
    }

    protected void initDrawing(GFDrawingManager gFDrawingManager) {
        this.drawings = new GFDrawing[this.numberOfDrawings];
        this.drawings[0] = gFDrawingManager.getDrawing();
        int n = 1;
        while (n < this.numberOfDrawings) {
            this.drawings[n] = new GFDrawing();
            ++n;
        }
    }

    protected void postInit(GFDrawingManager gFDrawingManager) {
        super.postInit(gFDrawingManager);
        GF2DPoint gF2DPoint = gFDrawingManager.getWorldPort().center();
        int n = 0;
        while (n < this.numberOfDrawings) {
            GFTextGO gFTextGO = new GFTextGO("Drawing #" + (n + 1));
            gFTextGO.translateCenter(gF2DPoint);
            this.drawings[n].getPrimaryLayer().add(gFTextGO);
            ++n;
        }
    }

    public void initPalette(GFToolPalette gFToolPalette) {
        gFToolPalette.addCategory(this.createSelectionTools());
        GFToolCategory gFToolCategory = this.createShapeGOTools();
        gFToolCategory.addTool(this.createLineTool());
        gFToolPalette.addCategory(gFToolCategory);
    }

    protected String getHowtoPath() {
        return "../";
    }

    protected void initRightControls(Panel panel) {
        panel.setLayout(new GridLayout(this.numberOfDrawings + 1, 1));
        panel.add(new Label("Drawing"));
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        int n = 1;
        while (n <= this.numberOfDrawings) {
            panel.add(new Checkbox("#" + n, checkboxGroup, n == 1));
            ++n;
        }
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Checkbox) {
            String string = ((Checkbox)event.target).getLabel().substring(1);
            int n = Integer.parseInt(string) - 1;
            this.getManager().setDrawing(this.drawings[n]);
            this.getManager().redraw();
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        SwapDrawings swapDrawings = new SwapDrawings();
        new OSIExampleFrame((OSIExampleApplet)swapDrawings, ((Object)((Object)swapDrawings)).getClass().getName(), 550, 350);
    }
}

