/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.example.draw;

import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DPolygon;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.go.GFPolylineGO;
import java.awt.Polygon;
import java.util.Date;
import java.util.Random;
import java.util.Vector;

public class AnimatedPolylineGO
extends GFPolylineGO
implements Runnable {
    public boolean debugExceptions = true;
    protected Random rand = new Random();
    protected long nextMove;
    protected long nextRandomize;
    protected float[] xDeltas;
    protected float[] yDeltas;

    protected AnimatedPolylineGO() {
    }

    public AnimatedPolylineGO(GF2DPolygon gF2DPolygon) {
        super(gF2DPolygon);
    }

    public AnimatedPolylineGO(Polygon polygon) {
        super(polygon);
    }

    public AnimatedPolylineGO(GF2DPoint[] gF2DPointArray) {
        super(gF2DPointArray);
    }

    public AnimatedPolylineGO(GF2DPoint[] gF2DPointArray, int n) {
        super(gF2DPointArray, n);
    }

    public AnimatedPolylineGO(Vector vector) {
        super(vector);
    }

    public AnimatedPolylineGO(GF2DPoint gF2DPoint, GF2DPoint gF2DPoint2) {
        super(gF2DPoint, gF2DPoint2);
    }

    public GFGO copyForCreation() {
        return this.copyForCreationInto(new AnimatedPolylineGO());
    }

    public synchronized void makeClosed() {
        super.makeClosed();
        this.redimDeltas();
    }

    public synchronized void makeOpen() {
        super.makeOpen();
        this.redimDeltas();
    }

    public synchronized void setPoint(int n, GF2DPoint gF2DPoint) {
        this.pausePoint(n);
        super.setPoint(n, gF2DPoint);
    }

    protected synchronized void basicSetPolygon(GF2DPolygon gF2DPolygon) {
        super.basicSetPolygon(gF2DPolygon);
        this.redimDeltas();
    }

    public synchronized boolean basicReshape(float f, float f2, float f3, float f4) {
        this.pause();
        return super.basicReshape(f, f2, f3, f4);
    }

    public synchronized boolean basicTranslate(float f, float f2) {
        this.pause();
        return super.basicTranslate(f, f2);
    }

    public synchronized boolean basicRotate(float f, GF2DPoint gF2DPoint) {
        this.pause();
        return super.basicRotate(f, gF2DPoint);
    }

    protected void basicRun() {
        this.nextMove = new Date().getTime();
        this.nextRandomize = new Date().getTime();
        this.redimDeltas();
        this.randomizeAll();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.move());
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void run() {
        if (this.debugExceptions) {
            try {
                this.basicRun();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        this.basicRun();
    }

    protected float randomDelta(float f) {
        float f2 = f / 15.0f;
        return this.rand.nextFloat() * f2 - f2 / 2.0f;
    }

    protected void redimDeltas() {
        int n;
        int n2 = this.polygon.getNumPoints();
        if (this.xDeltas == null) {
            this.xDeltas = new float[n2];
            this.yDeltas = new float[n2];
        }
        if (n2 == (n = this.xDeltas.length)) {
            return;
        }
        n = Math.min(n, n2);
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n2];
        System.arraycopy(this.xDeltas, 0, fArray, 0, n);
        System.arraycopy(this.yDeltas, 0, fArray2, 0, n);
        this.xDeltas = fArray;
        this.yDeltas = fArray2;
    }

    protected void randomizeAll() {
        float f;
        float f2;
        int n = this.getNumPoints();
        if (this.getManager() != null) {
            f2 = this.getManager().getWorldPort().width;
            f = this.getManager().getWorldPort().height;
        } else {
            f2 = 400.0f;
            f = 400.0f;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.xDeltas[n2] == 0.0f) {
                this.xDeltas[n2] = this.randomDelta(f2);
            }
            if (this.yDeltas[n2] == 0.0f) {
                this.yDeltas[n2] = this.randomDelta(f);
            }
            ++n2;
        }
    }

    protected synchronized long move() {
        long l = new Date().getTime();
        if (this.nextMove - l > 0L) {
            return this.nextMove - l;
        }
        if (this.nextRandomize - l <= 0L) {
            this.randomizeAll();
        }
        this.movePolygon(this.getWorldViewTransform().getWorldPort());
        GFDrawingManager gFDrawingManager = this.getManager();
        if (gFDrawingManager != null) {
            gFDrawingManager.redraw();
        }
        return 50L;
    }

    public void movePolygon(GF2DRectangle gF2DRectangle) {
        new Random();
        GF2DPoint[] gF2DPointArray = new GF2DPoint[this.polygon.getNumPoints()];
        int n = 0;
        while (n < gF2DPointArray.length) {
            float f;
            float f2 = this.polygon.points[n].x + this.xDeltas[n];
            if (f2 < gF2DRectangle.left()) {
                f2 = gF2DRectangle.left();
                this.xDeltas[n] = Math.abs(this.randomDelta(gF2DRectangle.width));
            }
            if (f2 > gF2DRectangle.right()) {
                f2 = gF2DRectangle.right();
                this.xDeltas[n] = -Math.abs(this.randomDelta(gF2DRectangle.width));
            }
            if ((f = this.polygon.points[n].y + this.yDeltas[n]) < gF2DRectangle.top()) {
                f = gF2DRectangle.top();
                this.yDeltas[n] = Math.abs(this.randomDelta(gF2DRectangle.height));
            }
            if (f > gF2DRectangle.bottom()) {
                f = gF2DRectangle.bottom();
                this.yDeltas[n] = -Math.abs(this.randomDelta(gF2DRectangle.height));
            }
            gF2DPointArray[n] = new GF2DPoint(f2, f);
            ++n;
        }
        if (this.isClosed()) {
            gF2DPointArray[gF2DPointArray.length - 1] = new GF2DPoint(gF2DPointArray[0]);
        }
        this.setPolygon(new GF2DPolygon(gF2DPointArray));
    }

    protected synchronized void pause() {
        this.nextMove = new Date().getTime() + 6000L;
    }

    protected synchronized void pausePoint(int n) {
        if (n >= 0 && n < this.polygon.getNumPoints()) {
            this.xDeltas[n] = 0.0f;
            this.yDeltas[n] = 0.0f;
        }
        this.nextMove = new Date().getTime();
        this.nextRandomize = this.nextMove + 3000L;
    }
}

