/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.base;

import com.objectshare.gf.base.GF2DGO;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGOArray;
import com.objectshare.gf.base.GFGOContainer;
import com.objectshare.gf.base.GFGOLinkedListEnumerator;
import com.objectshare.gf.base.GFGOList;
import com.objectshare.gf.base.GFGOParent;
import com.objectshare.gf.base.GFSortedGOArray;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import java.util.Enumeration;

public class GFGOLinkedList
extends GFGOList {
    protected GF2DGO firstGO;
    protected GF2DGO lastGO;
    protected int zOrderStatus = 0;
    protected static final int Z_ORDER_VALID = 0;
    protected static final int Z_ORDER_SORTED = 1;
    protected static final int Z_ORDER_UNSORTED = 2;

    public GFGOLinkedList(GFGOContainer gFGOContainer) {
        super(gFGOContainer);
    }

    public GFGOArray toArray() {
        GFSortedGOArray gFSortedGOArray = new GFSortedGOArray();
        this.sortZOrder();
        GF2DGO gF2DGO = this.firstGO;
        while (gF2DGO != null) {
            gFSortedGOArray.add(gF2DGO);
            gF2DGO = gF2DGO.getNextGO();
        }
        return gFSortedGOArray;
    }

    public Enumeration elements() {
        return new GFGOLinkedListEnumerator(this);
    }

    public GF2DGO firstGO() {
        return this.firstGO;
    }

    public GF2DGO lastGO() {
        return this.lastGO;
    }

    public GFGO elementContaining(GF2DPoint gF2DPoint) {
        GF2DGO gF2DGO = this.lastGO;
        while (gF2DGO != null) {
            GFGO gFGO = gF2DGO.graphicObjectContaining(gF2DPoint);
            if (gFGO != null) {
                return gFGO;
            }
            gF2DGO = gF2DGO.getPrevGO();
        }
        return null;
    }

    public GFGOArray elementsContaining(GF2DPoint gF2DPoint) {
        GFSortedGOArray gFSortedGOArray = new GFSortedGOArray();
        this.sortZOrder();
        GF2DGO gF2DGO = this.firstGO;
        while (gF2DGO != null) {
            gFSortedGOArray.addAll(gF2DGO.graphicObjectsContaining(gF2DPoint));
            gF2DGO = gF2DGO.getNextGO();
        }
        return gFSortedGOArray;
    }

    public GFGOArray elementsIntersecting(GF2DRectangle gF2DRectangle) {
        GFSortedGOArray gFSortedGOArray = new GFSortedGOArray();
        this.sortZOrder();
        GF2DGO gF2DGO = this.firstGO;
        while (gF2DGO != null) {
            gFSortedGOArray.addAll(gF2DGO.graphicObjectsIntersecting(gF2DRectangle));
            gF2DGO = gF2DGO.getNextGO();
        }
        return gFSortedGOArray;
    }

    public GFGOArray elementsIntersectingDisplay(GF2DRectangle gF2DRectangle) {
        GFSortedGOArray gFSortedGOArray = new GFSortedGOArray();
        this.sortZOrder();
        GF2DGO gF2DGO = this.firstGO;
        while (gF2DGO != null) {
            if (gF2DGO.intersectsDisplay(gF2DRectangle)) {
                gFSortedGOArray.add(gF2DGO);
            }
            gF2DGO = gF2DGO.getNextGO();
        }
        return gFSortedGOArray;
    }

    public GFGOArray elementsContainedBy(GF2DRectangle gF2DRectangle) {
        GFSortedGOArray gFSortedGOArray = new GFSortedGOArray();
        this.sortZOrder();
        GF2DGO gF2DGO = this.firstGO;
        while (gF2DGO != null) {
            if (gF2DGO.containedBy(gF2DRectangle)) {
                gFSortedGOArray.add(gF2DGO);
            }
            gF2DGO = gF2DGO.getNextGO();
        }
        return gFSortedGOArray;
    }

    public void releaseElementResources() {
        GF2DGO gF2DGO = this.firstGO;
        while (gF2DGO != null) {
            gF2DGO.releaseAllResources();
            gF2DGO = gF2DGO.getNextGO();
        }
    }

    public void addFirst(GF2DGO gF2DGO) {
        this.linkBefore(gF2DGO, this.firstGO);
    }

    public void addLast(GF2DGO gF2DGO) {
        this.linkAfter(gF2DGO, this.lastGO);
    }

    protected void addBefore(GF2DGO gF2DGO, GF2DGO gF2DGO2) {
        if (gF2DGO2 == null || this.getContainer().isContainerFor(gF2DGO2)) {
            this.linkBefore(gF2DGO, gF2DGO2);
        }
    }

    protected void addAfter(GF2DGO gF2DGO, GF2DGO gF2DGO2) {
        if (gF2DGO2 == null || this.getContainer().isContainerFor(gF2DGO2)) {
            this.linkAfter(gF2DGO, gF2DGO2);
        }
    }

    protected boolean remove(GF2DGO gF2DGO) {
        if (gF2DGO != null && this.getContainer().isContainerFor(gF2DGO)) {
            this.basicUnlink(gF2DGO);
            return true;
        }
        return false;
    }

    protected void linkAfter(GF2DGO gF2DGO, GF2DGO gF2DGO2) {
        if (gF2DGO != null) {
            this.link(gF2DGO, gF2DGO2);
        }
    }

    protected void linkBefore(GF2DGO gF2DGO, GF2DGO gF2DGO2) {
        if (gF2DGO != null) {
            if (gF2DGO2 != null) {
                this.link(gF2DGO, gF2DGO2.getPrevGO());
                return;
            }
            this.link(gF2DGO, this.lastGO);
        }
    }

    protected void link(GF2DGO gF2DGO, GF2DGO gF2DGO2) {
        if (gF2DGO == gF2DGO2) {
            return;
        }
        if (this.getContainer().isContainerFor(gF2DGO) && gF2DGO.getPrevGO() == gF2DGO2) {
            return;
        }
        GFGOLinkedList.unlink(gF2DGO);
        this.basicLink(gF2DGO, gF2DGO2);
    }

    protected void basicLink(GF2DGO gF2DGO, GF2DGO gF2DGO2) {
        gF2DGO.basicSetParent(this.container);
        gF2DGO.basicSetPrevGO(gF2DGO2);
        gF2DGO.basicSetNextGO(gF2DGO2 != null ? gF2DGO2.getNextGO() : this.firstGO);
        if (gF2DGO.getPrevGO() != null) {
            gF2DGO.getPrevGO().basicSetNextGO(gF2DGO);
        } else {
            this.firstGO = gF2DGO;
        }
        if (gF2DGO.getNextGO() != null) {
            gF2DGO.getNextGO().basicSetPrevGO(gF2DGO);
        } else {
            this.lastGO = gF2DGO;
        }
        if (this.zOrderStatus != 2) {
            if (gF2DGO == this.lastGO) {
                if (gF2DGO == this.firstGO) {
                    gF2DGO.basicSetZOrderIndex(0.0f);
                    return;
                }
                gF2DGO.basicSetZOrderIndex(gF2DGO.getPrevGO().getZOrderIndex() + 1.0f);
                return;
            }
            if (gF2DGO == this.firstGO) {
                gF2DGO.basicSetZOrderIndex(gF2DGO.getNextGO().getZOrderIndex() - 1.0f);
                this.zOrderStatus = 1;
                return;
            }
            this.zOrderStatus = 2;
        }
    }

    protected static void unlink(GF2DGO gF2DGO) {
        GFGOParent gFGOParent = gF2DGO.getParent();
        if (gFGOParent != null) {
            gFGOParent.basicRemove(gF2DGO);
        }
    }

    protected void basicUnlink(GF2DGO gF2DGO) {
        if (this.zOrderStatus != 2 && gF2DGO != this.lastGO) {
            this.zOrderStatus = 1;
        }
        if (gF2DGO.getNextGO() != null) {
            gF2DGO.getNextGO().basicSetPrevGO(gF2DGO.getPrevGO());
        }
        if (gF2DGO.getPrevGO() != null) {
            gF2DGO.getPrevGO().basicSetNextGO(gF2DGO.getNextGO());
        }
        if (this.lastGO == gF2DGO) {
            this.lastGO = gF2DGO.getPrevGO();
        }
        if (this.firstGO == gF2DGO) {
            this.firstGO = gF2DGO.getNextGO();
        }
        gF2DGO.basicSetNextGO(null);
        gF2DGO.basicSetPrevGO(null);
        gF2DGO.basicSetParent(null);
        if (this.firstGO == null) {
            this.zOrderStatus = 0;
        }
    }

    protected void validateZOrder() {
        if (this.zOrderStatus != 0) {
            this.updateZOrder();
        }
    }

    protected void sortZOrder() {
        if (this.zOrderStatus == 2) {
            this.updateZOrder();
        }
    }

    protected void updateZOrder() {
        int n = 0;
        GF2DGO gF2DGO = this.firstGO;
        while (gF2DGO != null) {
            gF2DGO.basicSetZOrderIndex(n++);
            gF2DGO = gF2DGO.getNextGO();
        }
        this.zOrderStatus = 0;
    }
}

