/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.base;

import com.objectshare.gf.base.geometry.GF2DDimension;
import com.objectshare.gf.base.geometry.GF2DMatrix;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;

public class GF2DWorldViewTransform
implements Serializable {
    protected GF2DRectangle worldPort = new GF2DRectangle(0.0f, 0.0f, 10.0f, 10.0f);
    protected Rectangle viewPort = new Rectangle(0, 0, 10, 10);
    protected GF2DMatrix world2ViewMatrix;
    protected GF2DMatrix view2WorldMatrix;
    protected GF2DMatrix world2ViewScale;
    protected GF2DMatrix view2WorldScale;
    protected boolean unity;

    public GF2DWorldViewTransform() {
        this.computeMatrices();
    }

    public Rectangle getViewPort() {
        return this.viewPort;
    }

    public GF2DRectangle getWorldPort() {
        return this.worldPort;
    }

    public void setViewPort(Rectangle rectangle) {
        this.viewPort = rectangle;
        this.computeMatrices();
    }

    public void setViewPort(int n, int n2, int n3, int n4) {
        this.setViewPort(new Rectangle(n, n2, n3, n4));
    }

    public void setWorldPort(GF2DRectangle gF2DRectangle) {
        this.worldPort = gF2DRectangle;
        this.computeMatrices();
    }

    public void setWorldPort(float f, float f2, float f3, float f4) {
        this.setWorldPort(new GF2DRectangle(f, f2, f3, f4));
    }

    public void setWorldPortOrigin(float f, float f2) {
        this.worldPort = new GF2DRectangle(f, f2, this.worldPort.width, this.worldPort.height);
        this.computeTranslationMatrices();
    }

    public void setWorldPortOrigin(GF2DPoint gF2DPoint) {
        this.setWorldPortOrigin(gF2DPoint.x, gF2DPoint.y);
    }

    public void setWorldPortCenter(float f, float f2) {
        this.setWorldPortOrigin(f - this.worldPort.width / 2.0f, f2 - this.worldPort.height / 2.0f);
    }

    public void setWorldPortCenter(GF2DPoint gF2DPoint) {
        this.setWorldPortCenter(gF2DPoint.x, gF2DPoint.y);
    }

    public float getWorld2ViewXScale() {
        return this.view2WorldScale.sxr11;
    }

    public float getWorld2ViewYScale() {
        return this.view2WorldScale.syr22;
    }

    public boolean isUnity() {
        return this.unity;
    }

    protected void computeTranslationMatrices() {
        this.world2ViewMatrix = GF2DMatrix.translation((float)this.viewPort.x - this.worldPort.x, (float)this.viewPort.y - this.worldPort.y).multiply(this.world2ViewScale);
        this.view2WorldMatrix = this.view2WorldScale.multiply(GF2DMatrix.translation(this.worldPort.x - (float)this.viewPort.x, this.worldPort.y - (float)this.viewPort.y));
        this.unity = this.world2ViewMatrix.isUnity();
    }

    protected void computeMatrices() {
        this.world2ViewScale = GF2DMatrix.scaling((float)this.viewPort.width / this.worldPort.width, (float)this.viewPort.height / this.worldPort.height);
        this.view2WorldScale = GF2DMatrix.scaling(this.worldPort.width / (float)this.viewPort.width, this.worldPort.height / (float)this.viewPort.height);
        this.computeTranslationMatrices();
    }

    public Point world2View(float f, float f2) {
        return this.world2ViewMatrix.multiply(f, f2).toPoint();
    }

    public Point world2View(GF2DPoint gF2DPoint) {
        return this.world2ViewMatrix.multiply(gF2DPoint).toPoint();
    }

    public Point world2View(Point point) {
        return this.world2ViewMatrix.multiply(point).toPoint();
    }

    public Dimension world2View(GF2DDimension gF2DDimension) {
        Point point = this.world2ViewScale.multiply(gF2DDimension.width, gF2DDimension.height).toPoint();
        return new Dimension(point.x, point.y);
    }

    public Dimension world2View(Dimension dimension) {
        Point point = this.world2ViewScale.multiply(dimension.width, dimension.height).toPoint();
        return new Dimension(point.x, point.y);
    }

    public Rectangle world2View(float f, float f2, float f3, float f4) {
        Point point = this.world2ViewMatrix.multiply(f, f2).toPoint();
        Point point2 = this.world2ViewMatrix.multiply(f + f3, f2 + f4).toPoint();
        return new Rectangle(point.x, point.y, point2.x - point.x, point2.y - point.y);
    }

    public Rectangle world2View(GF2DRectangle gF2DRectangle) {
        return this.world2View(gF2DRectangle.x, gF2DRectangle.y, gF2DRectangle.width, gF2DRectangle.height);
    }

    public Rectangle world2View(Rectangle rectangle) {
        return this.world2View(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public GF2DPoint view2World(int n, int n2) {
        return this.view2WorldMatrix.multiply(n, n2);
    }

    public GF2DPoint view2World(Point point) {
        return this.view2WorldMatrix.multiply(point);
    }

    public GF2DDimension view2World(Dimension dimension) {
        GF2DPoint gF2DPoint = this.view2WorldScale.multiply(dimension.width, dimension.height);
        return new GF2DDimension(gF2DPoint.x, gF2DPoint.y);
    }

    public GF2DRectangle view2World(float f, float f2, float f3, float f4) {
        GF2DPoint gF2DPoint = this.view2WorldMatrix.multiply(f, f2);
        GF2DPoint gF2DPoint2 = this.view2WorldMatrix.multiply(f + f3, f2 + f4);
        return new GF2DRectangle(gF2DPoint.x, gF2DPoint.y, gF2DPoint2.x - gF2DPoint.x, gF2DPoint2.y - gF2DPoint.y);
    }

    public GF2DRectangle view2World(Rectangle rectangle) {
        return this.view2World(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

