/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.view;

import com.objectshare.base.draw.OSIBorderPolicy;
import com.objectshare.base.event.OSIEventMulticaster;
import com.objectshare.base.util.OSIEnumeration;
import com.objectshare.base.util.OSIIntToIntHashtable;
import com.objectshare.grid.area.JKColumnArea;
import com.objectshare.grid.area.JKRectangularArea;
import com.objectshare.grid.area.JKRowArea;
import com.objectshare.grid.area.JKTableArea;
import com.objectshare.grid.data.JKModel;
import com.objectshare.grid.data.JKModelChangedEvent;
import com.objectshare.grid.data.JKModelColsAddedEvent;
import com.objectshare.grid.data.JKModelColsChangedEvent;
import com.objectshare.grid.data.JKModelColsRemovedEvent;
import com.objectshare.grid.data.JKModelColsReorderEvent;
import com.objectshare.grid.data.JKModelListener;
import com.objectshare.grid.data.JKModelRowsAddedEvent;
import com.objectshare.grid.data.JKModelRowsChangedEvent;
import com.objectshare.grid.data.JKModelRowsRemovedEvent;
import com.objectshare.grid.data.JKModelRowsReorderEvent;
import com.objectshare.grid.data.JKTableModel;
import com.objectshare.grid.draw.JKDrawingAdapter;
import com.objectshare.grid.draw.JKDrawingContext;
import com.objectshare.grid.draw.JKDrawingPolicy;
import com.objectshare.grid.draw.JKDrawnString;
import com.objectshare.grid.list.JKAWTEvent;
import com.objectshare.grid.list.JKEvent;
import com.objectshare.grid.view.JKAutoSizePolicy;
import com.objectshare.grid.view.JKDimensionPolicy;
import com.objectshare.grid.view.JKDisplayPolicy;
import com.objectshare.grid.view.JKDrawViewEvent;
import com.objectshare.grid.view.JKDrawViewListener;
import com.objectshare.grid.view.JKDrawViewMulticaster;
import com.objectshare.grid.view.JKImmediateRepairPolicy;
import com.objectshare.grid.view.JKRepairPolicy;
import com.objectshare.grid.view.JKTableCoordinator;
import com.objectshare.grid.view.JKTableViewAdapter;
import com.objectshare.grid.view.OSIScrollbar;
import com.objectshare.java.osi.OSIPanel;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.EventListener;
import java.util.Hashtable;

public class JKTableView
extends OSIPanel
implements JKModelListener {
    static final long serialVersionUID = 9050986507915299199L;
    protected static final String drawViewListenerK = "drawViewL";
    protected boolean autoRelease = false;
    public boolean autoConnect;
    public JKModel data;
    protected JKDisplayPolicy displayPolicy;
    public JKTableCoordinator coordinator;
    public JKTableViewAdapter primaryAdapter;
    public JKDimensionPolicy dimensions;
    public transient Color debugRepaintColor;
    public transient Color debugPaintColor;
    protected Dimension preferredSize = new Dimension(100, 100);
    protected boolean focusTraversable = true;
    protected JKRepairPolicy repairPolicy = new JKImmediateRepairPolicy(this);
    protected Hashtable drawnValueClassMap;
    public boolean callHandleEvent = true;
    public boolean handleEventCalled = false;
    protected JKAutoSizePolicy autoSizePolicy = new JKAutoSizePolicy(this);
    protected JKDrawViewListener drawViewListener;
    private transient int welcomePageNum;
    private static String[] welcomeText = new String[]{"Welcome to\nthe jKit/Grid 1.1\nevaluation version", "For more information:\nhttp://www.objectshare.com"};
    private static Rectangle[] welcomeBoxes = new Rectangle[]{new Rectangle(10, 10, 175, 75), new Rectangle(10, 10, 300, 65)};
    private static Font[] welcomeFonts = new Font[]{new Font("Helvetica", 1, 16), new Font("Helvetica", 1, 16)};

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        this.writeEventListeners(objectOutputStream);
        objectOutputStream.writeObject(null);
    }

    protected void writeEventListeners(ObjectOutputStream objectOutputStream) throws IOException {
        OSIEventMulticaster.save((ObjectOutputStream)objectOutputStream, (String)drawViewListenerK, (EventListener)this.drawViewListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            String string = ((String)object).intern();
            Object object2 = objectInputStream.readObject();
            this.registerEventListener(string, object2);
        }
    }

    protected boolean registerEventListener(String string, Object object) throws IOException {
        if (string == drawViewListenerK) {
            this.addDrawViewListener((JKDrawViewListener)object);
            return true;
        }
        return false;
    }

    public JKTableView() {
        this(new JKTableModel());
    }

    public JKTableView(int n, int n2) {
        this(new JKTableModel(n2, n));
    }

    public JKTableView(JKModel jKModel) {
        this.initHelpers();
        this.basicSetLayout(null);
        this.setModel(jKModel);
        this.enableUIEvents(60L);
    }

    protected void initHelpers() {
        this.dimensions = new JKDimensionPolicy(this);
        this.displayPolicy = new JKDisplayPolicy(this);
        this.coordinator = new JKTableCoordinator(this);
        this.primaryAdapter = this.coordinator.getCellAdapter();
    }

    public JKModel getModel() {
        return this.data;
    }

    public void setModel(JKModel jKModel) {
        if (this.data != jKModel) {
            this.release();
            this.basicSetModel(jKModel);
            this.connect();
        }
    }

    public void basicSetModel(JKModel jKModel) {
        this.data = jKModel;
    }

    public void data(JKModel jKModel) {
        this.setModel(jKModel);
    }

    public void setAutoRelease(boolean bl) {
        this.autoRelease = bl;
    }

    public boolean getAutoRelease() {
        return this.autoRelease;
    }

    public void connect() {
        if (this.data != null) {
            this.data.addJKModelListener(this);
            this.dimensions.updateModel(this.data);
            this.coordinator.updateModel(this.data);
            this.applyDrawingAdapters(this.data.getColumns(0, this.data.getNumberOfColumns() + 1));
            this.applyDrawingAdapters(this.data.getCachedRowAdapters());
            this.autoSizePolicy.updateModel(this.data);
        }
    }

    public void disconnect() {
        if (this.data != null) {
            this.data.removeModelListener(this);
        }
    }

    public void release() {
        this.disconnect();
    }

    public void addNotify() {
        super.addNotify();
        this.autoSize();
        this.initWelcome();
        this.getRepairPolicy().start();
    }

    public void removeNotify() {
        this.getRepairPolicy().stop();
        if (this.autoRelease) {
            this.release();
        }
        super.removeNotify();
    }

    public int getNumberOfRows() {
        return this.getModel().getNumberOfRows();
    }

    public void setNumberOfRows(int n) {
        JKModel jKModel = this.getModel();
        int n2 = jKModel.getNumberOfRows();
        if (n2 > n) {
            jKModel.removeRows(n + 1, n2 - n);
            return;
        }
        if (n2 < n) {
            jKModel.addRows(n - n2);
        }
    }

    public int getNumberOfColumns() {
        return this.getModel().getNumberOfColumns();
    }

    public void setNumberOfColumns(int n) {
        JKModel jKModel = this.getModel();
        int n2 = jKModel.getNumberOfColumns();
        if (n2 > n) {
            jKModel.removeColumns(n + 1, n2 - n);
            return;
        }
        if (n2 < n) {
            jKModel.addColumns(n - n2);
        }
    }

    public JKTableViewAdapter getTopLeftHeaderAdapter() {
        return this.coordinator.getAdapter(0, 0);
    }

    public JKTableViewAdapter getColumnHeaderAdapter() {
        return this.coordinator.getAdapter(1, 0);
    }

    public JKTableViewAdapter getRowHeaderAdapter() {
        return this.coordinator.getAdapter(0, 1);
    }

    public JKTableViewAdapter getCellAdapter() {
        return this.coordinator.getAdapter(1, 1);
    }

    public JKTableViewAdapter getAdapter(int n, int n2) {
        return this.coordinator.getAdapterForCell(n2, n);
    }

    public JKTableViewAdapter getAdapterForCell(int n, int n2) {
        return this.coordinator.getAdapterForCell(n2, n);
    }

    public JKTableViewAdapter getAdapter() {
        return this.primaryAdapter;
    }

    public final JKTableCoordinator getCoordinator() {
        return this.coordinator;
    }

    public void setCoordinator(JKTableCoordinator jKTableCoordinator) {
        this.coordinator = jKTableCoordinator;
    }

    public final JKDimensionPolicy getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(JKDimensionPolicy jKDimensionPolicy) {
        this.dimensions = jKDimensionPolicy;
    }

    public JKDisplayPolicy getDisplayPolicy() {
        return this.displayPolicy;
    }

    public void setDisplayPolicy(JKDisplayPolicy jKDisplayPolicy) {
        this.displayPolicy = jKDisplayPolicy;
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public void basicSetLayout(LayoutManager layoutManager) {
        super.setLayout(layoutManager);
    }

    public JKRepairPolicy getRepairPolicy() {
        return this.repairPolicy;
    }

    public void setRepairPolicy(JKRepairPolicy jKRepairPolicy) {
        if (this.repairPolicy.isActive()) {
            this.repairPolicy.stop();
            this.repairPolicy = jKRepairPolicy;
            this.repairPolicy.start();
            return;
        }
        this.repairPolicy = jKRepairPolicy;
    }

    public OSIScrollbar getHorizontalScroll() {
        return this.coordinator.getHorizontalScrollbar(1);
    }

    public void setHorizontalScroll(OSIScrollbar oSIScrollbar) {
        this.coordinator.setHorizontalScrollbar(1, oSIScrollbar);
    }

    public OSIScrollbar getVerticalScroll() {
        return this.coordinator.getVerticalScrollbar(1);
    }

    public void setVerticalScroll(OSIScrollbar oSIScrollbar) {
        this.coordinator.setVerticalScrollbar(1, oSIScrollbar);
    }

    public int getColumnWidth(int n) {
        return this.dimensions.getWidth(n);
    }

    public int getColumnWidth(String string, int n) {
        return this.dimensions.getWidth(string, n);
    }

    public int getColumnWidth(int n, int n2) {
        return this.dimensions.getWidth(n, n2);
    }

    public void setColumnWidth(int n, int n2) {
        int n3 = this.getColumnWidth(n);
        if (n3 == n2) {
            return;
        }
        this.dimensions.setWidth(n, n2);
        this.autoSizePolicy.columnWidthChanged(n, n3, n2);
    }

    public void setColumnWidth(String string, int n, int n2) {
        int n3 = this.getColumnWidth(string, n);
        if (n3 == n2) {
            return;
        }
        this.dimensions.setWidth(string, n, n2);
        this.autoSizePolicy.columnWidthChanged(string, n, n3, n2);
    }

    public void setColumnWidth(int n, int n2, int n3) {
        int n4 = this.getColumnWidth(n, n2);
        if (n4 == n3) {
            return;
        }
        this.dimensions.setWidth(n, n2, n3);
        this.autoSizePolicy.columnWidthChanged(n, n2, n4, n3);
    }

    public boolean isColumnAutoSizable(int n) {
        return this.dimensions.isColumnAutoSizable(n);
    }

    public boolean isColumnUserSizable(int n) {
        return this.dimensions.isColumnUserSizable(n);
    }

    public boolean isColumnAutoSizable(String string, int n) {
        return this.dimensions.isColumnAutoSizable(string, n);
    }

    public boolean isColumnUserSizable(String string, int n) {
        return this.dimensions.isColumnUserSizable(string, n);
    }

    public boolean isColumnAutoSizable(int n, int n2) {
        return this.dimensions.isColumnAutoSizable(n, n2);
    }

    public boolean isColumnUserSizable(int n, int n2) {
        return this.dimensions.isColumnUserSizable(n, n2);
    }

    public void setColumnAutoSizable(int n, boolean bl) {
        this.dimensions.setColumnAutoSizable(n, bl);
    }

    public void setColumnUserSizable(int n, boolean bl) {
        this.dimensions.setColumnUserSizable(n, bl);
    }

    public void setColumnAutoSizable(String string, int n, boolean bl) {
        this.dimensions.setColumnAutoSizable(string, n, bl);
    }

    public void setColumnUserSizable(String string, int n, boolean bl) {
        this.dimensions.setColumnUserSizable(string, n, bl);
    }

    public void setColumnAutoSizable(int n, int n2, boolean bl) {
        this.dimensions.setColumnAutoSizable(n, n2, bl);
    }

    public void setColumnUserSizable(int n, int n2, boolean bl) {
        this.dimensions.setColumnUserSizable(n, n2, bl);
    }

    public int getRowHeight(int n) {
        return this.dimensions.getHeight(n);
    }

    public void setRowHeight(int n, int n2) {
        int n3 = this.getRowHeight(n);
        if (n3 == n2) {
            return;
        }
        this.dimensions.setHeight(n, n2);
        this.autoSizePolicy.rowHeightChanged(n, n3, n2);
    }

    public boolean isRowAutoSizable(int n) {
        return this.dimensions.isRowAutoSizable(n);
    }

    public boolean isRowUserSizable(int n) {
        return this.dimensions.isRowUserSizable(n);
    }

    public void setRowAutoSizable(int n, boolean bl) {
        this.dimensions.setRowAutoSizable(n, bl);
    }

    public void setRowUserSizable(int n, boolean bl) {
        this.dimensions.setRowUserSizable(n, bl);
    }

    public void addDrawnValueAssociation(Object object, Object object2) {
        if (this.drawnValueClassMap == null) {
            this.drawnValueClassMap = new Hashtable();
        }
        JKDrawnString.addDrawnValueAssociation(object, object2, this.drawnValueClassMap);
    }

    public void removeDrawnValueAssociation(String string) {
        if (this.drawnValueClassMap != null) {
            this.drawnValueClassMap.remove(string);
            if (this.drawnValueClassMap.isEmpty()) {
                this.drawnValueClassMap = null;
            }
        }
    }

    public Object getDrawnValueOrNullFor(Object object) {
        Object object2;
        if (this.drawnValueClassMap != null && (object2 = JKDrawnString.getDrawnValueOrNullFor(object, this.drawnValueClassMap)) != null) {
            return object2;
        }
        return JKDrawnString.getDrawnValueOrNullFor(object);
    }

    public void resetDrawingAttributes() {
        this.displayPolicy.resetDrawingAttributes();
        this.damageAll();
    }

    public void setDrawingPolicy(JKTableArea jKTableArea, JKDrawingPolicy jKDrawingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getDrawingContexts(jKTableArea);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setDrawingPolicy(jKDrawingPolicy);
        }
        this.damageAll();
    }

    public void setSelectionDrawingPolicy(JKTableArea jKTableArea, JKDrawingPolicy jKDrawingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getDrawingContexts(jKTableArea);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setSelectionDrawingPolicy(jKDrawingPolicy);
        }
        this.damageAll();
    }

    public void setBackColor(JKTableArea jKTableArea, Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getDrawingContexts(jKTableArea);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBackColor(color);
        }
        this.damageAll();
    }

    public void setForeColor(JKTableArea jKTableArea, Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getDrawingContexts(jKTableArea);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setForeColor(color);
        }
        this.damageAll();
    }

    public void setBorderColor(JKTableArea jKTableArea, Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getDrawingContexts(jKTableArea);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBorderColor(color);
        }
        this.damageAll();
    }

    public void setBorderInsets(JKTableArea jKTableArea, Insets insets) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getDrawingContexts(jKTableArea);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBorderInsets(insets);
        }
        this.damageAll();
    }

    public void setContentInsets(JKTableArea jKTableArea, Insets insets) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getDrawingContexts(jKTableArea);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setContentInsets(insets);
        }
        this.damageAll();
    }

    public void setFont(JKTableArea jKTableArea, Font font) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getDrawingContexts(jKTableArea);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setFont(font);
        }
        this.damageAll();
    }

    public void setHorizontalJustification(JKTableArea jKTableArea, int n) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getDrawingContexts(jKTableArea);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setHorizontalJustification(n);
        }
        this.damageAll();
    }

    public void setVerticalJustification(JKTableArea jKTableArea, int n) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getDrawingContexts(jKTableArea);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setVerticalJustification(n);
        }
        this.damageAll();
    }

    public void setScale(JKTableArea jKTableArea, int n) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getDrawingContexts(jKTableArea);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setScale(n);
        }
        this.damageAll();
    }

    public boolean getTableBorder() {
        return this.getCoordinator().getBorderPolicy() == OSIBorderPolicy.LEFT_TOP && this.getColumnHeaderAdapter().getBorderPolicy() == OSIBorderPolicy.RIGHT && this.getCellAdapter().getBorderPolicy() == OSIBorderPolicy.RIGHT_BOTTOM && this.getRowHeaderAdapter().getBorderPolicy() == OSIBorderPolicy.BOTTOM;
    }

    public void setTableBorder(boolean bl) {
        if (bl) {
            this.getCoordinator().setBorderPolicy(OSIBorderPolicy.LEFT_TOP);
            this.getColumnHeaderAdapter().setBorderPolicy(OSIBorderPolicy.RIGHT);
            this.getCellAdapter().setBorderPolicy(OSIBorderPolicy.RIGHT_BOTTOM);
            this.getRowHeaderAdapter().setBorderPolicy(OSIBorderPolicy.BOTTOM);
            return;
        }
        this.getCoordinator().setBorderPolicy(OSIBorderPolicy.NONE);
        this.getColumnHeaderAdapter().setBorderPolicy(OSIBorderPolicy.NONE);
        this.getCellAdapter().setBorderPolicy(OSIBorderPolicy.NONE);
        this.getRowHeaderAdapter().setBorderPolicy(OSIBorderPolicy.NONE);
    }

    public JKDrawingPolicy getDrawingPolicy() {
        return this.displayPolicy.tableDC.getDrawingPolicy();
    }

    public void setDrawingPolicy(JKDrawingPolicy jKDrawingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setDrawingPolicy(jKDrawingPolicy);
        }
        this.damageAll();
    }

    public void setDrawingPolicyDefault(JKDrawingPolicy jKDrawingPolicy) {
        this.displayPolicy.tableDC.setDrawingPolicy(jKDrawingPolicy);
        this.damageAll();
    }

    public JKDrawingPolicy getSelectionDrawingPolicy() {
        return this.displayPolicy.tableDC.getDrawingPolicy();
    }

    public void setSelectionDrawingPolicy(JKDrawingPolicy jKDrawingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setSelectionDrawingPolicy(jKDrawingPolicy);
        }
        this.damageAll();
    }

    public void setSelectionDrawingPolicyDefault(JKDrawingPolicy jKDrawingPolicy) {
        this.displayPolicy.tableDC.setSelectionDrawingPolicy(jKDrawingPolicy);
        this.damageAll();
    }

    public Color getBackColor() {
        return this.displayPolicy.tableDC.getBackColor();
    }

    public void setBackColor(Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBackColor(color);
        }
        this.damageAll();
    }

    public void setBackground(Color color) {
        this.setCellAreaBackColor(color);
        this.setBasicBackground(color);
    }

    public void setBasicBackground(Color color) {
        super.setBackground(color);
    }

    public Color getBasicBackground() {
        return super.getBackground();
    }

    public void setBackColorDefault(Color color) {
        this.displayPolicy.tableDC.setBackColor(color);
        this.damageAll();
    }

    public Color getForeColor() {
        return this.displayPolicy.tableDC.getForeColor();
    }

    public void setForeColor(Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setForeColor(color);
        }
        this.damageAll();
    }

    public Color getForeground() {
        return this.getForeColor();
    }

    public void setForeground(Color color) {
        this.setForeColor(color);
    }

    public Color getBasicForeground() {
        return super.getForeground();
    }

    public void setBasicForeground(Color color) {
        super.setForeground(color);
    }

    public void setForeColorDefault(Color color) {
        this.displayPolicy.tableDC.setForeColor(color);
        this.damageAll();
    }

    public Color getBorderColor() {
        return this.displayPolicy.tableDC.getBorderColor();
    }

    public void setBorderColor(Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBorderColor(color);
        }
        this.damageAll();
    }

    public void setBorderColorDefault(Color color) {
        this.displayPolicy.tableDC.setBorderColor(color);
        this.damageAll();
    }

    public Insets getBorderInsets() {
        return this.displayPolicy.tableDC.getBorderInsets();
    }

    public void setBorderInsets(Insets insets) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBorderInsets(insets);
        }
        this.damageAll();
    }

    public void setBorderInsetsDefault(Insets insets) {
        this.displayPolicy.tableDC.setBorderInsets(insets);
        this.damageAll();
    }

    public Insets getContentInsets() {
        return this.displayPolicy.tableDC.getContentInsets();
    }

    public void setContentInsets(Insets insets) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setContentInsets(insets);
        }
        this.damageAll();
    }

    public void setContentInsetsDefault(Insets insets) {
        this.displayPolicy.tableDC.setContentInsets(insets);
        this.damageAll();
    }

    public Font getFont() {
        return this.displayPolicy.tableDC.getFont();
    }

    public void setFont(Font font) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setFont(font);
        }
        this.damageAll();
    }

    public void setFontDefault(Font font) {
        this.displayPolicy.tableDC.setFont(font);
        this.damageAll();
    }

    public int getHorizontalJustification() {
        return this.displayPolicy.tableDC.getHorizontalJustification();
    }

    public void setHorizontalJustification(int n) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setHorizontalJustification(n);
        }
        this.damageAll();
    }

    public void setHorizontalJustificationDefault(int n) {
        this.displayPolicy.tableDC.setHorizontalJustification(n);
        this.damageAll();
    }

    public int getVerticalJustification() {
        return this.displayPolicy.tableDC.getVerticalJustification();
    }

    public void setVerticalJustification(int n) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setVerticalJustification(n);
        }
        this.damageAll();
    }

    public void setVerticalJustificationDefault(int n) {
        this.displayPolicy.tableDC.setVerticalJustification(n);
        this.damageAll();
    }

    public int getScale() {
        return this.displayPolicy.tableDC.getScale();
    }

    public void setScale(int n) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setScale(n);
        }
        this.damageAll();
    }

    public void setScaleDefault(int n) {
        this.displayPolicy.tableDC.setScale(n);
        this.damageAll();
    }

    public int lockRowsToTop(int n) {
        int n2 = this.getRowsLockedToTop();
        this.setRowsLockedToTop(n);
        return n2;
    }

    public int getRowsLockedToTop() {
        return this.dimensions.getRowNumber(this.coordinator.getVirtualY(1)) - 1;
    }

    public void setRowsLockedToTop(int n) {
        int n2;
        int n3 = n;
        if (n3 < -this.getNumberOfColumnHeaders()) {
            n3 = -this.getNumberOfColumnHeaders();
        }
        if (n3 > this.data.getNumberOfRows()) {
            n3 = this.data.getNumberOfRows();
        }
        if ((n2 = this.dimensions.getVirtualY(n3 + 1) - this.coordinator.getVirtualY(1)) > this.coordinator.getVirtualHeight(1)) {
            n2 = this.coordinator.getVirtualHeight(1);
        }
        if (n2 == 0) {
            return;
        }
        this.coordinator.moveVirtualHeight(0, n2);
        this.coordinator.moveScreenHeight(0, n2);
        this.damageAll();
    }

    public int getRowsLockedToBottom() {
        return this.data.getNumberOfRows() - this.coordinator.getAdapter(1, 1).getLastRowNumber();
    }

    public void setRowsLockedToBottom(int n) {
        int n2;
        int n3 = n;
        if (n3 < -this.getNumberOfColumnFooters()) {
            n3 = -this.getNumberOfColumnFooters();
        }
        if (n3 > this.data.getNumberOfRows()) {
            n3 = this.data.getNumberOfRows();
        }
        if (n3 == this.getRowsLockedToBottom()) {
            return;
        }
        if (this.coordinator.getNumberOfAdapterRows() < 3) {
            this.coordinator.setNumberOfAdapterRows(3);
        }
        if ((n2 = this.coordinator.getVirtualY(2) - this.dimensions.getVirtualY(this.data.getNumberOfRows() - n3 + 1)) > this.coordinator.getVirtualHeight(1)) {
            n2 = this.coordinator.getVirtualHeight(1);
        }
        if (n2 == 0) {
            return;
        }
        this.coordinator.moveVirtualHeight(1, -n2);
        this.coordinator.moveScreenHeight(1, -n2);
        if (this.coordinator.getVirtualHeight(2) == 0) {
            this.coordinator.setNumberOfAdapterRows(2);
        }
        this.damageAll();
    }

    public int lockColumnsToLeft(int n) {
        int n2 = this.getColumnsLockedToLeft();
        this.setColumnsLockedToLeft(n);
        return n2;
    }

    public int getColumnsLockedToLeft() {
        return this.dimensions.getColumnNumber(this.coordinator.getVirtualX(1)) - 1;
    }

    public void setColumnsLockedToLeft(int n) {
        int n2;
        int n3 = n;
        if (n3 < -this.getNumberOfRowHeaders()) {
            n3 = -this.getNumberOfRowHeaders();
        }
        if (n3 > this.data.getNumberOfColumns()) {
            n3 = this.data.getNumberOfColumns();
        }
        if ((n2 = this.dimensions.getVirtualX(n3 + 1) - this.coordinator.getVirtualX(1)) > this.coordinator.getVirtualWidth(1)) {
            n2 = this.coordinator.getVirtualWidth(1);
        }
        if (n2 == 0) {
            return;
        }
        this.coordinator.moveVirtualWidth(0, n2);
        this.coordinator.moveScreenWidth(0, n2);
        this.damageAll();
    }

    public int getColumnsLockedToRight() {
        return this.data.getNumberOfColumns() - this.coordinator.getAdapter(1, 1).getLastColumnNumber();
    }

    public void setColumnsLockedToRight(int n) {
        int n2;
        int n3 = n;
        if (n3 < -this.getNumberOfRowFooters()) {
            n3 = -this.getNumberOfRowFooters();
        }
        if (n3 > this.data.getNumberOfColumns()) {
            n3 = this.data.getNumberOfColumns();
        }
        if (n3 == this.getColumnsLockedToRight()) {
            return;
        }
        if (this.coordinator.getNumberOfAdapterColumns() < 3) {
            this.coordinator.setNumberOfAdapterColumns(3);
        }
        if ((n2 = this.coordinator.getVirtualX(2) - this.dimensions.getVirtualX(this.data.getNumberOfColumns() - n3 + 1)) > this.coordinator.getVirtualWidth(1)) {
            n2 = this.coordinator.getVirtualWidth(1);
        }
        if (n2 == 0) {
            return;
        }
        this.coordinator.moveVirtualWidth(1, -n2);
        this.coordinator.moveScreenWidth(1, -n2);
        if (this.coordinator.getVirtualWidth(2) == 0) {
            this.coordinator.setNumberOfAdapterColumns(2);
        }
        this.damageAll();
    }

    public void setFocusTraversable(boolean bl) {
        this.focusTraversable = bl;
    }

    public boolean isFocusTraversable() {
        return this.focusTraversable;
    }

    public JKDrawingPolicy getHeaderDrawingPolicy() {
        return this.displayPolicy.topLeftHdrDC.getDrawingPolicy();
    }

    public void setHeaderDrawingPolicy(JKDrawingPolicy jKDrawingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setDrawingPolicy(jKDrawingPolicy);
        }
        this.damageAll();
    }

    public void setHeaderDrawingPolicyDefault(JKDrawingPolicy jKDrawingPolicy) {
        this.displayPolicy.topLeftHdrDC.setDrawingPolicy(jKDrawingPolicy);
        this.displayPolicy.columnHdrDC.setDrawingPolicy(jKDrawingPolicy);
        this.displayPolicy.rowHdrDC.setDrawingPolicy(jKDrawingPolicy);
        this.damageAll();
    }

    public JKDrawingPolicy getHeaderSelectionDrawingPolicy() {
        return this.displayPolicy.topLeftHdrDC.getDrawingPolicy();
    }

    public void setHeaderSelectionDrawingPolicy(JKDrawingPolicy jKDrawingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setSelectionDrawingPolicy(jKDrawingPolicy);
        }
        this.damageAll();
    }

    public void setHeaderSelectionDrawingPolicyDefault(JKDrawingPolicy jKDrawingPolicy) {
        this.displayPolicy.topLeftHdrDC.setSelectionDrawingPolicy(jKDrawingPolicy);
        this.displayPolicy.columnHdrDC.setSelectionDrawingPolicy(jKDrawingPolicy);
        this.displayPolicy.rowHdrDC.setSelectionDrawingPolicy(jKDrawingPolicy);
        this.damageAll();
    }

    public Color getHeaderBackColor() {
        return this.displayPolicy.topLeftHdrDC.getBackColor();
    }

    public void setHeaderBackColor(Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBackColor(color);
        }
        this.damageHeaders();
    }

    public void setHeaderBackColorDefault(Color color) {
        this.displayPolicy.topLeftHdrDC.setBackColor(color);
        this.displayPolicy.columnHdrDC.setBackColor(color);
        this.displayPolicy.rowHdrDC.setBackColor(color);
        this.damageHeaders();
    }

    public Color getHeaderForeColor() {
        return this.displayPolicy.topLeftHdrDC.getForeColor();
    }

    public void setHeaderForeColor(Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setForeColor(color);
        }
        this.damageHeaders();
    }

    public void setHeaderForeColorDefault(Color color) {
        this.displayPolicy.topLeftHdrDC.setForeColor(color);
        this.displayPolicy.columnHdrDC.setForeColor(color);
        this.displayPolicy.rowHdrDC.setForeColor(color);
        this.damageHeaders();
    }

    public Color getHeaderBorderColor() {
        return this.displayPolicy.topLeftHdrDC.getBorderColor();
    }

    public void setHeaderBorderColor(Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBorderColor(color);
        }
        this.damageHeaders();
    }

    public void setHeaderBorderColorDefault(Color color) {
        this.displayPolicy.topLeftHdrDC.setBorderColor(color);
        this.displayPolicy.columnHdrDC.setBorderColor(color);
        this.displayPolicy.rowHdrDC.setBorderColor(color);
        this.damageHeaders();
    }

    public Font getHeaderFont() {
        return this.displayPolicy.topLeftHdrDC.getFont();
    }

    public void setHeaderFont(Font font) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setFont(font);
        }
        this.damageHeaders();
    }

    public void setHeaderFontDefault(Font font) {
        this.displayPolicy.topLeftHdrDC.setFont(font);
        this.displayPolicy.columnHdrDC.setFont(font);
        this.displayPolicy.rowHdrDC.setFont(font);
        this.damageHeaders();
    }

    public int getHeaderHorizontalJustification() {
        return this.displayPolicy.topLeftHdrDC.getHorizontalJustification();
    }

    public void setHeaderHorizontalJustification(int n) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setHorizontalJustification(n);
        }
        this.damageAll();
    }

    public void setHeaderHorizontalJustificationDefault(int n) {
        this.displayPolicy.topLeftHdrDC.setHorizontalJustification(n);
        this.displayPolicy.columnHdrDC.setHorizontalJustification(n);
        this.displayPolicy.rowHdrDC.setHorizontalJustification(n);
        this.damageAll();
    }

    public int getHeaderVerticalJustification() {
        return this.displayPolicy.topLeftHdrDC.getVerticalJustification();
    }

    public void setHeaderVerticalJustification(int n) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setVerticalJustification(n);
        }
        this.damageAll();
    }

    public void setHeaderVerticalJustificationDefault(int n) {
        this.displayPolicy.topLeftHdrDC.setVerticalJustification(n);
        this.displayPolicy.columnHdrDC.setVerticalJustification(n);
        this.displayPolicy.rowHdrDC.setVerticalJustification(n);
        this.damageAll();
    }

    public int getHeaderScale() {
        return this.displayPolicy.topLeftHdrDC.getScale();
    }

    public void setHeaderScale(int n) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setScale(n);
        }
        this.damageAll();
    }

    public void setHeaderScaleDefault(int n) {
        this.displayPolicy.topLeftHdrDC.setScale(n);
        this.displayPolicy.columnHdrDC.setScale(n);
        this.displayPolicy.rowHdrDC.setScale(n);
        this.damageAll();
    }

    public void showHeaders(boolean bl, boolean bl2) {
        this.setRowHeaders(bl2);
        this.setColumnHeaders(bl);
    }

    public JKDrawingPolicy getRowDrawingPolicy(int n) {
        return this.displayPolicy.existingRowDrawingContext(n).getDrawingPolicy();
    }

    public void setRowDrawingPolicy(int n, JKDrawingPolicy jKDrawingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getRowAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setDrawingPolicy(jKDrawingPolicy);
        }
        this.damageRows(n, 1);
    }

    public JKDrawingPolicy getRowSelectionDrawingPolicy(int n) {
        return this.displayPolicy.topLeftHdrDC.getDrawingPolicy();
    }

    public void setRowSelectionDrawingPolicy(int n, JKDrawingPolicy jKDrawingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getRowAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setSelectionDrawingPolicy(jKDrawingPolicy);
        }
        this.damageRows(n, 1);
    }

    public Color getRowBackColor(int n) {
        return this.displayPolicy.existingRowDrawingContext(n).getBackColor();
    }

    public void setRowBackColor(int n, Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getRowAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBackColor(color);
        }
        this.damageRows(n, 1);
    }

    public Color getRowForeColor(int n) {
        return this.displayPolicy.existingRowDrawingContext(n).getForeColor();
    }

    public void setRowForeColor(int n, Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getRowAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setForeColor(color);
        }
        this.damageRows(n, 1);
    }

    public Color getRowBorderColor(int n) {
        return this.displayPolicy.existingRowDrawingContext(n).getBorderColor();
    }

    public void setRowBorderColor(int n, Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getRowAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBorderColor(color);
        }
        this.damageRows(n, 1);
    }

    public Font getRowFont(int n) {
        return this.displayPolicy.existingRowDrawingContext(n).getFont();
    }

    public void setRowFont(int n, Font font) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getRowAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setFont(font);
        }
        this.damageRows(n, 1);
    }

    public int getRowHorizontalJustification(int n) {
        return this.displayPolicy.existingRowDrawingContext(n).getHorizontalJustification();
    }

    public void setRowHorizontalJustification(int n, int n2) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getRowAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setHorizontalJustification(n2);
        }
        this.damageRows(n, 1);
    }

    public int getRowVerticalJustification(int n) {
        return this.displayPolicy.existingRowDrawingContext(n).getVerticalJustification();
    }

    public void setRowVerticalJustification(int n, int n2) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getRowAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setVerticalJustification(n2);
        }
        this.damageRows(n, 1);
    }

    public int getRowScale(int n) {
        return this.displayPolicy.existingRowDrawingContext(n).getScale();
    }

    public void setRowScale(int n, int n2) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getRowAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setScale(n2);
        }
        this.damageRows(n, 1);
    }

    public JKDrawingContext getRowDrawingContext(int n) {
        return this.displayPolicy.getRowDrawingContext(n);
    }

    public void setRowDrawingContext(int n, JKDrawingContext jKDrawingContext) {
        this.displayPolicy.setRowDrawingContext(n, jKDrawingContext);
        this.damageRows(n, 1);
    }

    public boolean getRowHeaders() {
        return this.getNumberOfRowHeaders() > 0;
    }

    public int getNumberOfRowHeaders() {
        return 1 - this.coordinator.getFirstColumnNumber();
    }

    public void setRowHeaders(boolean bl) {
        this.setNumberOfRowHeaders(bl ? 1 : 0);
    }

    public void setNumberOfRowHeaders(int n) {
        int n2;
        int n3 = n > 0 ? n : 0;
        int n4 = this.getNumberOfRowHeaders();
        if (n4 == n3) {
            return;
        }
        int n5 = 1 - n4;
        int n6 = 1 - n3;
        int n7 = this.dimensions.getVirtualX(n5);
        int n8 = n7 - (n2 = this.dimensions.getVirtualX(n6));
        if (n8 < -this.coordinator.getVirtualWidth(0)) {
            n8 = -this.coordinator.getVirtualWidth(0);
        }
        this.coordinator.setVirtualX(n2);
        this.coordinator.adjustVirtualWidth(0, n2, n8);
        this.autoSizePolicy.reshaped();
        this.damageAll();
    }

    public int getNumberOfRowFooters() {
        return this.coordinator.getLastColumnNumber() - this.getModel().getNumberOfColumns();
    }

    public void setNumberOfRowFooters(int n) {
        int n2 = n > 0 ? n : 0;
        int n3 = this.getNumberOfRowFooters();
        if (n3 == n2) {
            return;
        }
        if (this.coordinator.getNumberOfAdapterColumns() < 3) {
            this.coordinator.setNumberOfAdapterColumns(3);
        }
        int n4 = n3 + this.getModel().getNumberOfColumns();
        int n5 = n2 + this.getModel().getNumberOfColumns();
        int n6 = this.dimensions.getVirtualX(n4);
        int n7 = this.dimensions.getVirtualX(n5);
        int n8 = n7 - n6;
        if (n8 < -this.coordinator.getVirtualWidth(2)) {
            n8 = -this.coordinator.getVirtualWidth(2);
        }
        if (n8 == 0) {
            return;
        }
        this.coordinator.adjustVirtualWidth(2, n7, n8);
        if (this.coordinator.getVirtualWidth(2) == 0) {
            this.coordinator.setNumberOfAdapterColumns(2);
        }
        this.autoSizePolicy.reshaped();
        this.damageAll();
    }

    public JKDrawingPolicy getRowHeaderDrawingPolicy() {
        return this.displayPolicy.rowHdrDC.getDrawingPolicy();
    }

    public void setRowHeaderDrawingPolicy(JKDrawingPolicy jKDrawingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingRowHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setDrawingPolicy(jKDrawingPolicy);
        }
        this.damageRowHeaders();
    }

    public void setRowHeaderDrawingPolicyDefault(JKDrawingPolicy jKDrawingPolicy) {
        this.displayPolicy.rowHdrDC.setDrawingPolicy(jKDrawingPolicy);
        this.damageRowHeaders();
    }

    public JKDrawingPolicy getRowHeaderSelectionDrawingPolicy() {
        return this.displayPolicy.rowHdrDC.getDrawingPolicy();
    }

    public void setRowHeaderSelectionDrawingPolicy(JKDrawingPolicy jKDrawingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingRowHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setSelectionDrawingPolicy(jKDrawingPolicy);
        }
        this.damageRowHeaders();
    }

    public void setRowHeaderSelectionDrawingPolicyDefault(JKDrawingPolicy jKDrawingPolicy) {
        this.displayPolicy.rowHdrDC.setSelectionDrawingPolicy(jKDrawingPolicy);
        this.damageRowHeaders();
    }

    public Color getRowHeaderBackColor() {
        return this.displayPolicy.rowHdrDC.getBackColor();
    }

    public void setRowHeaderBackColor(Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingRowHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBackColor(color);
        }
        this.damageRowHeaders();
    }

    public void setRowHeaderBackColorDefault(Color color) {
        this.displayPolicy.rowHdrDC.setBackColor(color);
        this.damageRowHeaders();
    }

    public Color getRowHeaderForeColor() {
        return this.displayPolicy.rowHdrDC.getForeColor();
    }

    public void setRowHeaderForeColor(Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingRowHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setForeColor(color);
        }
        this.damageRowHeaders();
    }

    public void setRowHeaderForeColorDefault(Color color) {
        this.displayPolicy.rowHdrDC.setForeColor(color);
        this.damageRowHeaders();
    }

    public Color getRowHeaderBorderColor() {
        return this.displayPolicy.rowHdrDC.getBorderColor();
    }

    public void setRowHeaderBorderColor(Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingRowHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBorderColor(color);
        }
        this.damageRowHeaders();
    }

    public void setRowHeaderBorderColorDefault(Color color) {
        this.displayPolicy.rowHdrDC.setBorderColor(color);
        this.damageRowHeaders();
    }

    public Font getRowHeaderFont() {
        return this.displayPolicy.rowHdrDC.getFont();
    }

    public void setRowHeaderFont(Font font) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingRowHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setFont(font);
        }
        this.damageRowHeaders();
    }

    public void setRowHeaderFontDefault(Font font) {
        this.displayPolicy.rowHdrDC.setFont(font);
        this.damageRowHeaders();
    }

    public int getRowHeaderHorizontalJustification() {
        return this.displayPolicy.rowHdrDC.getHorizontalJustification();
    }

    public void setRowHeaderHorizontalJustification(int n) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingRowHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setHorizontalJustification(n);
        }
        this.damageRowHeaders();
    }

    public void setRowHeaderHorizontalJustificationDefault(int n) {
        this.displayPolicy.rowHdrDC.setHorizontalJustification(n);
        this.damageRowHeaders();
    }

    public int getRowHeaderVerticalJustification() {
        return this.displayPolicy.rowHdrDC.getVerticalJustification();
    }

    public void setRowHeaderVerticalJustification(int n) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingRowHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setVerticalJustification(n);
        }
        this.damageRowHeaders();
    }

    public void setRowHeaderVerticalJustificationDefault(int n) {
        this.displayPolicy.rowHdrDC.setVerticalJustification(n);
        this.damageRowHeaders();
    }

    public JKDrawingPolicy getColumnDrawingPolicy(int n) {
        return this.displayPolicy.existingColumnDrawingContext(n).getDrawingPolicy();
    }

    public void setColumnDrawingPolicy(int n, JKDrawingPolicy jKDrawingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getColumnAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setDrawingPolicy(jKDrawingPolicy);
        }
        this.damageColumns(n, 1);
    }

    public JKDrawingPolicy getColumnSelectionDrawingPolicy(int n) {
        return this.displayPolicy.existingColumnDrawingContext(n).getSelectionDrawingPolicy();
    }

    public void setColumnSelectionDrawingPolicy(int n, JKDrawingPolicy jKDrawingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getColumnAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setSelectionDrawingPolicy(jKDrawingPolicy);
        }
        this.damageColumns(n, 1);
    }

    public Color getColumnBackColor(int n) {
        return this.displayPolicy.existingColumnDrawingContext(n).getBackColor();
    }

    public void setColumnBackColor(int n, Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getColumnAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBackColor(color);
        }
        this.damageColumns(n, 1);
    }

    public Color getColumnForeColor(int n) {
        return this.displayPolicy.existingColumnDrawingContext(n).getForeColor();
    }

    public void setColumnForeColor(int n, Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getColumnAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setForeColor(color);
        }
        this.damageColumns(n, 1);
    }

    public Color getColumnBorderColor(int n) {
        return this.displayPolicy.existingColumnDrawingContext(n).getBorderColor();
    }

    public void setColumnBorderColor(int n, Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getColumnAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBorderColor(color);
        }
        this.damageColumns(n, 1);
    }

    public Font getColumnFont(int n) {
        return this.displayPolicy.existingColumnDrawingContext(n).getFont();
    }

    public void setColumnFont(int n, Font font) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getColumnAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setFont(font);
        }
        this.damageColumns(n, 1);
    }

    public int getColumnHorizontalJustification(int n) {
        return this.displayPolicy.existingColumnDrawingContext(n).getHorizontalJustification();
    }

    public void setColumnHorizontalJustification(int n, int n2) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getColumnAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setHorizontalJustification(n2);
        }
        this.damageColumns(n, 1);
    }

    public int getColumnVerticalJustification(int n) {
        return this.displayPolicy.existingColumnDrawingContext(n).getVerticalJustification();
    }

    public void setColumnVerticalJustification(int n, int n2) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getColumnAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setVerticalJustification(n2);
        }
        this.damageColumns(n, 1);
    }

    public int getColumnScale(int n) {
        return this.displayPolicy.existingColumnDrawingContext(n).getScale();
    }

    public void setColumnScale(int n, int n2) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getColumnAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setScale(n2);
        }
        this.damageColumns(n, 1);
    }

    public JKDrawingContext getColumnDrawingContext(int n) {
        return this.displayPolicy.getColumnDrawingContext(n);
    }

    public void setColumnDrawingContext(int n, JKDrawingContext jKDrawingContext) {
        this.displayPolicy.setColumnDrawingContext(n, jKDrawingContext);
        this.damageColumns(n, 1);
    }

    public boolean getColumnHeaders() {
        return this.getNumberOfColumnHeaders() > 0;
    }

    public int getNumberOfColumnHeaders() {
        return 1 - this.coordinator.getFirstRowNumber();
    }

    public void setColumnHeaders(boolean bl) {
        this.setNumberOfColumnHeaders(bl ? 1 : 0);
    }

    public void setNumberOfColumnHeaders(int n) {
        int n2;
        int n3 = n > 0 ? n : 0;
        int n4 = this.getNumberOfColumnHeaders();
        if (n4 == n3) {
            return;
        }
        int n5 = 1 - n4;
        int n6 = 1 - n3;
        int n7 = this.dimensions.getVirtualY(n5);
        int n8 = n7 - (n2 = this.dimensions.getVirtualY(n6));
        if (n8 < -this.coordinator.getVirtualHeight(0)) {
            n8 = -this.coordinator.getVirtualHeight(0);
        }
        if (n8 == 0) {
            return;
        }
        this.coordinator.setVirtualY(n2);
        this.coordinator.adjustVirtualHeight(0, n2, n8);
        this.autoSizePolicy.reshaped();
        this.damageAll();
    }

    public int getNumberOfColumnFooters() {
        return this.coordinator.getLastRowNumber() - this.getModel().getNumberOfRows();
    }

    public void setNumberOfColumnFooters(int n) {
        int n2 = n > 0 ? n : 0;
        int n3 = this.getNumberOfColumnFooters();
        if (n3 == n2) {
            return;
        }
        if (this.coordinator.getNumberOfAdapterRows() < 3) {
            this.coordinator.setNumberOfAdapterRows(3);
        }
        int n4 = n3 + this.getModel().getNumberOfRows();
        int n5 = n2 + this.getModel().getNumberOfRows();
        int n6 = this.dimensions.getVirtualY(n4);
        int n7 = this.dimensions.getVirtualY(n5);
        int n8 = n7 - n6;
        if (n8 < -this.coordinator.getVirtualHeight(2)) {
            n8 = -this.coordinator.getVirtualHeight(2);
        }
        if (n8 == 0) {
            return;
        }
        this.coordinator.adjustVirtualHeight(2, n7, n8);
        if (this.coordinator.getVirtualHeight(2) == 0) {
            this.coordinator.setNumberOfAdapterRows(2);
        }
        this.autoSizePolicy.reshaped();
        this.damageAll();
    }

    public JKDrawingPolicy getColumnHeaderDrawingPolicy() {
        return this.displayPolicy.columnHdrDC.getDrawingPolicy();
    }

    public void setColumnHeaderDrawingPolicy(JKDrawingPolicy jKDrawingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingColumnHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setDrawingPolicy(jKDrawingPolicy);
        }
        this.damageColumnHeaders();
    }

    public void setColumnHeaderDrawingPolicyDefault(JKDrawingPolicy jKDrawingPolicy) {
        this.displayPolicy.columnHdrDC.setDrawingPolicy(jKDrawingPolicy);
        this.damageColumnHeaders();
    }

    public JKDrawingPolicy getColumnHeaderSelectionDrawingPolicy() {
        return this.displayPolicy.columnHdrDC.getSelectionDrawingPolicy();
    }

    public void setColumnHeaderSelectionDrawingPolicy(JKDrawingPolicy jKDrawingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingColumnHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setSelectionDrawingPolicy(jKDrawingPolicy);
        }
        this.damageColumnHeaders();
    }

    public void setColumnHeaderSelectionDrawingPolicyDefault(JKDrawingPolicy jKDrawingPolicy) {
        this.displayPolicy.columnHdrDC.setSelectionDrawingPolicy(jKDrawingPolicy);
        this.damageColumnHeaders();
    }

    public Color getColumnHeaderBackColor() {
        return this.displayPolicy.columnHdrDC.getBackColor();
    }

    public void setColumnHeaderBackColor(Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingColumnHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBackColor(color);
        }
        this.damageColumnHeaders();
    }

    public void setColumnHeaderBackColorDefault(Color color) {
        this.displayPolicy.columnHdrDC.setBackColor(color);
        this.damageColumnHeaders();
    }

    public Color getColumnHeaderForeColor() {
        return this.displayPolicy.columnHdrDC.getForeColor();
    }

    public void setColumnHeaderForeColor(Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingColumnHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setForeColor(color);
        }
        this.damageColumnHeaders();
    }

    public void setColumnHeaderForeColorDefault(Color color) {
        this.displayPolicy.columnHdrDC.setForeColor(color);
        this.damageColumnHeaders();
    }

    public Color getColumnHeaderBorderColor() {
        return this.displayPolicy.columnHdrDC.getBorderColor();
    }

    public void setColumnHeaderBorderColor(Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingColumnHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBorderColor(color);
        }
        this.damageColumnHeaders();
    }

    public void setColumnHeaderBorderColorDefault(Color color) {
        this.displayPolicy.columnHdrDC.setBorderColor(color);
        this.damageColumnHeaders();
    }

    public Font getColumnHeaderFont() {
        return this.displayPolicy.columnHdrDC.getFont();
    }

    public void setColumnHeaderFont(Font font) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingColumnHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setFont(font);
        }
        this.damageColumnHeaders();
    }

    public void setColumnHeaderFontDefault(Font font) {
        this.displayPolicy.columnHdrDC.setFont(font);
        this.damageColumnHeaders();
    }

    public int getColumnHeaderHorizontalJustification() {
        return this.displayPolicy.columnHdrDC.getHorizontalJustification();
    }

    public void setColumnHeaderHorizontalJustifcation(int n) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingColumnHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setHorizontalJustification(n);
        }
        this.damageColumnHeaders();
    }

    public void setColumnHeaderHorizontalJustificationDefault(int n) {
        this.displayPolicy.columnHdrDC.setHorizontalJustification(n);
        this.damageColumnHeaders();
    }

    public int getColumnHeaderVerticalJustification() {
        return this.displayPolicy.columnHdrDC.getVerticalJustification();
    }

    public void setColumnHeaderVerticalJustifcation(int n) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingColumnHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setVerticalJustification(n);
        }
        this.damageColumnHeaders();
    }

    public void setColumnHeaderVerticalJustificationDefault(int n) {
        this.displayPolicy.columnHdrDC.setVerticalJustification(n);
        this.damageColumnHeaders();
    }

    public int getColumnHeaderScale() {
        return this.displayPolicy.columnHdrDC.getScale();
    }

    public void setColumnHeaderScale(int n) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingColumnHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setScale(n);
        }
        this.damageColumnHeaders();
    }

    public void setColumnHeaderScaleDefault(int n) {
        this.displayPolicy.columnHdrDC.setScale(n);
        this.damageColumnHeaders();
    }

    public JKDrawingPolicy getCellDrawingPolicy(int n, int n2) {
        return this.displayPolicy.existingCellDrawingContext(n, n2).getDrawingPolicy();
    }

    public JKDrawingPolicy getCellAreaDrawingPolicy() {
        return this.displayPolicy.cellAreaDC.getDrawingPolicy();
    }

    public void setCellDrawingPolicy(int n, int n2, JKDrawingPolicy jKDrawingPolicy) {
        this.displayPolicy.getCellDrawingContext(n, n2).setDrawingPolicy(jKDrawingPolicy);
        this.damageCells(n, n2, 1, 1);
    }

    public void setCellAreaDrawingPolicy(JKDrawingPolicy jKDrawingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingCellAreaDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setDrawingPolicy(jKDrawingPolicy);
        }
        this.damageAll();
    }

    public void setCellAreaDrawingPolicyDefault(JKDrawingPolicy jKDrawingPolicy) {
        this.displayPolicy.cellAreaDC.setDrawingPolicy(jKDrawingPolicy);
        this.damageAll();
    }

    public JKDrawingPolicy getCellSelectionDrawingPolicy(int n, int n2) {
        return this.displayPolicy.existingCellDrawingContext(n, n2).getSelectionDrawingPolicy();
    }

    public JKDrawingPolicy getCellAreaSelectionDrawingPolicy() {
        return this.displayPolicy.cellAreaDC.getSelectionDrawingPolicy();
    }

    public void setCellSelectionDrawingPolicy(int n, int n2, JKDrawingPolicy jKDrawingPolicy) {
        this.displayPolicy.getCellDrawingContext(n, n2).setSelectionDrawingPolicy(jKDrawingPolicy);
        this.damageCells(n, n2, 1, 1);
    }

    public void setCellAreaSelectionDrawingPolicy(JKDrawingPolicy jKDrawingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingCellAreaDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setSelectionDrawingPolicy(jKDrawingPolicy);
        }
        this.damageAll();
    }

    public void setCellAreaSelectionDrawingPolicyDefault(JKDrawingPolicy jKDrawingPolicy) {
        this.displayPolicy.cellAreaDC.setSelectionDrawingPolicy(jKDrawingPolicy);
        this.damageAll();
    }

    public Color getCellBackColor(int n, int n2) {
        return this.displayPolicy.existingCellDrawingContext(n, n2).getBackColor();
    }

    public Color getCellAreaBackColor() {
        return this.displayPolicy.cellAreaDC.getBackColor();
    }

    public void setCellBackColor(int n, int n2, Color color) {
        this.displayPolicy.getCellDrawingContext(n, n2).setBackColor(color);
        this.damageCells(n, n2, 1, 1);
    }

    public void setCellAreaBackColor(Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingCellAreaDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBackColor(color);
        }
        this.damageAll();
    }

    public void setCellAreaBackColorDefault(Color color) {
        this.displayPolicy.cellAreaDC.setBackColor(color);
        this.damageAll();
    }

    public Color getCellForeColor(int n, int n2) {
        return this.displayPolicy.existingCellDrawingContext(n, n2).getForeColor();
    }

    public Color getCellAreaForeColor() {
        return this.displayPolicy.cellAreaDC.getForeColor();
    }

    public void setCellForeColor(int n, int n2, Color color) {
        this.displayPolicy.getCellDrawingContext(n, n2).setForeColor(color);
        this.damageCells(n, n2, 1, 1);
    }

    public void setCellAreaForeColor(Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingCellAreaDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setForeColor(color);
        }
        this.damageAll();
    }

    public void setCellAreaForeColorDefault(Color color) {
        this.displayPolicy.cellAreaDC.setForeColor(color);
        this.damageAll();
    }

    public Color getCellBorderColor(int n, int n2) {
        return this.displayPolicy.existingCellDrawingContext(n, n2).getBorderColor();
    }

    public Color getCellAreaBorderColor() {
        return this.displayPolicy.cellAreaDC.getBorderColor();
    }

    public void setCellBorderColor(int n, int n2, Color color) {
        this.displayPolicy.getCellDrawingContext(n, n2).setBorderColor(color);
        this.damageCells(n, n2, 1, 1);
    }

    public void setCellAreaBorderColor(Color color) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingCellAreaDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBorderColor(color);
        }
        this.damageAll();
    }

    public void setCellAreaBorderColorDefault(Color color) {
        this.displayPolicy.cellAreaDC.setBorderColor(color);
        this.damageAll();
    }

    public Font getCellFont(int n, int n2) {
        return this.displayPolicy.existingCellDrawingContext(n, n2).getFont();
    }

    public Font getCellAreaFont() {
        return this.displayPolicy.cellAreaDC.getFont();
    }

    public void setCellFont(int n, int n2, Font font) {
        this.displayPolicy.getCellDrawingContext(n, n2).setFont(font);
        this.damageCells(n, n2, 1, 1);
    }

    public void setCellAreaFont(Font font) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingCellAreaDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setFont(font);
        }
        this.damageAll();
    }

    public void setCellAreaFontDefault(Font font) {
        this.displayPolicy.cellAreaDC.setFont(font);
        this.damageAll();
    }

    public int getCellHorizontalJustification(int n, int n2) {
        return this.displayPolicy.existingCellDrawingContext(n, n2).getHorizontalJustification();
    }

    public int getCellAreaHorizontalJustification() {
        return this.displayPolicy.cellAreaDC.getHorizontalJustification();
    }

    public void setCellHorizontalJustification(int n, int n2, int n3) {
        this.displayPolicy.getCellDrawingContext(n, n2).setHorizontalJustification(n3);
        this.damageCells(n, n2, 1, 1);
    }

    public void setCellAreaHorizontalJustification(int n) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingCellAreaDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setHorizontalJustification(n);
        }
        this.damageAll();
    }

    public void setCellAreaHorizontalJustificationDefault(int n) {
        this.displayPolicy.cellAreaDC.setHorizontalJustification(n);
        this.damageAll();
    }

    public int getCellVerticalJustification(int n, int n2) {
        return this.displayPolicy.existingCellDrawingContext(n, n2).getVerticalJustification();
    }

    public int getCellAreaVerticalJustification() {
        return this.displayPolicy.cellAreaDC.getVerticalJustification();
    }

    public void setCellVerticalJustification(int n, int n2, int n3) {
        this.displayPolicy.getCellDrawingContext(n, n2).setVerticalJustification(n3);
        this.damageCells(n, n2, 1, 1);
    }

    public void setCellAreaVerticalJustification(int n) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingCellAreaDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setVerticalJustification(n);
        }
        this.damageAll();
    }

    public void setCellAreaVerticalJustificationDefault(int n) {
        this.displayPolicy.cellAreaDC.setVerticalJustification(n);
        this.damageAll();
    }

    public int getCellScale(int n, int n2) {
        return this.displayPolicy.existingCellDrawingContext(n, n2).getScale();
    }

    public int getCellAreaScale() {
        return this.displayPolicy.cellAreaDC.getScale();
    }

    public void setCellScale(int n, int n2, int n3) {
        this.displayPolicy.getCellDrawingContext(n, n2).setScale(n3);
        this.damageCells(n, n2, 1, 1);
    }

    public void setCellAreaScale(int n) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingCellAreaDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setScale(n);
        }
        this.damageAll();
    }

    public void setCellAreaScaleDefault(int n) {
        this.displayPolicy.cellAreaDC.setScale(n);
        this.damageAll();
    }

    public boolean getCellBorderRight() {
        return this.getCellBorderInsets().right > 0;
    }

    public void setCellBorderRight(boolean bl) {
        Insets insets = this.getCellBorderInsets();
        this.setCellBorderInsets(new Insets(insets.top, insets.left, insets.bottom, bl ? 1 : 0));
    }

    public void setCellBorderRightDefault(boolean bl) {
        Insets insets = this.getCellBorderInsets();
        this.setCellBorderInsetsDefault(new Insets(insets.top, insets.left, insets.bottom, bl ? 1 : 0));
    }

    public boolean getCellBorderBottom() {
        return this.getCellBorderInsets().bottom > 0;
    }

    public void setCellBorderBottom(boolean bl) {
        Insets insets = this.getCellBorderInsets();
        this.setCellBorderInsets(new Insets(insets.top, insets.left, bl ? 1 : 0, insets.right));
    }

    public void setCellBorderBottomDefault(boolean bl) {
        Insets insets = this.getCellBorderInsets();
        this.setCellBorderInsetsDefault(new Insets(insets.top, insets.left, bl ? 1 : 0, insets.right));
    }

    public Insets getCellBorderInsets() {
        return this.displayPolicy.cellAreaDC.getBorderInsets();
    }

    public void setCellBorderInsets(Insets insets) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingCellAreaDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setBorderInsets(insets);
        }
        this.damageAll();
    }

    public void setCellBorderInsetsDefault(Insets insets) {
        this.displayPolicy.cellAreaDC.setBorderInsets(insets);
        this.damageAll();
    }

    public Insets getCellContentInsets() {
        return this.displayPolicy.cellAreaDC.getContentInsets();
    }

    public void setCellContentInsets(Insets insets) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingCellAreaDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setContentInsets(insets);
        }
        this.damageAll();
    }

    public void setCellContentInsetsDefault(Insets insets) {
        this.displayPolicy.cellAreaDC.setContentInsets(insets);
        this.damageAll();
    }

    public void setCellBorders(boolean bl, boolean bl2) {
        this.setCellBorderRight(bl);
        this.setCellBorderBottom(bl2);
    }

    public JKDrawingContext getCellDrawingContext(int n, int n2) {
        return this.displayPolicy.getCellDrawingContext(n, n2);
    }

    public JKDrawingContext getCellAreaDrawingContext() {
        return this.displayPolicy.cellAreaDC;
    }

    public void setCellDrawingContext(int n, int n2, JKDrawingContext jKDrawingContext) {
        this.displayPolicy.setCellDrawingContext(n, n2, jKDrawingContext);
        this.damageCells(n, n2, 1, 1);
    }

    public void setCellAreaDrawingContext(JKDrawingContext jKDrawingContext) {
        this.displayPolicy.cellAreaDC = jKDrawingContext;
        this.damageAll();
    }

    public int getFirstVisibleColumn() {
        return this.coordinator.getFirstVisibleColumn(1);
    }

    public int getLastVisibleColumn() {
        return this.coordinator.getLastVisibleColumn(1);
    }

    public int getNumberOfVisibleColumns() {
        return this.coordinator.getNumberOfVisibleColumns(1);
    }

    public int getFirstVisibleColumn(String string) {
        return this.coordinator.getFirstVisibleColumn(1, string);
    }

    public int getLastVisibleColumn(String string) {
        return this.coordinator.getLastVisibleColumn(1, string);
    }

    public int getNumberOfVisibleColumns(String string) {
        return this.coordinator.getNumberOfVisibleColumns(1, string);
    }

    public int getFirstVisibleColumn(int n) {
        return this.coordinator.getFirstVisibleColumn(1, n);
    }

    public int getLastVisibleColumn(int n) {
        return this.coordinator.getLastVisibleColumn(1, n);
    }

    public int getNumberOfVisibleColumns(int n) {
        return this.coordinator.getNumberOfVisibleColumns(1, n);
    }

    public void scrollHorizontalTo(int n) {
        this.scrollToColumn(n);
    }

    public void scrollToColumn(int n) {
        this.coordinator.scrollToColumn(1, "java.lang.Object", n);
    }

    public void scrollToColumn(String string, int n) {
        this.coordinator.scrollToColumn(1, string, n);
    }

    public void scrollToColumn(int n, int n2) {
        this.coordinator.scrollToColumn(1, n, n2);
    }

    public boolean isColumnVisible(int n) {
        return this.coordinator.isColumnVisible(n);
    }

    public boolean isColumnVisible(String string, int n) {
        return this.coordinator.isColumnVisible(string, n);
    }

    public boolean isColumnVisible(int n, int n2) {
        return this.coordinator.isColumnVisible(n, n2);
    }

    public void keepColumnVisible(int n) {
        this.coordinator.keepColumnVisible(n);
    }

    public void keepColumnVisible(String string, int n) {
        this.coordinator.keepColumnVisible(string, n);
    }

    public void keepColumnVisible(int n, int n2) {
        this.coordinator.keepColumnVisible(n, n2);
    }

    public int getFirstVisibleRow() {
        return this.coordinator.getFirstVisibleRow(1);
    }

    public int getLastVisibleRow() {
        return this.coordinator.getLastVisibleRow(1);
    }

    public int getNumberOfVisibleRows() {
        return this.coordinator.getNumberOfVisibleRows(1);
    }

    public void scrollVerticalTo(int n) {
        this.scrollToRow(n);
    }

    public void scrollToRow(int n) {
        this.coordinator.scrollToRow(1, n);
    }

    public boolean isRowVisible(int n) {
        return this.coordinator.isRowVisible(n);
    }

    public void keepRowVisible(int n) {
        this.coordinator.keepRowVisible(n);
    }

    public void keepRowsVisible(int n, int n2) {
        this.coordinator.keepRowsVisible(n, n2);
    }

    public void scrollTo(int n, int n2) {
        this.scrollToCell(n2, n);
    }

    public void scrollToCell(int n, int n2) {
        this.coordinator.scrollToCell(1, 1, n, n2);
    }

    public boolean isCellVisible(int n, int n2) {
        return this.coordinator.isCellVisible(n, n2);
    }

    public void keepCellVisible(int n, int n2) {
        this.coordinator.keepCellVisible(n, n2);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public Dimension preferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(int n, int n2) {
        this.setPreferredSize(new Dimension(n, n2));
    }

    public void setPreferredSize(Dimension dimension) {
        if (dimension != null) {
            this.preferredSize = dimension;
        }
    }

    public Insets insets() {
        Insets insets = super.insets();
        return new Insets(insets.top + 1, insets.left + 1, insets.bottom + 1, insets.right + 1);
    }

    public void damageAll() {
        this.coordinator.damageAll();
        this.getRepairPolicy().damaged();
    }

    public void damageHeaders() {
        this.disableRepair();
        this.damageRowHeaders();
        this.damageColumnHeaders();
        this.enableRepair();
        this.getRepairPolicy().damaged();
    }

    public void damageRowHeaders() {
        int n = this.coordinator.getFirstColumnNumber();
        if (n < 1) {
            this.damageColumns(n, 1 - n);
        }
    }

    public void damageColumnHeaders() {
        int n = this.coordinator.getFirstRowNumber();
        if (n < 1) {
            this.damageRows(n, 1 - n);
        }
    }

    public void damageRows(int n, int n2) {
        this.damageArea(JKTableArea.newForRows(n, n2));
    }

    public void damageColumns(int n, int n2) {
        this.damageArea(JKTableArea.newForColumns(n, n2));
    }

    public void damageColumns(String string, int n, int n2) {
        this.damageArea(string, JKTableArea.newForColumns(n, n2));
    }

    public void damageColumns(int n, int n2, int n3) {
        this.damageArea(this.getModel().getRowType(n), JKTableArea.newForColumns(n2, n3));
    }

    public void damageCells(int n, int n2, int n3, int n4) {
        this.damageArea(JKTableArea.newForCells(n2, n, n4, n3));
    }

    public void damageArea(JKTableArea jKTableArea) {
        this.damageArea("java.lang.Object", jKTableArea);
    }

    public void damageArea(String string, JKTableArea jKTableArea) {
        this.damageVirtualRegion(jKTableArea.asVirtualBoundary(this.dimensions, string, this.coordinator.getVirtualBounds()));
    }

    public void damageVirtualRegion(int n, int n2, int n3, int n4) {
        this.damageVirtualRegion(new Rectangle(n, n2, n3, n4));
    }

    public void damageVirtualRegion(Rectangle rectangle) {
        this.coordinator.damageVirtualRegion(rectangle);
        this.getRepairPolicy().damaged();
    }

    public void damageScreenRegion(int n, int n2, int n3, int n4) {
        this.damageScreenRegion(new Rectangle(n, n2, n3, n4));
    }

    public void damageScreenRegion(Rectangle rectangle) {
        this.coordinator.damageScreenRegion(rectangle);
        this.getRepairPolicy().damaged();
    }

    public void disableRepair() {
        this.getCoordinator().disableRepair();
    }

    public void enableRepair() {
        this.getCoordinator().enableRepair();
    }

    public void repairDamage() {
        this.getCoordinator().repairDamage();
    }

    public Rectangle screenBounds() {
        return new Rectangle(0, 0, ((Component)((Object)this)).size().width, ((Component)((Object)this)).size().height);
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        Dimension dimension = ((Component)((Object)this)).size();
        super.reshape(n, n2, n3, n4);
        if (dimension.width != n3 || dimension.height != n4) {
            this.autoSizePolicy.reshaped();
            ((Component)((Object)this)).repaint();
        }
    }

    public void repaintHeaders() {
        this.repaintRowHeaders();
        this.repaintColumnHeaders();
    }

    public void repaintRowHeaders() {
        int n = this.coordinator.getFirstColumnNumber();
        if (n < 1) {
            this.repaintColumns(n, 1 - n);
        }
    }

    public void repaintColumnHeaders() {
        int n = this.coordinator.getFirstRowNumber();
        if (n < 1) {
            this.repaintRows(n, 1 - n);
        }
    }

    public void repaintRows(int n, int n2) {
        this.coordinator.repaintRows(n, n2);
    }

    public void repaintColumns(int n, int n2) {
        this.coordinator.repaintColumns(n, n2);
    }

    public void repaintColumns(String string, int n, int n2) {
        this.coordinator.repaintColumns(string, n, n2);
    }

    public void repaintColumns(int n, int n2, int n3) {
        this.coordinator.repaintColumns(n, n2, n3);
    }

    public void repaintCells(int n, int n2, int n3, int n4) {
        this.coordinator.repaintCells(n2, n, n4, n3);
    }

    public void repaint(JKTableArea jKTableArea) {
        this.coordinator.repaintVirtual(jKTableArea.asVirtualBoundary(this.dimensions, this.coordinator.getVirtualBounds()));
    }

    public void repaint(Rectangle rectangle) {
        ((Component)((Object)this)).repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipRect();
        if (rectangle == null) {
            return;
        }
        if (this.debugPaintColor != null) {
            Color color = graphics.getColor();
            graphics.setColor(this.debugPaintColor);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
            int n = 100000;
            while (--n > 0) {
            }
        }
        this.coordinator.paint(graphics);
    }

    public void paintCanvas(Graphics graphics) {
        this.paintWelcome(graphics);
    }

    protected void applyDrawingAdapters(OSIEnumeration oSIEnumeration) {
        if (oSIEnumeration != null) {
            while (oSIEnumeration.hasMoreElements()) {
                Object object = oSIEnumeration.nextElement();
                if (!(object instanceof JKDrawingAdapter)) continue;
                ((JKDrawingAdapter)object).applyTo(this);
            }
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (!this.processWelcomeEvent(aWTEvent)) {
            JKEvent jKEvent;
            super.processEvent(aWTEvent);
            if (this.callHandleEvent && !this.handleEventCalled && (jKEvent = JKAWTEvent.convertToOld(aWTEvent, null)) != null) {
                this.handleEvent(jKEvent);
            }
            this.handleEventCalled = false;
        }
    }

    public boolean handleEvent(Event event) {
        this.handleEventCalled = true;
        return super.handleEvent(event);
    }

    public JKAutoSizePolicy getAutoSizePolicy() {
        return this.autoSizePolicy;
    }

    public void setAutoSizePolicy(JKAutoSizePolicy jKAutoSizePolicy) {
        this.autoSizePolicy = jKAutoSizePolicy;
    }

    public void autoSize() {
        this.dimensions.setAllUserSizableRowsAutoSizable();
        this.dimensions.setAllUserSizableColumnsAutoSizable();
        this.autoSizePolicy.autoSize();
        this.damageAll();
    }

    public Point cellForPoint(int n, int n2) {
        return this.getCell(n, n2);
    }

    public Point getCell(int n, int n2) {
        JKTableViewAdapter jKTableViewAdapter = this.coordinator.getAdapterForScreen(n, n2);
        if (jKTableViewAdapter == null) {
            return null;
        }
        return jKTableViewAdapter.getCellOrNull(n, n2);
    }

    public Rectangle rectangleForCell(int n, int n2) {
        return this.getCellBounds(n2, n);
    }

    public Rectangle getCellBounds(int n, int n2) {
        JKTableViewAdapter jKTableViewAdapter = this.coordinator.getAdapterForCell(n, n2);
        Rectangle rectangle = this.basicCellBounds(n, n2, jKTableViewAdapter);
        if (rectangle != null) {
            rectangle = rectangle.intersection(jKTableViewAdapter.getScreenContentBounds());
        }
        return rectangle;
    }

    public Rectangle basicCellBounds(int n, int n2) {
        return this.basicCellBounds(n, n2, this.coordinator.getAdapterForCell(n, n2));
    }

    final Rectangle basicCellBounds(int n, int n2, JKTableViewAdapter jKTableViewAdapter) {
        if (jKTableViewAdapter == null) {
            return null;
        }
        return jKTableViewAdapter.getCellScreenBounds(n, n2);
    }

    public Rectangle getCellContentBounds(int n, int n2) {
        JKTableViewAdapter jKTableViewAdapter = this.coordinator.getAdapterForCell(n, n2);
        Rectangle rectangle = this.basicCellContentBounds(n, n2, jKTableViewAdapter);
        if (rectangle != null) {
            rectangle = rectangle.intersection(jKTableViewAdapter.getScreenContentBounds());
        }
        return rectangle;
    }

    public Rectangle basicCellContentBounds(int n, int n2) {
        return this.basicCellContentBounds(n, n2, this.coordinator.getAdapterForCell(n, n2));
    }

    public Rectangle basicCellContentBounds(int n, int n2, JKTableViewAdapter jKTableViewAdapter) {
        if (jKTableViewAdapter == null) {
            return null;
        }
        return jKTableViewAdapter.getCellScreenContentBounds(n, n2);
    }

    public void modelChanged(JKModelChangedEvent jKModelChangedEvent) {
        this.dimensions.modelChanged(jKModelChangedEvent);
        this.coordinator.modelChanged(jKModelChangedEvent);
        this.displayPolicy.modelChanged(jKModelChangedEvent);
        this.autoSizePolicy.modelChanged(jKModelChangedEvent);
        JKTableArea jKTableArea = jKModelChangedEvent.getArea();
        if (jKTableArea instanceof JKRowArea) {
            this.damageRows(((JKRowArea)jKTableArea).y, ((JKRowArea)jKTableArea).height);
            return;
        }
        if (jKTableArea instanceof JKColumnArea) {
            this.damageColumns(((JKColumnArea)jKTableArea).x, ((JKColumnArea)jKTableArea).width);
            return;
        }
        if (jKTableArea instanceof JKRectangularArea) {
            this.damageCells(((JKRectangularArea)jKTableArea).y, ((JKRectangularArea)jKTableArea).x, ((JKRectangularArea)jKTableArea).height, ((JKRectangularArea)jKTableArea).width);
            return;
        }
        if (jKTableArea != JKTableArea.empty) {
            this.damageAll();
        }
    }

    public void modelRowsChanged(JKModelRowsChangedEvent jKModelRowsChangedEvent) {
        this.coordinator.modelRowsChanged(jKModelRowsChangedEvent);
        this.dimensions.modelRowsChanged(jKModelRowsChangedEvent);
        this.displayPolicy.modelRowsChanged(jKModelRowsChangedEvent);
        this.applyDrawingAdapters(jKModelRowsChangedEvent.getCachedAdaptersAdded());
        this.autoSizePolicy.modelRowsChanged(jKModelRowsChangedEvent);
        this.damageRows(jKModelRowsChangedEvent.getFirst(), jKModelRowsChangedEvent.getSize());
    }

    public void modelRowsAdded(JKModelRowsAddedEvent jKModelRowsAddedEvent) {
        this.dimensions.modelRowsAdded(jKModelRowsAddedEvent);
        this.coordinator.modelRowsAdded(jKModelRowsAddedEvent);
        this.displayPolicy.modelRowsAdded(jKModelRowsAddedEvent);
        this.applyDrawingAdapters(jKModelRowsAddedEvent.getCachedAdaptersAdded());
        this.autoSizePolicy.modelRowsAdded(jKModelRowsAddedEvent);
        this.getRepairPolicy().damaged();
    }

    public void modelRowsRemoved(JKModelRowsRemovedEvent jKModelRowsRemovedEvent) {
        this.coordinator.modelRowsRemoved(jKModelRowsRemovedEvent);
        this.dimensions.modelRowsRemoved(jKModelRowsRemovedEvent);
        this.displayPolicy.modelRowsRemoved(jKModelRowsRemovedEvent);
        this.autoSizePolicy.modelRowsRemoved(jKModelRowsRemovedEvent);
        this.getRepairPolicy().damaged();
    }

    public void modelRowsReordered(JKModelRowsReorderEvent jKModelRowsReorderEvent) {
        this.coordinator.modelRowsReordered(jKModelRowsReorderEvent);
        this.dimensions.modelRowsReordered(jKModelRowsReorderEvent);
        this.displayPolicy.modelRowsReordered(jKModelRowsReorderEvent);
        this.autoSizePolicy.modelRowsReordered(jKModelRowsReorderEvent);
        this.damageRows(jKModelRowsReorderEvent.getFirst(), jKModelRowsReorderEvent.getSize());
    }

    public void modelColumnsChanged(JKModelColsChangedEvent jKModelColsChangedEvent) {
        this.coordinator.modelColumnsChanged(jKModelColsChangedEvent);
        this.dimensions.modelColumnsChanged(jKModelColsChangedEvent);
        this.displayPolicy.modelColumnsChanged(jKModelColsChangedEvent);
        this.applyDrawingAdapters(jKModelColsChangedEvent.getAdded());
        this.autoSizePolicy.modelColumnsChanged(jKModelColsChangedEvent);
        this.damageColumns(jKModelColsChangedEvent.getFirst(), jKModelColsChangedEvent.getSize());
    }

    public void modelColumnsAdded(JKModelColsAddedEvent jKModelColsAddedEvent) {
        this.dimensions.modelColumnsAdded(jKModelColsAddedEvent);
        this.coordinator.modelColumnsAdded(jKModelColsAddedEvent);
        this.displayPolicy.modelColumnsAdded(jKModelColsAddedEvent);
        this.applyDrawingAdapters(jKModelColsAddedEvent.getAdded());
        this.autoSizePolicy.modelColumnsAdded(jKModelColsAddedEvent);
        this.getRepairPolicy().damaged();
    }

    public void modelColumnsRemoved(JKModelColsRemovedEvent jKModelColsRemovedEvent) {
        this.coordinator.modelColumnsRemoved(jKModelColsRemovedEvent);
        this.dimensions.modelColumnsRemoved(jKModelColsRemovedEvent);
        this.displayPolicy.modelColumnsRemoved(jKModelColsRemovedEvent);
        this.autoSizePolicy.modelColumnsRemoved(jKModelColsRemovedEvent);
        this.autoSize();
        this.getRepairPolicy().damaged();
    }

    public void modelColumnsReordered(JKModelColsReorderEvent jKModelColsReorderEvent) {
        this.coordinator.modelColumnsReordered(jKModelColsReorderEvent);
        this.dimensions.modelColumnsReordered(jKModelColsReorderEvent);
        this.displayPolicy.modelColumnsReordered(jKModelColsReorderEvent);
        this.autoSizePolicy.modelColumnsReordered(jKModelColsReorderEvent);
        this.damageColumns(jKModelColsReorderEvent.getFirst(), jKModelColsReorderEvent.getSize());
    }

    public void aboutToScroll(int n, int n2, int n3, int n4) {
    }

    public void scrolled(int n, int n2, int n3, int n4) {
    }

    public void rowHeightChanged(int n, int n2, int n3) {
        this.coordinator.rowHeightChanged(n, n2, n3);
    }

    public void rowHeightsChanged(OSIIntToIntHashtable oSIIntToIntHashtable, OSIIntToIntHashtable oSIIntToIntHashtable2) {
        this.coordinator.rowHeightsChanged(oSIIntToIntHashtable, oSIIntToIntHashtable2);
    }

    public void columnWidthChanged(String string, int n, int n2, int n3) {
        this.coordinator.columnWidthChanged(string, n, n2, n3);
    }

    public void columnWidthsChanged(String string, OSIIntToIntHashtable oSIIntToIntHashtable, OSIIntToIntHashtable oSIIntToIntHashtable2) {
        this.coordinator.columnWidthsChanged(string, oSIIntToIntHashtable, oSIIntToIntHashtable2);
    }

    public void addDrawViewListener(JKDrawViewListener jKDrawViewListener) {
        this.drawViewListener = JKDrawViewMulticaster.add(this.drawViewListener, jKDrawViewListener);
    }

    public void removeDrawViewListener(JKDrawViewListener jKDrawViewListener) {
        this.drawViewListener = JKDrawViewMulticaster.remove(this.drawViewListener, jKDrawViewListener);
    }

    public void addJKDrawViewListener(JKDrawViewListener jKDrawViewListener) {
        this.drawViewListener = JKDrawViewMulticaster.add(this.drawViewListener, jKDrawViewListener);
    }

    public void removeJKDrawViewListener(JKDrawViewListener jKDrawViewListener) {
        this.drawViewListener = JKDrawViewMulticaster.remove(this.drawViewListener, jKDrawViewListener);
    }

    public void triggerDrawCell(JKDrawViewEvent jKDrawViewEvent) {
        if (this.drawViewListener != null) {
            this.drawViewListener.jkDrawCell(jKDrawViewEvent);
        }
        jKDrawViewEvent.draw();
    }

    public void triggerCellExtent(JKDrawViewEvent jKDrawViewEvent) {
        if (this.drawViewListener != null) {
            this.drawViewListener.jkCellExtent(jKDrawViewEvent);
        }
    }

    public JKTableViewAdapter newAdapter(int n, int n2, Rectangle rectangle, Rectangle rectangle2) {
        return new JKTableViewAdapter(this, n, n2, rectangle, rectangle2);
    }

    private void paintWelcome(Graphics graphics) {
        if (this.welcomePageNum >= welcomeText.length) {
            return;
        }
        Rectangle rectangle = welcomeBoxes[this.welcomePageNum];
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x - 3, rectangle.y - 3, rectangle.width + 5, rectangle.height + 5);
        graphics.setColor(Color.white);
        graphics.drawRect(rectangle.x - 2, rectangle.y - 2, rectangle.width + 3, rectangle.height + 3);
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
        graphics.setColor(Color.white);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        JKDrawViewEvent.drawString(welcomeText[this.welcomePageNum], rectangle, graphics, (Component)((Object)this), welcomeFonts[this.welcomePageNum], Color.black, null, 2, 2);
    }

    private final void initWelcome() {
        Container container = ((Component)((Object)this)).getParent();
        if (!(container instanceof Applet)) {
            return;
        }
        try {
            URL uRL = ((Applet)container).getCodeBase();
            if (uRL == null) {
                return;
            }
            String string = uRL.getHost();
            if (!string.equals("www.objectshare.com") && !string.equals("www.netsmart.com")) {
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        this.welcomePageNum = welcomeText.length;
    }

    private final boolean processWelcomeEvent(AWTEvent aWTEvent) {
        if (this.welcomePageNum >= welcomeText.length) {
            return false;
        }
        if (!(aWTEvent instanceof MouseEvent)) {
            return false;
        }
        MouseEvent cfr_ignored_0 = (MouseEvent)aWTEvent;
        switch (aWTEvent.getID()) {
            case 500: {
                Rectangle rectangle = welcomeBoxes[this.welcomePageNum];
                this.disableRepair();
                this.damageScreenRegion(rectangle.x - 3, rectangle.y - 3, rectangle.width + 6, rectangle.height + 6);
                ++this.welcomePageNum;
                if (this.welcomePageNum < welcomeText.length) {
                    rectangle = welcomeBoxes[this.welcomePageNum];
                    this.damageScreenRegion(rectangle.x - 3, rectangle.y - 3, rectangle.width + 6, rectangle.height + 6);
                }
                this.enableRepair();
                this.repairDamage();
            }
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                return true;
            }
        }
        return false;
    }
}

