/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.example.howto.observer;

import com.objectshare.grid.area.JKTableArea;
import com.objectshare.grid.data.JKRowAdapter;
import com.objectshare.grid.data.JKTableModel;
import com.objectshare.grid.example.JKExampleFrame;
import com.objectshare.grid.example.howto.JKTableListHowTo;
import com.objectshare.grid.example.howto.observer.RealEstateListing;
import com.objectshare.grid.list.JKNoSelectionException;
import com.objectshare.grid.list.JKSelectionEvent;
import com.objectshare.grid.list.JKSelectionListener;
import com.objectshare.grid.tool.JKSingleRowSelectTool;
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;

public class ObserverExample
extends JKTableListHowTo
implements JKSelectionListener {
    JKTableModel model = new JKTableModel();
    Button lowerPriceButton = new Button("Lower Price");
    Button deleteRowsButton = new Button("Delete Selected Rows");

    public static void main(String[] stringArray) {
        ObserverExample observerExample = new ObserverExample();
        new JKExampleFrame(observerExample, "Observer Example", 660, 200);
    }

    protected void initTable() {
        super.initTable();
        this.table.setBasicBackground(new Color(150, 180, 230));
        this.table.setModel(this.model);
        this.addSpecs();
        this.addRows();
        this.table.setCellAreaTool(new JKSingleRowSelectTool());
        this.table.setHorizontalJustification(JKTableArea.newForColumns(3, 2), 3);
        this.table.setHorizontalJustification(JKTableArea.newForColumn(5), 2);
        this.table.setHorizontalJustification(JKTableArea.newForColumn(6), 3);
        this.table.setForeColor(JKTableArea.newForCells(1, 1, 2, 2), new Color(20, 120, 97));
        this.table.setForeColor(JKTableArea.newForCells(1, 1, 2, 2), new Color(150, 0, 180));
        this.table.addJKSelectionListener(this);
    }

    protected void initControls() {
        this.controls.add(this.lowerPriceButton);
        this.controls.add(this.deleteRowsButton);
        this.resetButtons();
        super.initControls();
    }

    public void resetButtons() {
        int[] nArray = this.table.selectedRowIndices();
        if (nArray.length == 1) {
            this.lowerPriceButton.enable();
        } else {
            this.lowerPriceButton.disable();
        }
        if (nArray.length > 0) {
            this.deleteRowsButton.enable();
            return;
        }
        this.deleteRowsButton.disable();
    }

    public void jkSelected(JKSelectionEvent jKSelectionEvent) {
        this.resetButtons();
    }

    public void jkSelecting(JKSelectionEvent jKSelectionEvent) {
    }

    protected void addSpecs() {
        this.model.addColumnsOnce(RealEstateListing.columnSpecs);
    }

    protected void addRows() {
        JKRowAdapter.addRowAdapterAssociation("com.objectshare.grid.example.howto.observer.RealEstateListing", "com.objectshare.grid.data.JKTableElementJKRA");
        RealEstateListing realEstateListing = new RealEstateListing("cozy cottage", "676 Twisted Lane", 100000, 1, "none", 1500);
        this.model.addRow(realEstateListing);
        RealEstateListing realEstateListing2 = new RealEstateListing("lake view", "13455 Scenic Vista Way", 1500000, 5, "good", 15000);
        this.model.addRow(realEstateListing2);
        RealEstateListing realEstateListing3 = new RealEstateListing("mountain hide-away", "RR 3", 2500000, 790, "ok", 2500);
        this.model.addRow(realEstateListing3);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Button) {
            Button button = (Button)event.target;
            if (button.getLabel().equals("Lower Price")) {
                this.lowerPrice(event, object);
            }
            if (button.getLabel().equals("Delete Selected Rows")) {
                this.deleteRows(event);
            }
        }
        return super.action(event, object);
    }

    public void lowerPrice(Event event, Object object) {
        try {
            RealEstateListing realEstateListing = (RealEstateListing)this.table.selectedRowObject();
            realEstateListing.lowerPrice();
            return;
        }
        catch (JKNoSelectionException jKNoSelectionException) {
            System.out.println("no object selected");
            return;
        }
    }

    public void deleteRows(Event event) {
        int[] nArray = this.table.selectedRowIndices();
        if (nArray.length > 0) {
            this.model.removeRows(nArray[0], nArray.length);
        }
        this.resetButtons();
    }
}

