/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.edit;

import com.objectshare.grid.edit.JKEditAction;
import com.objectshare.grid.edit.JKEditingPolicy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;

public class JKTextFieldEditingPolicy
extends JKEditingPolicy {
    public Object edit(JKEditAction jKEditAction, Object object) {
        TextField textField = (TextField)this.edit(jKEditAction, object, "java.awt.TextField");
        ((TextComponent)textField).setText(object != null ? object.toString() : "");
        return textField;
    }

    public void requestEditorFocus(JKEditAction jKEditAction, Object object) {
        super.requestEditorFocus(jKEditAction, object);
        if (object instanceof TextField) {
            TextField textField = (TextField)object;
            String string = textField.getText();
            ((TextComponent)textField).setText(string);
            ((TextField)object).selectAll();
        }
    }

    public Boolean handleEvent(Event event, JKEditAction jKEditAction) {
        switch (event.id) {
            case 401: {
                if (event.key != 10) break;
                jKEditAction.validate();
                return Boolean.TRUE;
            }
            case 403: {
                switch (event.key) {
                    case 1000: 
                    case 1001: 
                    case 1002: 
                    case 1003: 
                    case 1004: 
                    case 1005: 
                    case 1006: 
                    case 1007: {
                        if (event.controlDown() || event.metaDown()) {
                            return null;
                        }
                        return Boolean.FALSE;
                    }
                }
                return Boolean.TRUE;
            }
        }
        return super.handleEvent(event, jKEditAction);
    }

    public boolean validate(JKEditAction jKEditAction, Object object) {
        if (object instanceof TextField) {
            jKEditAction.currentValue = ((TextField)object).getText();
        }
        return true;
    }

    public Rectangle editFrame(Rectangle rectangle, JKEditAction jKEditAction) {
        Rectangle rectangle2 = rectangle;
        if (jKEditAction.editor instanceof Component) {
            Dimension dimension = ((Component)jKEditAction.editor).preferredSize();
            if (dimension.height > rectangle2.height) {
                int n = dimension.height - rectangle2.height;
                rectangle2.x -= n / 2;
                rectangle2.y -= n / 2;
                rectangle2.width += n;
                rectangle2.height += n;
            }
        }
        return rectangle2;
    }
}

