/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.edit;

import com.objectshare.grid.edit.JKEditAction;
import com.objectshare.grid.edit.JKEditEvent;
import com.objectshare.grid.edit.JKReadOnlyEditingPolicy;
import com.objectshare.grid.edit.JKTableEdit;
import com.objectshare.grid.edit.JKVetoEditException;
import com.objectshare.grid.list.JKFocusEvent;
import com.objectshare.grid.list.JKItemEvent;
import com.objectshare.grid.list.JKKeyEvent;
import com.objectshare.grid.list.JKMouseEvent;
import java.awt.Component;
import java.awt.Event;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;

public class JKEditingPolicy
implements Serializable {
    public static final JKEditingPolicy READ_ONLY = JKReadOnlyEditingPolicy.readOnly;
    public boolean showEditorOnMouseDown = false;

    public static final boolean isValid(Object object) {
        return object != READ_ONLY && object instanceof JKEditingPolicy;
    }

    public void cacheEditor(JKTableEdit jKTableEdit) {
    }

    public Object getEditor(JKEditEvent jKEditEvent) {
        return this.edit(jKEditEvent.getEditAction(), jKEditEvent.getOldValue());
    }

    public void initEditor(JKEditEvent jKEditEvent) {
        if (jKEditEvent.getEditor() instanceof Component) {
            this.setupEdit(jKEditEvent.getEditAction(), (Component)jKEditEvent.getEditor());
        }
    }

    public void openEditor(JKEditEvent jKEditEvent) {
        if (jKEditEvent.getEditor() instanceof Component) {
            jKEditEvent.addMouseListener();
            jKEditEvent.addKeyListener();
            jKEditEvent.addFocusListener();
        }
    }

    public void showEditor(JKEditEvent jKEditEvent) {
        if (jKEditEvent.getEditor() instanceof Component) {
            ((Component)jKEditEvent.getEditor()).show();
        }
    }

    public void requestEditorFocus(JKEditEvent jKEditEvent) {
        this.requestEditorFocus(jKEditEvent.getEditAction(), jKEditEvent.getEditor());
    }

    public void moveEditor(JKEditEvent jKEditEvent, int n, int n2) {
        if (jKEditEvent.getEditor() instanceof Component) {
            Component component = (Component)jKEditEvent.getEditor();
            component.bounds();
            component.move(component.location().x - n, component.location().y - n2);
        }
    }

    public void reshapeEditor(JKEditEvent jKEditEvent, Rectangle rectangle) {
        if (jKEditEvent.getEditor() instanceof Component) {
            Rectangle rectangle2 = this.editFrame(rectangle, jKEditEvent.getEditAction());
            ((Component)jKEditEvent.getEditor()).reshape(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
    }

    public Object getEditorValue(JKEditEvent jKEditEvent) {
        return jKEditEvent.getNewValue();
    }

    public void setEditorValue(JKEditEvent jKEditEvent) {
    }

    public boolean equalValues(JKEditEvent jKEditEvent) {
        return jKEditEvent.getOldValue() == jKEditEvent.getNewValue();
    }

    public boolean validateEditorValue(JKEditEvent jKEditEvent) throws JKVetoEditException {
        if (!this.validate(jKEditEvent.getEditAction(), jKEditEvent.getEditor())) {
            throw new JKVetoEditException("invalid cell editor value");
        }
        return true;
    }

    public void hideEditor(JKEditEvent jKEditEvent) {
        if (jKEditEvent.getEditor() instanceof Component) {
            ((Component)jKEditEvent.getEditor()).hide();
        }
    }

    public void closeEditor(JKEditEvent jKEditEvent) {
        if (jKEditEvent.getEditor() instanceof Component) {
            jKEditEvent.removeMouseListener();
            jKEditEvent.removeKeyListener();
            jKEditEvent.removeFocusListener();
        }
    }

    public void itemStateChanged(JKEditEvent jKEditEvent, JKItemEvent jKItemEvent) {
        Event event = jKItemEvent.getOldEvent();
        if (event != null) {
            this.handleEvent(event, jKEditEvent.getEditAction());
        }
    }

    public void mouseClicked(JKEditEvent jKEditEvent, JKMouseEvent jKMouseEvent) {
        Event event = jKMouseEvent.getOldEvent();
        if (event != null) {
            this.handleEvent(event, jKEditEvent.getEditAction());
        }
    }

    public void mousePressed(JKEditEvent jKEditEvent, JKMouseEvent jKMouseEvent) {
        Event event = jKMouseEvent.getOldEvent();
        if (event != null) {
            this.handleEvent(event, jKEditEvent.getEditAction());
        }
    }

    public void mouseReleased(JKEditEvent jKEditEvent, JKMouseEvent jKMouseEvent) {
        Event event = jKMouseEvent.getOldEvent();
        if (event != null) {
            this.handleEvent(event, jKEditEvent.getEditAction());
        }
    }

    public void mouseEntered(JKEditEvent jKEditEvent, JKMouseEvent jKMouseEvent) {
        Event event = jKMouseEvent.getOldEvent();
        if (event != null) {
            this.handleEvent(event, jKEditEvent.getEditAction());
        }
    }

    public void mouseExited(JKEditEvent jKEditEvent, JKMouseEvent jKMouseEvent) {
        Event event = jKMouseEvent.getOldEvent();
        if (event != null) {
            this.handleEvent(event, jKEditEvent.getEditAction());
        }
    }

    public void mouseDragged(JKEditEvent jKEditEvent, JKMouseEvent jKMouseEvent) {
        Event event = jKMouseEvent.getOldEvent();
        if (event != null) {
            this.handleEvent(event, jKEditEvent.getEditAction());
        }
    }

    public void mouseMoved(JKEditEvent jKEditEvent, JKMouseEvent jKMouseEvent) {
        Event event = jKMouseEvent.getOldEvent();
        if (event != null) {
            this.handleEvent(event, jKEditEvent.getEditAction());
        }
    }

    public void keyTyped(JKEditEvent jKEditEvent, JKKeyEvent jKKeyEvent) {
        Event event = jKKeyEvent.getOldEvent();
        if (event != null && this.handleEvent(event, jKEditEvent.getEditAction()) == null) {
            jKEditEvent.getTable().processJKKeyEvent(jKKeyEvent);
        }
    }

    public void keyPressed(JKEditEvent jKEditEvent, JKKeyEvent jKKeyEvent) {
        Event event = jKKeyEvent.getOldEvent();
        if (event != null && this.handleEvent(event, jKEditEvent.getEditAction()) == null) {
            jKEditEvent.getTable().processJKKeyEvent(jKKeyEvent);
        }
    }

    public void keyReleased(JKEditEvent jKEditEvent, JKKeyEvent jKKeyEvent) {
        Event event = jKKeyEvent.getOldEvent();
        if (event != null && this.handleEvent(event, jKEditEvent.getEditAction()) == null) {
            jKEditEvent.getTable().processJKKeyEvent(jKKeyEvent);
        }
    }

    public void focusGained(JKEditEvent jKEditEvent, JKFocusEvent jKFocusEvent) {
        Event event = jKFocusEvent.getOldEvent();
        if (event != null) {
            this.handleEvent(event, jKEditEvent.getEditAction());
        }
    }

    public void focusLost(JKEditEvent jKEditEvent, JKFocusEvent jKFocusEvent) {
        Event event = jKFocusEvent.getOldEvent();
        if (event != null) {
            this.handleEvent(event, jKEditEvent.getEditAction());
        }
    }

    public Object edit(JKEditAction jKEditAction, Object object) {
        return null;
    }

    public Component edit(JKEditAction jKEditAction, Object object, String string) {
        Component component = jKEditAction.getEditor(string);
        this.setupEdit(jKEditAction, component);
        return component;
    }

    public void setupEdit(JKEditAction jKEditAction, Component component) {
        if (component == null) {
            return;
        }
        jKEditAction.predraw();
        component.setForeground(jKEditAction.foreColor());
        component.setBackground(jKEditAction.backColor());
        component.setFont(jKEditAction.font());
    }

    public void requestEditorFocus(JKEditAction jKEditAction, Object object) {
        if (object instanceof Component) {
            ((Component)object).requestFocus();
        }
    }

    public boolean validate(JKEditAction jKEditAction, Object object) {
        return true;
    }

    public Boolean handleEvent(Event event, JKEditAction jKEditAction) {
        if (jKEditAction.editor instanceof Component) {
            Component component = (Component)jKEditAction.editor;
            switch (event.id) {
                case 501: 
                case 502: 
                case 506: {
                    Rectangle rectangle = new Rectangle(component.location(), component.size());
                    if (!rectangle.inside(event.x, event.y)) break;
                    Point point = jKEditAction.owner.cellForPoint(event.x, event.y);
                    if (point.x != jKEditAction.dataX || point.y != jKEditAction.dataY) break;
                    return Boolean.TRUE;
                }
            }
        }
        return null;
    }

    public Rectangle editFrame(Rectangle rectangle, JKEditAction jKEditAction) {
        return rectangle;
    }
}

