/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.area;

import com.objectshare.base.util.OSIEnumeration;
import com.objectshare.base.util.OSIIntEnumeration;
import com.objectshare.base.util.OSIIntVector;
import com.objectshare.grid.area.JKColumnArea;
import com.objectshare.grid.area.JKCompositeArea;
import com.objectshare.grid.area.JKEmptyArea;
import com.objectshare.grid.area.JKFullArea;
import com.objectshare.grid.area.JKRectangularArea;
import com.objectshare.grid.area.JKRowArea;
import com.objectshare.grid.view.JKDimensionPolicy;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;

public abstract class JKTableArea
implements Serializable {
    public static final JKTableArea empty = JKEmptyArea.value;
    public static final JKTableArea full = JKFullArea.value;

    public static JKTableArea newForCell(int n, int n2) {
        return JKTableArea.newForCells(n, n2, 1, 1);
    }

    public static JKTableArea newForCells(int n, int n2, int n3, int n4) {
        return JKRectangularArea.newFor(n, n2, n3, n4);
    }

    public static JKTableArea newForCells(Point[] pointArray) {
        JKTableArea jKTableArea = empty;
        if (pointArray != null) {
            int n = 0;
            while (n < pointArray.length) {
                jKTableArea = jKTableArea.add(JKTableArea.newForCell(pointArray[n].x, pointArray[n].y));
                ++n;
            }
        }
        return jKTableArea;
    }

    public static JKTableArea newBetweenCells(int n, int n2, int n3, int n4) {
        int n5 = n < n3 ? n : n3;
        int n6 = n2 < n4 ? n2 : n4;
        int n7 = (n > n3 ? n : n3) - n5 + 1;
        int n8 = (n2 > n4 ? n2 : n4) - n6 + 1;
        JKTableArea jKTableArea = JKTableArea.newForCells(n5, n6, n7, n8);
        jKTableArea.anchorX(n);
        jKTableArea.anchorY(n2);
        return jKTableArea;
    }

    public static JKTableArea newForColumn(int n) {
        return JKTableArea.newForColumns(n, 1);
    }

    public static JKTableArea newForColumns(int n, int n2) {
        return JKColumnArea.newFor(n, n2);
    }

    public static JKTableArea newForColumns(int[] nArray) {
        JKTableArea jKTableArea = empty;
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length) {
                jKTableArea = jKTableArea.add(JKTableArea.newForColumn(nArray[n]));
                ++n;
            }
        }
        return jKTableArea;
    }

    public static JKTableArea newBetweenColumns(int n, int n2) {
        int n3 = n < n2 ? n : n2;
        int n4 = (n > n2 ? n : n2) - n3 + 1;
        JKTableArea jKTableArea = JKTableArea.newForColumns(n3, n4);
        jKTableArea.anchorX(n);
        return jKTableArea;
    }

    public static JKTableArea newForRow(int n) {
        return JKTableArea.newForRows(n, 1);
    }

    public static JKTableArea newForRows(int n, int n2) {
        return JKRowArea.newFor(n, n2);
    }

    public static JKTableArea newForRows(int[] nArray) {
        JKTableArea jKTableArea = empty;
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length) {
                jKTableArea = jKTableArea.add(JKTableArea.newForRow(nArray[n]));
                ++n;
            }
        }
        return jKTableArea;
    }

    public static JKTableArea newBetweenRows(int n, int n2) {
        int n3 = n < n2 ? n : n2;
        int n4 = (n > n2 ? n : n2) - n3 + 1;
        JKTableArea jKTableArea = JKTableArea.newForRows(n3, n4);
        jKTableArea.anchorY(n);
        return jKTableArea;
    }

    public OSIEnumeration elements() {
        return OSIEnumeration.newFor((Object)this);
    }

    public JKTableArea add(JKTableArea jKTableArea) {
        JKTableArea jKTableArea2 = this.merge(jKTableArea);
        if (jKTableArea2 != null) {
            return jKTableArea2;
        }
        return jKTableArea.addTo(this);
    }

    protected JKTableArea addTo(JKTableArea jKTableArea) {
        return JKCompositeArea.newFor(this, jKTableArea);
    }

    public JKTableArea merge(JKTableArea jKTableArea) {
        if (jKTableArea == full) {
            return full;
        }
        if (jKTableArea == empty) {
            return this;
        }
        return null;
    }

    public JKTableArea subtract(JKTableArea jKTableArea) {
        return jKTableArea.subtractFrom(this);
    }

    protected JKTableArea subtractFrom(JKTableArea jKTableArea) {
        return jKTableArea;
    }

    public JKTableArea xor(JKTableArea jKTableArea) {
        return this.subtract(jKTableArea).add(jKTableArea.subtract(this));
    }

    protected boolean isBefore(JKTableArea jKTableArea) {
        return true;
    }

    public OSIIntEnumeration rows(int n, int n2) {
        return OSIIntEnumeration.newFor();
    }

    public int[] rowsIn(int n, int n2) {
        return this.rows(n, n2).toArray();
    }

    public boolean includesRow(int n) {
        return false;
    }

    public JKTableArea insertRows(int n, int n2) {
        return this;
    }

    public JKTableArea moveRows(int n, int n2, int n3) {
        return this.reorderRows(n2, new OSIIntVector(n, n3));
    }

    public JKTableArea reorderRows(int n, int[] nArray) {
        return this.reorderRows(n, new OSIIntVector(nArray));
    }

    public JKTableArea reorderRows(int n, OSIIntVector oSIIntVector) {
        return this;
    }

    public JKTableArea removeRows(int n, int n2) {
        return this;
    }

    public OSIIntEnumeration columns(int n, int n2) {
        return OSIIntEnumeration.newFor();
    }

    public int[] columnsIn(int n, int n2) {
        return this.columns(n, n2).toArray();
    }

    public boolean includesColumn(int n) {
        return false;
    }

    public JKTableArea insertColumns(int n, int n2) {
        return this;
    }

    public JKTableArea moveColumns(int n, int n2, int n3) {
        return this.reorderColumns(n2, new OSIIntVector(n, n3));
    }

    public JKTableArea reorderColumns(int n, int[] nArray) {
        return this.reorderColumns(n, new OSIIntVector(nArray));
    }

    public JKTableArea reorderColumns(int n, OSIIntVector oSIIntVector) {
        return this;
    }

    public JKTableArea removeColumns(int n, int n2) {
        return this;
    }

    public boolean includesCell(int n, int n2) {
        return false;
    }

    public OSIEnumeration cells(int n, int n2, int n3, int n4) {
        return OSIEnumeration.newFor();
    }

    public Point[] cellsIn(int n, int n2, int n3, int n4) {
        return new Point[0];
    }

    public int anchorX() {
        return 0;
    }

    public int anchorY() {
        return 0;
    }

    public int anchorX(int n) {
        return 0;
    }

    public int anchorY(int n) {
        return 0;
    }

    public int activeX() {
        return this.anchorX();
    }

    public int activeY() {
        return this.anchorY();
    }

    protected Point[] basicCells(int n, int n2, int n3, int n4) {
        int n5 = n3 * n4;
        Point[] pointArray = new Point[n5 > 0 ? n5 : 0];
        int n6 = n5;
        int n7 = n2 + n4;
        while (--n7 >= n2) {
            int n8 = n + n3;
            while (--n8 >= n) {
                pointArray[--n6] = new Point(n8, n7);
            }
        }
        return pointArray;
    }

    protected int[] basicRange(int n, int n2) {
        int[] nArray = new int[n2 > 0 ? n2 : 0];
        int n3 = n2;
        int n4 = n + n2;
        while (--n4 >= n) {
            nArray[--n3] = n4;
        }
        return nArray;
    }

    public OSIEnumeration asVirtualBounds(JKDimensionPolicy jKDimensionPolicy, Rectangle rectangle) {
        return this.asVirtualBounds(jKDimensionPolicy, "java.lang.Object", rectangle);
    }

    public OSIEnumeration asVirtualBounds(JKDimensionPolicy jKDimensionPolicy, String string, Rectangle rectangle) {
        return OSIEnumeration.newFor((Object[])this.asVirtualBoundsArray(jKDimensionPolicy, string, rectangle));
    }

    public Rectangle[] asVirtualBoundsArray(JKDimensionPolicy jKDimensionPolicy, Rectangle rectangle) {
        return this.asVirtualBoundsArray(jKDimensionPolicy, "java.lang.Object", rectangle);
    }

    public Rectangle[] asVirtualBoundsArray(JKDimensionPolicy jKDimensionPolicy, String string, Rectangle rectangle) {
        Rectangle[] rectangleArray = new Rectangle[]{this.asVirtualBoundary(jKDimensionPolicy, string, rectangle)};
        return rectangleArray;
    }

    public Rectangle asVirtualBoundary(JKDimensionPolicy jKDimensionPolicy, Rectangle rectangle) {
        return this.asVirtualBoundary(jKDimensionPolicy, "java.lang.Object", rectangle);
    }

    public Rectangle asVirtualBoundary(JKDimensionPolicy jKDimensionPolicy, String string, Rectangle rectangle) {
        return new Rectangle(rectangle.x, rectangle.y, 0, 0);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

